/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.CtxStatus;
import cms.tmx.entity.trade.EtfStrategy;
import cms.tmx.fund.models.EtfAutoMktMakerMng;
import cms.tmx.fund.views.AddStrategyDialog;
import cms.tmx.fund.views.EtfAutoErrorMsgDialog;
import cms.tmx.fund.views.UpdateStrategyDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxListUtils;
import cmx.tmx.data.IRefDataMng;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtfAutoMktMakerPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(EtfAutoMktMakerPart.class);
    private MxList<EtfStrategy> mlist = new MxList();
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnUpdate;
    @FXML
    private Button btnDel;
    @FXML
    private Button btnStart;
    @FXML
    private Button btnStop;
    @FXML
    private Button btnPause;
    @FXML
    private Button btnResume;
    @FXML
    private TableView<EtfStrategy> tableStrategy;
    @FXML
    private TableColumn<EtfStrategy, Boolean> selected;
    @FXML
    private TableColumn<EtfStrategy, String> errorMsg;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private EtfAutoMktMakerMng model;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng ref;
    private Future<?> future;
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> this.mlist.update(this.model.getList(), p -> true));
    private InvalidationListener listener = ob -> this.refresh();

    @FXML
    public void initialize() {
        this.createTable();
        this.model.changedProperty().addListener(this.lstnModel);
        this.ref.changedProperty().addListener(this.listener);
        this.future = this.ses.scheduleWithFixedDelay(() -> this.refresh(), 0L, 2L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.model.changedProperty().removeListener(this.lstnModel);
        this.ref.changedProperty().removeListener(this.listener);
    }

    private void createTable() {
        this.tableStrategy.setPlaceholder((Node)new Label());
        CheckBox checkBox = new CheckBox();
        this.selected.setGraphic((Node)checkBox);
        checkBox.selectedProperty().addListener((ob, old, now) -> this.tableStrategy.getItems().forEach(item -> item.setSelected(now.booleanValue())));
        TableUtils.initValueFactory(this.tableStrategy);
        this.selected.setCellValueFactory(data -> {
            BooleanProperty bp = ((EtfStrategy)data.getValue()).selectedProperty();
            bp.addListener((ob, old, now) -> this.checkBtnStatus());
            return bp;
        });
        this.tableStrategy.setItems(this.mlist.getList());
        this.errorMsg.setCellFactory(data -> new AutoTableCell());
    }

    private void checkBtnStatus() {
        this.btnUpdate.setDisable(true);
        this.btnDel.setDisable(true);
        this.btnStart.setDisable(true);
        this.btnStop.setDisable(true);
        this.btnPause.setDisable(true);
        this.btnResume.setDisable(true);
        int selectedNum = 0;
        int runningNum = 0;
        int pausingNum = 0;
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            ++selectedNum;
            switch (strategy.getStatus().getRaw()) {
                case "1": {
                    ++runningNum;
                    break;
                }
                case "3": {
                    ++pausingNum;
                    break;
                }
            }
        }
        if (selectedNum == 1 && runningNum == 0 && pausingNum == 0) {
            this.btnUpdate.setDisable(false);
        }
        if (selectedNum > 0) {
            this.btnDel.setDisable(false);
        }
        if (selectedNum - runningNum > 0) {
            this.btnStart.setDisable(false);
        }
        if (runningNum > 0 || pausingNum > 0) {
            this.btnStop.setDisable(false);
        }
        if (runningNum > 0) {
            this.btnPause.setDisable(false);
        }
        if (pausingNum > 0) {
            this.btnResume.setDisable(false);
        }
    }

    private void refresh() {
        try {
            try {
                this.model.query();
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        Platform.runLater(() -> this.checkBtnStatus());
    }

    @FXML
    public void add() {
        AddStrategyDialog obj = (AddStrategyDialog)((Object)this.of.create(AddStrategyDialog.class));
        obj.nameList = this.model.getCodeList();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7b56\u7565");
        if (dialog.launch() == ButtonType.OK) {
            this.refresh();
            MxListUtils.lastToFirst((List)this.mlist.getList());
            this.tableStrategy.getSelectionModel().select(0);
        }
    }

    @FXML
    public void update() {
        UpdateStrategyDialog obj = (UpdateStrategyDialog)((Object)this.of.create(UpdateStrategyDialog.class));
        EtfStrategy strategy = (EtfStrategy)this.of.create(EtfStrategy.class);
        for (EtfStrategy str : this.tableStrategy.getItems()) {
            if (!str.isSelected()) continue;
            strategy.update(str);
            obj.setStrategy(strategy);
        }
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u7b56\u7565");
        if (dialog.launch() == ButtonType.OK) {
            this.refresh();
        }
    }

    @FXML
    public void delete() {
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u505c\u6b62\u6267\u884c\u4e2d\u6216\u6682\u505c\u7684\u7b56\u7565");
            return;
        }
        boolean bDel = this.alert.check(false, Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664\u52fe\u9009\u7684\u7b56\u7565\uff1f");
        if (!bDel) {
            return;
        }
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected()) continue;
            try {
                this.model.delStrategy(strategy.getContextId());
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                e.printStackTrace();
            }
        }
        this.refresh();
    }

    private List<EtfStrategy> filterMsg(ObservableList<CtxStatus> list) {
        ObservableList msgList = FxUtils.newList();
        list.forEach(ctx -> this.tableStrategy.getItems().forEach(item -> {
            if (ctx.getContextId().equals(item.getContextId())) {
                item.setErrorMsg(String.valueOf(ctx.getStatus()));
                msgList.add(item);
            }
        }));
        return msgList;
    }

    @FXML
    public void execute() {
        ArrayList<String> listId = new ArrayList<String>();
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || strategy.getStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            ObservableList<CtxStatus> list = this.model.startStrategy(listId);
            FilteredList ctxList = list.filtered(ctx -> ctx.getStatus() != 1);
            if (ctxList.size() > 0) {
                EtfAutoErrorMsgDialog obj = (EtfAutoErrorMsgDialog)((Object)this.of.create(EtfAutoErrorMsgDialog.class));
                obj.setStrategies(this.filterMsg((ObservableList<CtxStatus>)ctxList));
                MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u9519\u8bef\u63d0\u793a");
                dialog.launch();
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
        this.refresh();
    }

    @FXML
    public void stop() {
        ArrayList<String> listId = new ArrayList<String>();
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1") && !strategy.getStatus().getRaw().equals("3")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            ObservableList<CtxStatus> list = this.model.stopStrategy(listId);
            FilteredList ctxList = list.filtered(ctx -> ctx.getStatus() != 1);
            if (ctxList.size() > 0) {
                EtfAutoErrorMsgDialog obj = (EtfAutoErrorMsgDialog)((Object)this.of.create(EtfAutoErrorMsgDialog.class));
                obj.setStrategies(this.filterMsg((ObservableList<CtxStatus>)ctxList));
                MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u9519\u8bef\u63d0\u793a");
                dialog.launch();
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
        this.refresh();
    }

    @FXML
    public void pause() {
        ArrayList<String> listId = new ArrayList<String>();
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("1")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            ObservableList<CtxStatus> list = this.model.pauseStrategy(listId);
            FilteredList ctxList = list.filtered(ctx -> ctx.getStatus() != 1);
            if (ctxList.size() > 0) {
                EtfAutoErrorMsgDialog obj = (EtfAutoErrorMsgDialog)((Object)this.of.create(EtfAutoErrorMsgDialog.class));
                obj.setStrategies(this.filterMsg((ObservableList<CtxStatus>)ctxList));
                MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u9519\u8bef\u63d0\u793a");
                dialog.launch();
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
        this.refresh();
    }

    @FXML
    public void recover() {
        ArrayList<String> listId = new ArrayList<String>();
        for (EtfStrategy strategy : this.tableStrategy.getItems()) {
            if (!strategy.isSelected() || !strategy.getStatus().getRaw().equals("3")) continue;
            listId.add(strategy.getContextId());
        }
        try {
            ObservableList<CtxStatus> list = this.model.resumeStrategy(listId);
            FilteredList ctxList = list.filtered(ctx -> ctx.getStatus() != 1);
            if (ctxList.size() > 0) {
                EtfAutoErrorMsgDialog obj = (EtfAutoErrorMsgDialog)((Object)this.of.create(EtfAutoErrorMsgDialog.class));
                obj.setStrategies(this.filterMsg((ObservableList<CtxStatus>)ctxList));
                MxDialog dialog = this.df.create((DialogObj)obj, "\u64cd\u4f5c\u9519\u8bef\u63d0\u793a");
                dialog.launch();
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            e.printStackTrace();
        }
        this.refresh();
    }

    public class AutoTableCell<S, T>
    extends TableCell<EtfStrategy, T> {
        EtfStrategy orderExtra;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.orderExtra = (EtfStrategy)EtfStrategy.class.cast(this.getTableRow().getItem());
                if (this.orderExtra == null) {
                    this.setText(null);
                    return;
                }
                if (!this.orderExtra.getErrorMsg().equals("") && this.orderExtra.getStatus().getRaw().equals("2")) {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (boolean)true);
                } else {
                    FxUtils.makePC((Node)this.getTableRow(), (String)"etfErrorStatus", (boolean)false);
                }
                this.setText(this.orderExtra.getErrorMsg());
            } else {
                this.setText(null);
            }
        }
    }
}

