/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.define.IErrorMsg;
import cms.tmx.entity.trade.EtfStrategy;
import cms.tmx.javafx.MxList;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javax.inject.Inject;

public class EtfAutoErrorMsgDialog
extends DialogObj {
    @FXML
    private TableView<EtfStrategy> tableStrategy;
    @FXML
    private TableColumn<EtfStrategy, String> index;
    @FXML
    private GridPane gridPaneAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private MxList<EtfStrategy> mlist = new MxList();
    @FXML
    private TableColumn<EtfStrategy, String> contextId;
    @FXML
    private TableColumn<EtfStrategy, String> security;
    @FXML
    private TableColumn<EtfStrategy, String> secName;
    @FXML
    private TableColumn<EtfStrategy, String> name;
    @FXML
    private TableColumn<EtfStrategy, String> status;
    @FXML
    private TableColumn<EtfStrategy, String> investorId;
    @FXML
    private TableColumn<EtfStrategy, String> errorMsg;
    private List<EtfStrategy> strategies;
    @Inject
    private IErrorMsg msg;

    @FXML
    public void initialize() {
        this.createTable();
    }

    private void createTable() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.contextId.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getContextId()));
        this.name.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getName()));
        this.security.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getSecurity()));
        this.secName.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getSecName()));
        this.investorId.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getInvestorId()));
        this.contextId.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getContextId()));
        this.contextId.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getContextId()));
        this.status.setCellValueFactory(m -> new SimpleStringProperty(((EtfStrategy)m.getValue()).getStatus().getValue()));
        this.errorMsg.setCellFactory(data -> new AutoTableCell());
        this.mlist.addAll(this.getStrategies());
        this.tableStrategy.setItems(this.mlist.getList());
        this.tableStrategy.setPlaceholder((Node)new Label());
    }

    public List<EtfStrategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(List<EtfStrategy> strategies) {
        this.strategies = strategies;
    }

    public class AutoTableCell<S, T>
    extends TableCell<EtfStrategy, T> {
        EtfStrategy orderExtra;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.orderExtra = (EtfStrategy)EtfStrategy.class.cast(this.getTableRow().getItem());
                if (this.orderExtra == null) {
                    this.setText(null);
                    return;
                }
                this.setText(EtfAutoErrorMsgDialog.this.msg.getMsg(Integer.valueOf(this.orderExtra.getErrorMsg()).intValue()));
                this.setStyle("-fx-text-fill:red");
            } else {
                this.setText(null);
            }
        }
    }
}

