/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.models;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.EtfTradeSettings;
import cms.tmx.web.service.IUserSettingsService;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserEtfMonitPreCtrl {
    @Inject
    protected MEventService es;
    @Inject
    protected IUserSettingsService usMng;
    protected String funcPanelType;
    protected String menuId;
    private boolean popBeforeOrder = true;
    private boolean popBeforeCancel = true;
    private boolean priceChooseAll;
    private static final Logger logger = LogManager.getLogger(UserEtfMonitPreCtrl.class);
    private StringProperty fundAccnt = new SimpleStringProperty("");
    private MEventHandler reload = event -> {
        if (this.funcPanelType == null || this.menuId == null) {
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof EtfTradeSettings) {
                this.getUserSetting((EtfTradeSettings)EtfTradeSettings.class.cast(settings));
            }
        }
        catch (MException mException) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25");
        }
    };

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.initSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", this.reload);
    }

    public void doSet() throws MException {
        if (this.funcPanelType == null || this.menuId == null) {
            return;
        }
        BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
        if (settings instanceof EtfTradeSettings) {
            this.getUserSetting((EtfTradeSettings)EtfTradeSettings.class.cast(settings));
        }
    }

    private void initSet() {
        this.setPopBeforeOrder(true);
        this.setPopBeforeCancel(true);
        this.setPriceChooseAll(true);
    }

    public void getUserSetting(EtfTradeSettings settings) {
        this.setPopBeforeOrder(settings.getPopBeforeOrder().equals("1"));
        this.setPopBeforeCancel(settings.getPopBeforeCancel().equals("1"));
        this.setFundAccnt(settings.getDefFundAccount().getInvestorId());
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public boolean isPopBeforeOrder() {
        return this.popBeforeOrder;
    }

    public void setPopBeforeOrder(boolean popBeforeOrder) {
        this.popBeforeOrder = popBeforeOrder;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    public boolean isPriceChooseAll() {
        return this.priceChooseAll;
    }

    public void setPriceChooseAll(boolean priceChooseAll) {
        this.priceChooseAll = priceChooseAll;
    }

    public final StringProperty fundAccntProperty() {
        return this.fundAccnt;
    }

    public final String getFundAccnt() {
        return (String)this.fundAccntProperty().get();
    }

    public final void setFundAccnt(String fundAccnt) {
        this.fundAccntProperty().set((Object)fundAccnt);
    }
}

