/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.models;

import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.EtfTradeSettings;
import cms.tmx.fund.views.StrategyDialog;
import cms.tmx.web.service.IUserSettingsService;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserEtfAutoPreCtrl {
    @Inject
    protected MEventService es;
    @Inject
    protected IUserSettingsService usMng;
    protected String funcPanelType;
    protected String menuId;
    private boolean popBeforeOrder = true;
    private boolean popBeforeCancel = true;
    private int priceChoose;
    private static final Logger logger = LogManager.getLogger(UserEtfAutoPreCtrl.class);
    private StrategyDialog strategyDialog;
    private StringProperty fundAccnt = new SimpleStringProperty("");
    private StringProperty SecAccnt = new SimpleStringProperty("");
    private SimpleStringProperty defBenchmark = new SimpleStringProperty("");
    private DoubleProperty buyPriceFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty upDownPriceFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightPriceFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty defBuyDiff = new SimpleDoubleProperty(0.0);
    private DoubleProperty defSellDiff = new SimpleDoubleProperty(0.0);
    private LongProperty buyQuantity = new SimpleLongProperty(0L);
    private LongProperty sellQuantity = new SimpleLongProperty(0L);
    private DoubleProperty upDownQuantityFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightQuantityFloat = new SimpleDoubleProperty(0.0);
    private MEventHandler reload = event -> {
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof EtfTradeSettings) {
                this.getUserSetting((EtfTradeSettings)EtfTradeSettings.class.cast(settings));
                this.initControls();
            }
        }
        catch (MException mException) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25");
        }
    };

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.initSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", this.reload);
    }

    public void doSet() throws MException {
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof EtfTradeSettings) {
                this.getUserSetting((EtfTradeSettings)EtfTradeSettings.class.cast(settings));
            }
        }
        finally {
            this.initControls();
        }
    }

    public void selectTwoOrAllPriceDecimal() {
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.getPriceChoose(), (TextField)this.strategyDialog.getSpnThreshold().getEditor());
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.getPriceChoose(), (TextField)this.strategyDialog.getSpnDiffBuy().getEditor());
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.getPriceChoose(), (TextField)this.strategyDialog.getSpnDiffSell().getEditor());
    }

    private void initSet() {
        this.setPopBeforeOrder(true);
        this.setPopBeforeCancel(true);
        this.setPriceChoose(1);
    }

    public void getUserSetting(EtfTradeSettings settings) {
        this.setPopBeforeOrder(settings.getPopBeforeOrder().equals("1"));
        this.setPopBeforeCancel(settings.getPopBeforeCancel().equals("1"));
        this.setPriceChoose(settings.getPriceChoose());
        this.setDefBuyDiff(settings.getDefBuyDiff());
        this.setDefSellDiff(settings.getDefSellDiff());
        this.setDefBenchmark(settings.getDefBenchmark());
        this.setFundAccnt(settings.getDefFundAccount().getInvestorId());
        this.setSecAccnt(settings.getDefSecurityAccount());
        this.setUpDownPriceFloat(settings.getUpDownPriceFloat());
        this.setLeftRightPriceFloat(settings.getLeftRightPriceFloat());
        this.setBuyQuantity(settings.getBuyQuantity());
        this.setSellQuantity(settings.getSellQuantity());
        this.setUpDownQuantityFloat(settings.getUpDownQuantityFloat());
        this.setLeftRightQuantityFloat(settings.getLeftRightQuantityFloat());
        this.setBuyPriceFloat(settings.getBuyPriceFloat());
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void initControls() {
        SpinnerUtils.addDoubleArrowKeyHandler(this.getStrategyDialog().getSpnThreshold(), (ObservableNumberValue)this.upDownPriceFloatProperty(), (ObservableNumberValue)this.leftRightPriceFloatProperty());
        SpinnerUtils.addDoubleArrowKeyHandler(this.getStrategyDialog().getSpnDiffBuy(), (ObservableNumberValue)this.upDownPriceFloatProperty(), (ObservableNumberValue)this.leftRightPriceFloatProperty());
        SpinnerUtils.addDoubleArrowKeyHandler(this.getStrategyDialog().getSpnDiffSell(), (ObservableNumberValue)this.upDownPriceFloatProperty(), (ObservableNumberValue)this.leftRightPriceFloatProperty());
        SpinnerUtils.addIntArrowKeyHandler(this.getStrategyDialog().getSpnQtyBuy(), (ObservableNumberValue)this.upDownQuantityFloatProperty(), (ObservableNumberValue)this.leftRightQuantityFloatProperty());
        SpinnerUtils.addIntArrowKeyHandler(this.getStrategyDialog().getSpnQtySell(), (ObservableNumberValue)this.upDownQuantityFloatProperty(), (ObservableNumberValue)this.leftRightQuantityFloatProperty());
    }

    public boolean isPopBeforeOrder() {
        return this.popBeforeOrder;
    }

    public void setPopBeforeOrder(boolean popBeforeOrder) {
        this.popBeforeOrder = popBeforeOrder;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    public int getPriceChoose() {
        return this.priceChoose;
    }

    public void setPriceChoose(int priceChoose) {
        this.priceChoose = priceChoose;
    }

    public final StringProperty fundAccntProperty() {
        return this.fundAccnt;
    }

    public final String getFundAccnt() {
        return (String)this.fundAccntProperty().get();
    }

    public final void setFundAccnt(String fundAccnt) {
        this.fundAccntProperty().set((Object)fundAccnt);
    }

    public final StringProperty SecAccntProperty() {
        return this.SecAccnt;
    }

    public final String getSecAccnt() {
        return (String)this.SecAccntProperty().get();
    }

    public final void setSecAccnt(String SecAccnt) {
        this.SecAccntProperty().set((Object)SecAccnt);
    }

    public final SimpleStringProperty defBenchmarkProperty() {
        return this.defBenchmark;
    }

    public final String getDefBenchmark() {
        return this.defBenchmarkProperty().get();
    }

    public final void setDefBenchmark(String defBenchmark) {
        this.defBenchmarkProperty().set(defBenchmark);
    }

    public final DoubleProperty buyPriceFloatProperty() {
        return this.buyPriceFloat;
    }

    public final double getBuyPriceFloat() {
        return this.buyPriceFloatProperty().get();
    }

    public final void setBuyPriceFloat(double buyPriceFloat) {
        this.buyPriceFloatProperty().set(buyPriceFloat);
    }

    public final DoubleProperty upDownPriceFloatProperty() {
        return this.upDownPriceFloat;
    }

    public final double getUpDownPriceFloat() {
        return this.upDownPriceFloatProperty().get();
    }

    public final void setUpDownPriceFloat(double upDownPriceFloat) {
        this.upDownPriceFloatProperty().set(upDownPriceFloat);
    }

    public final DoubleProperty leftRightPriceFloatProperty() {
        return this.leftRightPriceFloat;
    }

    public final double getLeftRightPriceFloat() {
        return this.leftRightPriceFloatProperty().get();
    }

    public final void setLeftRightPriceFloat(double leftRightPriceFloat) {
        this.leftRightPriceFloatProperty().set(leftRightPriceFloat);
    }

    public final DoubleProperty defBuyDiffProperty() {
        return this.defBuyDiff;
    }

    public final double getDefBuyDiff() {
        return this.defBuyDiffProperty().get();
    }

    public final void setDefBuyDiff(double defBuyDiff) {
        this.defBuyDiffProperty().set(defBuyDiff);
    }

    public final DoubleProperty defSellDiffProperty() {
        return this.defSellDiff;
    }

    public final double getDefSellDiff() {
        return this.defSellDiffProperty().get();
    }

    public final void setDefSellDiff(double defSellDiff) {
        this.defSellDiffProperty().set(defSellDiff);
    }

    public final LongProperty buyQuantityProperty() {
        return this.buyQuantity;
    }

    public final long getBuyQuantity() {
        return this.buyQuantityProperty().get();
    }

    public final void setBuyQuantity(long buyQuantity) {
        this.buyQuantityProperty().set(buyQuantity);
    }

    public final LongProperty sellQuantityProperty() {
        return this.sellQuantity;
    }

    public final long getSellQuantity() {
        return this.sellQuantityProperty().get();
    }

    public final void setSellQuantity(long sellQuantity) {
        this.sellQuantityProperty().set(sellQuantity);
    }

    public final DoubleProperty upDownQuantityFloatProperty() {
        return this.upDownQuantityFloat;
    }

    public final double getUpDownQuantityFloat() {
        return this.upDownQuantityFloatProperty().get();
    }

    public final void setUpDownQuantityFloat(double upDownQuantityFloat) {
        this.upDownQuantityFloatProperty().set(upDownQuantityFloat);
    }

    public final DoubleProperty leftRightQuantityFloatProperty() {
        return this.leftRightQuantityFloat;
    }

    public final double getLeftRightQuantityFloat() {
        return this.leftRightQuantityFloatProperty().get();
    }

    public final void setLeftRightQuantityFloat(double leftRightQuantityFloat) {
        this.leftRightQuantityFloatProperty().set(leftRightQuantityFloat);
    }

    public StrategyDialog getStrategyDialog() {
        return this.strategyDialog;
    }

    public void setStrategyDialog(StrategyDialog strategyDialog) {
        this.strategyDialog = strategyDialog;
    }
}

