/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.models;

import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.api.trade.IOrderCancelReplaceApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.fund.api.IEtfTradeModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.trade.entrust.SingleEntrust;
import cmx.tmx.data.IMarketDataMng;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class EtfManualTradeModel
implements IEtfTradeModel {
    private ObjectProperty<FundAccount> fundAcct = new SimpleObjectProperty();
    private ObjectProperty<SecAccount> secAcct = new SimpleObjectProperty();
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private StringProperty base = new SimpleStringProperty("");
    private DoubleProperty basePrice = new SimpleDoubleProperty();
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty diffBuy = new SimpleDoubleProperty();
    private DoubleProperty diffSell = new SimpleDoubleProperty();
    private DoubleProperty priceBuy = new SimpleDoubleProperty();
    private DoubleProperty priceSell = new SimpleDoubleProperty();
    private LongProperty countBuy = new SimpleLongProperty();
    private LongProperty countSell = new SimpleLongProperty();
    private StringProperty tradeType = new SimpleStringProperty("FUND");
    private String market;
    private MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private INewOrderSingleApi submit;
    @Inject
    private ICancelOrderApi cancel;
    @Inject
    private IOrderCancelReplaceApi replace;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(10);
    }

    public void onSecChange() {
        this.mktItem.setRefItem(this.getValidRef());
        this.mktMng.dye(this.mktItem);
        this.setMarket(this.mktItem.getRefItem().getMarket());
        if (!this.mktItem.getStop().getValue().booleanValue()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item.getType().equals(this.getTradeType())) {
            return item;
        }
        return null;
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public void submit(String accntId, String secAccntId, double buyprice, int buynum, double sellprice, int sellnum, Instrument instrument) throws MException {
        PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
        builder.setSecurityId(instrument.getSecId());
        builder.setMarket(instrument.getMarket().getRaw());
        builder.setSecurityType(instrument.getSecType());
        builder.setApplId("010");
        PComponent.ExecMode.Builder moBuilder = PComponent.ExecMode.newBuilder();
        moBuilder.setEmName("\u624b\u5de5");
        moBuilder.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_MANUAL);
        this.submit.etfNewOrder(accntId, secAccntId, buyprice, buynum, sellprice, sellnum, builder.build(), moBuilder.build());
    }

    public int cancel(String accntId, String secAccntId, int buynum, CrossOrder order, Instrument instrument) throws MException {
        POrderService.CrossOrder.Builder ccsBuilder = POrderService.CrossOrder.newBuilder();
        ccsBuilder.setCrossId(order.getId());
        ccsBuilder.setCrossType(order.getCrossType());
        PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
        builder.setSecurityId(instrument.getSecId());
        builder.setMarket(instrument.getMarket().getRaw());
        builder.setSecurityType(instrument.getSecType());
        builder.setApplId("010");
        int status = this.cancel.etfCancelOrder(accntId, secAccntId, buynum, ccsBuilder.build(), builder.build());
        return status;
    }

    public int cancelReplace(String accntId, String secAccntId, double buyprice, int buynum, double sellprice, int sellnum, Instrument instrument, CrossOrder order) throws MException {
        POrderService.CrossOrder.Builder ccsBuilder = POrderService.CrossOrder.newBuilder();
        ccsBuilder.setCrossId(order.getId());
        ccsBuilder.setCrossType(order.getCrossType());
        PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
        builder.setSecurityId(instrument.getSecId());
        builder.setMarket(instrument.getMarket().getRaw());
        builder.setSecurityType(instrument.getSecType());
        builder.setApplId("010");
        PComponent.ExecMode.Builder moBuilder = PComponent.ExecMode.newBuilder();
        moBuilder.setEmName("\u624b\u5de5");
        moBuilder.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_MANUAL);
        int status = this.replace.etfCancelReplaceOrder(accntId, secAccntId, buyprice, buynum, sellprice, sellnum, builder.build(), ccsBuilder.build(), moBuilder.build());
        return status;
    }

    public final ObjectProperty<FundAccount> fundAcctProperty() {
        return this.fundAcct;
    }

    public final FundAccount getFundAcct() {
        return (FundAccount)this.fundAcctProperty().get();
    }

    public final void setFundAcct(FundAccount fundAcct) {
        this.fundAcctProperty().set((Object)fundAcct);
    }

    public final ObjectProperty<SecAccount> secAcctProperty() {
        return this.secAcct;
    }

    public final SecAccount getSecAcct() {
        return (SecAccount)this.secAcctProperty().get();
    }

    public final void setSecAcct(SecAccount secAcct) {
        this.secAcctProperty().set((Object)secAcct);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final StringProperty baseProperty() {
        return this.base;
    }

    public final String getBase() {
        return (String)this.baseProperty().get();
    }

    public final void setBase(String base) {
        this.baseProperty().set((Object)base);
    }

    public final DoubleProperty basePriceProperty() {
        return this.basePrice;
    }

    public final double getBasePrice() {
        return this.basePriceProperty().get();
    }

    public final void setBasePrice(double basePrice) {
        this.basePriceProperty().set(basePrice);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final DoubleProperty diffBuyProperty() {
        return this.diffBuy;
    }

    public final double getDiffBuy() {
        return this.diffBuyProperty().get();
    }

    public final void setDiffBuy(double diffBuy) {
        this.diffBuyProperty().set(diffBuy);
    }

    public final DoubleProperty diffSellProperty() {
        return this.diffSell;
    }

    public final double getDiffSell() {
        return this.diffSellProperty().get();
    }

    public final void setDiffSell(double diffSell) {
        this.diffSellProperty().set(diffSell);
    }

    public final DoubleProperty priceBuyProperty() {
        return this.priceBuy;
    }

    public final double getPriceBuy() {
        return this.priceBuyProperty().get();
    }

    public final void setPriceBuy(double priceBuy) {
        this.priceBuyProperty().set(priceBuy);
    }

    public final DoubleProperty priceSellProperty() {
        return this.priceSell;
    }

    public final double getPriceSell() {
        return this.priceSellProperty().get();
    }

    public final void setPriceSell(double priceSell) {
        this.priceSellProperty().set(priceSell);
    }

    public final LongProperty countBuyProperty() {
        return this.countBuy;
    }

    public final long getCountBuy() {
        return this.countBuyProperty().get();
    }

    public final void setCountBuy(long countBuy) {
        this.countBuyProperty().set(countBuy);
    }

    public final LongProperty countSellProperty() {
        return this.countSell;
    }

    public final long getCountSell() {
        return this.countSellProperty().get();
    }

    public final void setCountSell(long countSell) {
        this.countSellProperty().set(countSell);
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public final StringProperty tradeTypeProperty() {
        return this.tradeType;
    }

    public final String getTradeType() {
        return (String)this.tradeTypeProperty().get();
    }

    public final void setTradeType(String tradeType) {
        this.tradeTypeProperty().set((Object)tradeType);
    }

    public SingleEntrust createEntrust(String acc, String secAcc) {
        return null;
    }

    public DoubleProperty priceProperty() {
        return null;
    }

    public double getPrice() {
        return 0.0;
    }

    public void setPrice(double price) {
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return null;
    }

    public MxNode getPriceStg() {
        return null;
    }

    public void setPriceStg(MxNode node) {
    }

    public LongProperty countProperty() {
        return null;
    }

    public long getCount() {
        return 0L;
    }

    public void setCount(long count) {
    }
}

