/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IEtfMarketMakerApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.proto.strategy.PMarketMaking;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.trade.CtxStatus;
import cms.tmx.entity.trade.EtfStrategy;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IRefDataMng;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class EtfAutoMktMakerMng
extends MxModel {
    private ObservableList<EtfStrategy> list = FxUtils.newList();
    private List<String> nameList = new ArrayList<String>();
    @Inject
    private IBaseApi iba;
    @Inject
    private IEtfMarketMakerApi api;
    @Inject
    private IRefDataMng ref;
    @Inject
    private MObjFactory of;
    @Inject
    private MEventService es;
    @Inject
    private QueryModel queryModel;
    private static final Logger logger = LogManager.getLogger(EtfAutoMktMakerMng.class);

    @PostConstruct
    public void init() {
        this.es.subscribe("etf.auto.query", event -> this.queryAuto(event));
    }

    private void queryAuto(MEvent event) {
        try {
            this.query();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (InvalidProtocolBufferException eBufferException) {
            logger.error((Object)eBufferException, (Throwable)eBufferException);
        }
    }

    public ObservableList<EtfStrategy> getList() {
        return this.list;
    }

    public List<String> getCodeList() {
        return this.nameList;
    }

    public synchronized void query() throws MException, InvalidProtocolBufferException {
        PStrategy.GetCtxSettingsReq.Builder builder = PStrategy.GetCtxSettingsReq.newBuilder();
        builder.setMarketGroup("CCS");
        builder.setOpUser(this.iba.getOpUser());
        builder.setExecModeTypeValue(6);
        List list = this.api.getStrategy(builder.build());
        this.updateData(list);
        this.changed();
    }

    private void updateData(List<PStrategy.ContextSettings> listInfo) throws InvalidProtocolBufferException {
        this.list.clear();
        this.nameList.clear();
        for (PStrategy.ContextSettings info : listInfo) {
            EtfStrategy strategy = (EtfStrategy)this.of.create(EtfStrategy.class);
            Any any = info.getDetails();
            if (any.is(PMarketMaking.MarketMakingContextSettings.class)) {
                PMarketMaking.MarketMakingContextSettings context = (PMarketMaking.MarketMakingContextSettings)any.unpack(PMarketMaking.MarketMakingContextSettings.class);
                strategy.setInvestorId(this.queryModel.getInvestId(context.getAccount().getExtFundAccntId()));
                strategy.setInvestorSecId(this.queryModel.getInverstorSecId(context.getAccount().getExtSecAccntId()));
                if (this.ref.getItem(context.getSecurity().getInstrument().getMarket(), context.getSecurity().getInstrument().getSecurityId()) != null) {
                    strategy.setSecName(this.ref.getItem(context.getSecurity().getInstrument().getMarket(), context.getSecurity().getInstrument().getSecurityId()).getName());
                }
            }
            strategy.update(info);
            this.list.add((Object)strategy);
            this.nameList.add(info.getName().toStringUtf8());
        }
    }

    public void addStrategy(EtfStrategy strategy) throws MException {
        PMarketMaking.AccountSettings.Builder builderAcct = PMarketMaking.AccountSettings.newBuilder();
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
        builderInst.setSecurityId(strategy.getSecurity());
        builderInst.setSecurityType(strategy.getSecurityType());
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        PMarketMaking.SecuritySettings.Builder builderSec = PMarketMaking.SecuritySettings.newBuilder();
        builderSec.setInstrument(builderInst);
        String refPrice = "[" + strategy.getSecurity() + "]." + strategy.getRefPriceCustom().getRaw();
        builderSec.setRefPriceCustom(refPrice);
        builderSec.setPriceSlip(strategy.getPriceSlip());
        builderSec.setBidSpread(strategy.getBidSpread());
        builderSec.setAskSpread(strategy.getAskSpread());
        builderSec.setMaxSpread(strategy.getMaxSpread());
        builderSec.setBidQty(strategy.getBidQty());
        builderSec.setAskQty(strategy.getAskQty());
        PMarketMaking.MarketMakingContextSettings.Builder builderCtx = PMarketMaking.MarketMakingContextSettings.newBuilder();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        PStrategy.ContextSettings.Builder builderCt = PStrategy.ContextSettings.newBuilder();
        builderCt.setName(ByteString.copyFrom((byte[])strategy.getName().getBytes()));
        builderCt.setContextId(strategy.getContextId());
        builderCt.setUserId(this.iba.getUserId());
        builderCt.setPartyId(this.iba.getPartyId());
        builderCt.setPostId(this.iba.getPostId());
        builderCt.setCreateTime(strategy.getCreateTime());
        builderCt.setCtxStateValue(Integer.valueOf(strategy.getStatus().getRaw()).intValue());
        builderCt.setErrorMsg(strategy.getErrorMsg());
        builderCt.setDetails(Any.pack((Message)builderCtx.build()));
        builderCt.setStrategyType(PStrategy.StrategyType.forNumber((int)Integer.valueOf(strategy.getTacticsType().getRaw())));
        PStrategy.NewCtxSettingsReq.Builder builder = PStrategy.NewCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(builderCt);
        builder.setExecModeTypeValue(6);
        this.api.addStrategy(builder.build());
    }

    public void updateStrategy(EtfStrategy strategy) throws MException {
        PMarketMaking.AccountSettings.Builder builderAcct = PMarketMaking.AccountSettings.newBuilder();
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
        builderInst.setSecurityId(strategy.getSecurity());
        builderInst.setSecurityType(strategy.getSecurityType());
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        PMarketMaking.SecuritySettings.Builder builderSec = PMarketMaking.SecuritySettings.newBuilder();
        builderSec.setInstrument(builderInst);
        String refPrice = "[" + strategy.getSecurity() + "]." + strategy.getRefPriceCustom().getRaw();
        builderSec.setRefPriceCustom(refPrice);
        builderSec.setPriceSlip(strategy.getPriceSlip());
        builderSec.setBidSpread(strategy.getBidSpread());
        builderSec.setAskSpread(strategy.getAskSpread());
        builderSec.setMaxSpread(strategy.getMaxSpread());
        builderSec.setBidQty(strategy.getBidQty());
        builderSec.setAskQty(strategy.getAskQty());
        PMarketMaking.MarketMakingContextSettings.Builder builderCtx = PMarketMaking.MarketMakingContextSettings.newBuilder();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        PStrategy.ContextSettings.Builder builderCt = PStrategy.ContextSettings.newBuilder();
        builderCt.setName(ByteString.copyFrom((byte[])strategy.getName().getBytes()));
        builderCt.setContextId(strategy.getContextId());
        builderCt.setUserId(this.iba.getUserId());
        builderCt.setPartyId(this.iba.getPartyId());
        builderCt.setPostId(this.iba.getPostId());
        builderCt.setCreateTime(strategy.getCreateTime());
        builderCt.setCtxStateValue(Integer.valueOf(strategy.getStatus().getRaw()).intValue());
        builderCt.setErrorMsg(strategy.getErrorMsg());
        builderCt.setDetails(Any.pack((Message)builderCtx.build()));
        builderCt.setStrategyType(PStrategy.StrategyType.forNumber((int)Integer.valueOf(strategy.getTacticsType().getRaw())));
        PStrategy.UpdateCtxSettingsReq.Builder builder = PStrategy.UpdateCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(builderCt);
        builder.setExecModeTypeValue(6);
        this.api.updateStrategy(builder.build());
    }

    public void delStrategy(String contextId) throws MException {
        PStrategy.DeleteCtxSettingsReq.Builder builder = PStrategy.DeleteCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setContextId(contextId);
        builder.setExecModeTypeValue(6);
        this.api.delStrategy(builder.build());
    }

    public ObservableList<CtxStatus> startStrategy(List<String> listId) throws MException {
        PStrategy.StartContextReq.Builder builder = PStrategy.StartContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(6);
        List list = this.api.startStrategy(builder.build());
        ObservableList ctxList = FxUtils.newList();
        list.forEach(item -> {
            CtxStatus ctx = (CtxStatus)this.of.create(CtxStatus.class);
            ctx.update(item);
            ctxList.add((Object)ctx);
        });
        return ctxList;
    }

    public ObservableList<CtxStatus> stopStrategy(List<String> listId) throws MException {
        PStrategy.StopContextReq.Builder builder = PStrategy.StopContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(6);
        List list = this.api.stopStrategy(builder.build());
        ObservableList ctxList = FxUtils.newList();
        list.forEach(item -> {
            CtxStatus ctx = (CtxStatus)this.of.create(CtxStatus.class);
            ctx.update(item);
            ctxList.add((Object)ctx);
        });
        return ctxList;
    }

    public ObservableList<CtxStatus> pauseStrategy(List<String> listId) throws MException {
        PStrategy.PauseContextReq.Builder builder = PStrategy.PauseContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(6);
        List list = this.api.pauseStrategy(builder.build());
        ObservableList ctxList = FxUtils.newList();
        list.forEach(item -> {
            CtxStatus ctx = (CtxStatus)this.of.create(CtxStatus.class);
            ctx.update(item);
            ctxList.add((Object)ctx);
        });
        return ctxList;
    }

    public ObservableList<CtxStatus> resumeStrategy(List<String> listId) throws MException {
        PStrategy.ResumeContextReq.Builder builder = PStrategy.ResumeContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(6);
        List list = this.api.resumeStrategy(builder.build());
        ObservableList ctxList = FxUtils.newList();
        list.forEach(item -> {
            CtxStatus ctx = (CtxStatus)this.of.create(CtxStatus.class);
            ctx.update(item);
            ctxList.add((Object)ctx);
        });
        return ctxList;
    }
}

