/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.service.impl;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.web.api.settings.impl.UserSettingsApiImpl;
import cms.tmx.web.service.IUserSettingsService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UserSettingsServiceImpl
implements IUserSettingsService {
    private static final Logger logger = LogManager.getLogger(UserSettingsServiceImpl.class);
    @Inject
    private UserSettingsApiImpl usApi;
    private Map<String, BaseSettings> settingsMap = new HashMap<String, BaseSettings>();
    @Inject
    private MEventService es;
    @Inject
    private ExecutorService exe;

    @PostConstruct
    private void init() {
        this.es.subscribe("settingsDialogClose", event -> this.refreshSettingsCache());
    }

    private void refreshSettingsCache() {
        this.exe.execute(() -> {
            try {
                this.cacheAllSettings();
            }
            catch (MException | Exception e) {
                logger.error("\u5237\u65b0\u7528\u6237\u8bbe\u7f6e\u7f13\u5b58\u5931\u8d25", e);
            }
        });
    }

    @Override
    public void cacheAllSettings() throws MException {
        this.settingsMap = this.usApi.getAllSettings();
        this.es.postEvent("settingsRefresh", null);
    }

    @Override
    public BaseSettings getSettingsDetail(String funcPanelType, String menuId) throws MException {
        if (funcPanelType == null || menuId == null) {
            logger.error("\u9519\u8bef\u7684\u8c03\u7528");
            throw new MException(1, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff1a" + funcPanelType + "|" + menuId);
        }
        BaseSettings detail = this.settingsMap.get(menuId);
        if (detail == null) {
            detail = this.usApi.getSettingsDetail(funcPanelType, menuId);
            this.settingsMap.put(menuId, detail);
        }
        return detail;
    }

    @Override
    public void updateSettingsDetail(BaseSettings settings) throws MException {
        if (settings == null) {
            logger.error("\u9519\u8bef\u7684\u8c03\u7528");
            throw new MException(1, "\u4fee\u6539\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff1a" + settings);
        }
        this.usApi.updateSettingsDetail(settings);
    }

    @Override
    public BaseSettings getTipsSettings(String funcPanelType, String menuId) throws MException {
        if (funcPanelType == null || menuId == null) {
            logger.error("\u9519\u8bef\u7684\u8c03\u7528");
            throw new MException(1, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u53c2\u6570\u9519\u8bef\uff1a" + funcPanelType + "|" + menuId);
        }
        BaseSettings detail = this.settingsMap.get(menuId);
        return detail;
    }
}

