/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.workflow.impl;

import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.resp.ResponseData;
import cms.tmx.entity.web.workflow.CancelWorkflowReq;
import cms.tmx.entity.web.workflow.ComplateTaskReq;
import cms.tmx.entity.web.workflow.GetWorkflowCurrentTaskResp;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateReq;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateResp;
import cms.tmx.entity.web.workflow.TaskLog;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowTaskList;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import com.google.gson.Gson;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WorkflowTemplateApiImpl
implements WorkflowTemplateApi {
    private static final Logger logger = LogManager.getLogger(WorkflowTemplateApiImpl.class);
    @Inject
    private HttpClientService httpClient;
    private Gson gson = new Gson();
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private HttpClientService httpService;
    @Inject
    private MConfService ms;

    @Override
    public GetWorkflowTemplateResp getWorkflowTemplate(GetWorkflowTemplateReq req) throws MException {
        String resp = this.httpClient.doPostJson("/workflow/instance/model", this.gson.toJson((Object)req), true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            logger.error("\u67e5\u8be2\u6307\u4ee4\u6d41\u6a21\u677f\u5931\u8d25\uff1a" + respData.getMessage());
            throw new MException(999994, "\u67e5\u8be2\u6307\u4ee4\u6d41\u6a21\u677f\u5931\u8d25" + respData.getMessage());
        }
        return (GetWorkflowTemplateResp)this.gson.fromJson(this.gson.toJson(respData.getRes()), GetWorkflowTemplateResp.class);
    }

    @Override
    public Map<String, WorkflowTaskList> getWorkflowCurrentTasks(List<String> workflowIds) throws MException {
        HashMap<String, WorkflowTaskList> resMap = new HashMap<String, WorkflowTaskList>();
        for (String flowId : workflowIds) {
            if (StringUtils.isEmpty((String)flowId)) continue;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("workflowIds", flowId);
            param.put("userId", this.baseApi.getHttpOpUser().getUserId());
            param.put("position", this.baseApi.getHttpOpUser().getPostId());
            String resp = this.httpClient.doGet("/workflow/inner/currenttasks", param, true);
            ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
            if (respData == null || !respData.reqSuccess()) {
                logger.error("\u67e5\u8be2\u6307\u4ee4\u6d41\u6a21\u677f\u5931\u8d25\uff1a" + respData.getMessage());
                throw new MException(999994, "\u67e5\u8be2\u6307\u4ee4\u6d41\u6a21\u677f\u5931\u8d25" + respData.getMessage());
            }
            GetWorkflowCurrentTaskResp tasksResp = (GetWorkflowCurrentTaskResp)this.gson.fromJson(this.gson.toJson(respData.getRes()), GetWorkflowCurrentTaskResp.class);
            for (WorkflowTaskList tasks : tasksResp.getList()) {
                if (tasks == null) continue;
                resMap.put(tasks.getWorkflowId(), tasks);
            }
        }
        return resMap;
    }

    @Override
    public ResponseData<?> complateTask(ComplateTaskReq req) throws MException {
        req.setOpUser(this.baseApi.getHttpOpUser());
        String resp = this.httpClient.doPostJson("/workflow/inner/completetask", this.gson.toJson((Object)req), true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            logger.error("\u6307\u4ee4\u4efb\u52a1\u6267\u884c\u5931\u8d25" + respData.getMessage());
            throw new MException(999994, "\u6307\u4ee4\u4efb\u52a1\u6267\u884c\u5931\u8d25" + respData.getMessage());
        }
        return respData;
    }

    @Override
    public void cancelWorkflow(CancelWorkflowReq req) throws MException {
        req.setOpUser(this.baseApi.getHttpOpUser());
        String resp = this.httpClient.doPostJson("/workflow/inner/cancel", this.gson.toJson((Object)req), true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            logger.error("\u6307\u4ee4\u64a4\u9500\u5931\u8d25" + respData.getMessage());
            throw new MException(999994, "\u6307\u4ee4\u64a4\u9500\u5931\u8d25" + respData.getMessage());
        }
    }

    @Override
    public WorkflowAttachment uploadAttachment(File file) throws MException {
        String url = String.valueOf(this.ms.getValue("web.domain")) + "api/workflow/file/upload";
        String resp = this.httpService.doPostJson(url, "file", file);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            String msg = respData == null ? "" : respData.getMessage();
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25  " + msg);
            throw new MException(999994, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25  " + msg);
        }
        return (WorkflowAttachment)this.gson.fromJson(this.gson.toJson(respData.getRes()), WorkflowAttachment.class);
    }

    @Override
    public void recordTaskLog(TaskLog req) throws MException {
        String resp = this.httpClient.doPostJson("/workflow/inner/tasklog", this.gson.toJson((Object)req), true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            String msg = respData == null ? "" : respData.getMessage();
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25  " + msg);
            throw new MException(999994, "\u8bb0\u5f55\u65b0\u6846\u67b6\u6307\u4ee4\u6267\u884c\u65e5\u5fd7\u5931\u8d25  " + msg);
        }
    }
}

