/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.settings.impl;

import cms.tmx.core.MException;
import cms.tmx.entity.web.resp.ResponseData;
import cms.tmx.entity.web.settings.AutoExportFLowsSettings;
import cms.tmx.entity.web.settings.AutoExportSettings;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.BasketTradeSettings;
import cms.tmx.entity.web.settings.BasketUISettings;
import cms.tmx.entity.web.settings.BondUISettings;
import cms.tmx.entity.web.settings.CcsTradeSettings;
import cms.tmx.entity.web.settings.CtpTradeSettings;
import cms.tmx.entity.web.settings.DisklessSettings;
import cms.tmx.entity.web.settings.ETFUISettings;
import cms.tmx.entity.web.settings.EtfTradeSettings;
import cms.tmx.entity.web.settings.FastTradeSettings;
import cms.tmx.entity.web.settings.FutureMktMakingSettings;
import cms.tmx.entity.web.settings.LockSettings;
import cms.tmx.entity.web.settings.NoticeTipsSettings;
import cms.tmx.entity.web.settings.OrderTipsSettings;
import cms.tmx.entity.web.settings.PortfBasketTradeSettings;
import cms.tmx.entity.web.settings.StockUISettings;
import cms.tmx.web.api.core.HttpClientService;
import cms.tmx.web.api.settings.UserSettingsApi;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UserSettingsApiImpl
implements UserSettingsApi {
    private static final Logger logger = LogManager.getLogger(UserSettingsApiImpl.class);
    @Inject
    private HttpClientService httpClient;
    private Gson gson = new Gson();

    @Override
    public BaseSettings getSettingsDetail(String funcPanelType, String menuId) throws MException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("funcPanelType", funcPanelType);
        paramMap.put("menuId", menuId);
        String resp = this.httpClient.doGet("/settings/detail", paramMap, true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            throw new MException(999994, "\u6839\u636efuncPanelType\u548cmenuId\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u8be6\u60c5\u5931\u8d25,funcPanelType=" + funcPanelType + ",menuId=" + menuId + respData.getMessage());
        }
        return (BaseSettings)this.gson.fromJson(this.gson.toJson(respData.getRes()), this.getSettingsClass(menuId));
    }

    @Override
    public void updateSettingsDetail(BaseSettings settings) throws MException {
        String resp = this.httpClient.doPostJson("/settings/updating", this.gson.toJson((Object)settings), true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            throw new MException(999994, "\u4fee\u6539\u7528\u6237\u8bbe\u7f6e\u8be6\u60c5\u5931\u8d25,funcPanelType=" + settings.getFuncPanelType() + ",menuId=" + settings.getMenuId() + respData.getMessage());
        }
    }

    private Class getSettingsClass(String menuId) {
        switch (menuId) {
            case "000002": {
                return LockSettings.class;
            }
            case "000001": {
                return OrderTipsSettings.class;
            }
            case "200001": {
                return CcsTradeSettings.class;
            }
            case "200002": {
                return CcsTradeSettings.class;
            }
            case "200003": {
                return CcsTradeSettings.class;
            }
            case "200005002": {
                return CtpTradeSettings.class;
            }
            case "200050": {
                return FastTradeSettings.class;
            }
            case "200052": {
                return CcsTradeSettings.class;
            }
            case "200001001": {
                return StockUISettings.class;
            }
            case "200003001": {
                return BondUISettings.class;
            }
            case "200002001": {
                return StockUISettings.class;
            }
            case "200005001": {
                return BondUISettings.class;
            }
            case "200007001": {
                return ETFUISettings.class;
            }
            case "200006": {
                return EtfTradeSettings.class;
            }
            case "200052001": {
                return StockUISettings.class;
            }
            case "200015001": {
                return BasketUISettings.class;
            }
            case "200058": {
                return CcsTradeSettings.class;
            }
            case "000003": {
                return AutoExportSettings.class;
            }
            case "200089": {
                return FutureMktMakingSettings.class;
            }
            case "400001": {
                return DisklessSettings.class;
            }
            case "200065002": {
                return BasketTradeSettings.class;
            }
            case "200065001": {
                return PortfBasketTradeSettings.class;
            }
            case "000004": {
                return NoticeTipsSettings.class;
            }
            case "000005": {
                return AutoExportFLowsSettings.class;
            }
        }
        return BaseSettings.class;
    }

    @Override
    public Map<String, BaseSettings> getAllSettings() throws MException {
        HashMap<String, BaseSettings> resultMap = new HashMap<String, BaseSettings>();
        String resp = this.httpClient.doGet("/settings/all-detail", null, true);
        ResponseData respData = (ResponseData)this.gson.fromJson(resp, ResponseData.class);
        if (respData == null || !respData.reqSuccess()) {
            throw new MException(999994, "\u7f13\u5b58\u5168\u91cf\u7528\u6237\u8bbe\u7f6e\u8be6\u60c5\u5931\u8d25" + respData.getMessage());
        }
        for (String menuId : ((Map)respData.getRes()).keySet()) {
            try {
                resultMap.put(menuId, (BaseSettings)this.gson.fromJson(this.gson.toJson(((Map)respData.getRes()).get(menuId)), this.getSettingsClass(menuId)));
            }
            catch (Exception exception) {
                logger.error("menuId :" + menuId + "\u8f6c\u6362\u51fa\u9519");
                logger.error("menuId :" + menuId + ", json :" + this.gson.toJson(((Map)respData.getRes()).get(menuId)));
                continue;
            }
            logger.info("menuId :" + menuId + ", json :" + this.gson.toJson(((Map)respData.getRes()).get(menuId)));
        }
        return resultMap;
    }
}

