/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.settings;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.OrderTipsSettings;
import cms.tmx.web.service.IUserSettingsService;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class UserPreOrderTips {
    private static final Logger logger = LogManager.getLogger(UserPreOrderTips.class);
    @Inject
    private IUserSettingsService usService;
    @Inject
    private MEventService es;
    private Boolean orderTips = true;
    private Boolean cancelOrderTips = true;
    @Inject
    private ExecutorService exe;

    public boolean getOrderTips() {
        return this.orderTips;
    }

    public boolean getCancelOrderTips() {
        return this.cancelOrderTips;
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("settingsRefresh", event -> this.reset());
        this.exe.execute(() -> this.reset());
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", event -> this.reset());
    }

    private void reset() {
        try {
            OrderTipsSettings setting = (OrderTipsSettings)OrderTipsSettings.class.cast(this.usService.getSettingsDetail("0", "000001"));
            this.orderTips = setting.getOrderTips();
            this.cancelOrderTips = setting.getCancelOrderTips();
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

