/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.settings;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.LockSettings;
import cms.tmx.web.service.IUserSettingsService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class UserPreLockSettings {
    private static final Logger logger = LogManager.getLogger(UserPreLockSettings.class);
    @Inject
    private IUserSettingsService usService;
    @Inject
    private MEventService es;
    private LockSettings lockSet = new LockSettings();
    private Boolean autoLock = false;
    private int lockTime = 900;

    public boolean getAutoLock() {
        return this.autoLock;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    @PostConstruct
    private void init() {
        this.es.subscribe("settingsRefresh", event -> this.reset(event));
    }

    private void reset(MEvent event) {
        try {
            this.lockSet = (LockSettings)this.usService.getSettingsDetail("0", "000002");
            this.autoLock = this.lockSet.getAutoLock();
            this.lockTime = this.lockSet.getLockTime();
            logger.error("\u81ea\u52a8\u9501\u5c4f\u5f00\u5173\u4e3a\uff1a" + this.autoLock);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

