/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.interaction;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.web.api.core.HttpClientService;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WebInteraction {
    private static final Logger logger = LogManager.getLogger(WebInteraction.class);
    private static final String ROLE_ID_KEY = "roleId";
    @Inject
    private MEventService es;
    @Inject
    private HttpClientService httpClient;

    @PostConstruct
    private void init() {
        this.es.subscribe("refresh_web_cache", event -> {
            Object object = this.refreshWebCache(event);
        });
    }

    private Object refreshWebCache(MEvent event) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("type", event.getStr("type"));
        paramMap.put("id", event.getStr("id"));
        try {
            this.httpClient.doGet("/auth/refresh-cache", paramMap, true);
        }
        catch (MException e) {
            logger.error("\u8c03\u7528\u5237\u7f13\u5b58\u63a5\u53e3\u5931\u8d25 /auth/refresh-cache " + paramMap, (Throwable)e);
        }
        return null;
    }
}

