/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.core;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryIntercepter
implements Interceptor {
    private static final Logger logger = LogManager.getLogger(RetryIntercepter.class);
    public int MAX = 3;
    public int maxRetry;
    private int retryNum = 0;

    public RetryIntercepter(int maxRetry) {
        if (maxRetry > this.MAX) {
            maxRetry = this.MAX;
        }
        this.maxRetry = maxRetry;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        logger.info("retryNum=" + this.retryNum);
        Response response = chain.proceed(request);
        while (!response.isSuccessful() && this.retryNum < this.maxRetry) {
            ++this.retryNum;
            if (response.body() != null) {
                response.close();
            }
            response = chain.proceed(request);
        }
        return response;
    }
}

