/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.web.api.core;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.entity.web.credit.CreditToken;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.MD5Utils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.TrustAllCerts;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import okhttp3.CacheControl;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HttpClientService {
    private static final Logger logger = LogManager.getLogger(HttpClientService.class);
    @Inject
    private IBaseApi baseApi;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private Gson gson = new Gson();
    @Inject
    private MConfService ms;
    @Inject
    private MEventService me;
    private static final String LOGIN_URL = "/user/clientLogin";
    private static final String baseUrl = "api";
    public static final long CONNECT_TIMEOUT = 10L;
    public static final long READ_TIMEOUT = 10L;
    public static final long SHORT_CONNECT = 2L;
    public static final long SHORT_READ = 2L;
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final double RESP_NO_LOGIN_ERROR = 302.0;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String TOKEN_KEY = "Z22tCwrJg3AE4TdO1mqLjRkXcIS9hz";
    private AtomicBoolean tokenExpire = new AtomicBoolean(true);
    private long lastSuccess = System.currentTimeMillis();
    private long lastTokenSuccess = System.currentTimeMillis();
    private long SIX_HOUR = 21600000L;
    private OkHttpClient okHttpClient;
    private OkHttpClient okHttpClientLongTimeOut;

    public synchronized OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = this.buildHttpClient(10L, 10L);
        }
        return this.okHttpClient;
    }

    public synchronized OkHttpClient getOkHttpClientLongTimeOut() {
        if (this.okHttpClientLongTimeOut == null) {
            this.okHttpClientLongTimeOut = this.buildHttpClient(60L, 60L);
        }
        return this.okHttpClientLongTimeOut;
    }

    private boolean isHttp(String url) {
        Pattern pattern = Pattern.compile("(http):\\/\\/([\\w.]+\\/?)\\S*", 2);
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    public String getAppVersion(String url, boolean significant) throws MException {
        return this.getVersion(url, null, GET, 10L, 10L, significant);
    }

    public String getAppVersionHisList(String url, boolean significant) throws MException {
        return this.getVersion(url, null, GET, 10L, 10L, significant);
    }

    public String doGet(String url, Map<String, String> data, boolean significant) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doGet(url, data, significant, 0);
    }

    public Response doGet(String url) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.downloadtWithLogin(this.buildUrl(url, null), GET, false, "", 3);
    }

    public Response doGet(String url, String cookie) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.downloadtWithLogin(this.buildUrl(url, null), GET, false, cookie, 3);
    }

    public Response download(String url) throws MException {
        return this.downloadtWithLogin(url, GET, false, "", 3);
    }

    public Response download(String url, String cookie) throws MException {
        return this.downloadtWithLogin(url, GET, false, cookie, 3);
    }

    public String doGet(String url, Map<String, String> data, boolean significant, int retry) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequestWithLogin(this.buildUrl(url, data), null, GET, 10L, 10L, significant, retry);
    }

    public String doPostFailFast(String url, String dataJson) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequestWithLogin(this.buildUrl(url, null), dataJson, POST, 2L, 2L, false, 0);
    }

    public String doPostJson(String url, String dataJson, boolean significant) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequestWithLogin(this.buildUrl(url, null), dataJson, POST, 10L, 10L, significant, 0);
    }

    public String doPostJson(String url, Map<String, String> dataMap) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequest(url, dataMap, POST, 10L, 10L, 0);
    }

    public String doPostJson2(String url, String dataJson) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequest(url, dataJson, POST, 10L, 10L, 0);
    }

    public String doGetWithUrl(String url, String dataJson) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequest(url, dataJson, GET, 10L, 10L, 0);
    }

    public String doPostJson(String url, String param, File file) throws MException {
        return this.doRequest(url, param, file, POST, 10L, 10L, 0);
    }

    public Response doPostCredit(String url) throws MException {
        logger.info(String.valueOf(url) + " " + Thread.currentThread().getName());
        return this.doRequest(url, POST);
    }

    private String getVersion(String url, String dataJson, String method, long connectTimeout, long readTimeout, boolean significant) {
        if (url.isEmpty()) {
            return null;
        }
        long start = System.currentTimeMillis();
        Response response = null;
        InputStream is = null;
        BufferedReader bufferedReader = null;
        String version = "";
        try {
            Request.Builder rbuilder = new Request.Builder().cacheControl(new CacheControl.Builder().noCache().build());
            rbuilder.url(url);
            rbuilder.addHeader("Cache-Control", "no-Cache");
            rbuilder.addHeader("Connection", "close");
            if (!StringUtils.isEmpty((String)this.baseApi.getAccessToken())) {
                rbuilder.addHeader("access-token", this.baseApi.getAccessToken());
            }
            if (!StringUtils.isEmpty((String)this.baseApi.getRefreshToken())) {
                rbuilder.addHeader("refresh-token", this.baseApi.getRefreshToken());
            }
            if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
                rbuilder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
            }
            Request request = rbuilder.build();
            logger.info("http request " + url + "  " + method);
            response = this.getOkHttpClient().newCall(request).execute();
            InputStream inputStream = is = response.body() == null ? null : response.body().byteStream();
            if (is == null) {
                return null;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(is));
            String readLine = bufferedReader.readLine();
            while (readLine != null) {
                version = String.valueOf(version) + readLine;
                readLine = bufferedReader.readLine();
            }
            if (response.isSuccessful()) {
                String string = version.trim();
                return string;
            }
            logger.error("http response error \u5f02\u5e38 " + request.url() + " , " + response.code());
            return null;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + dataJson, e);
            return null;
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.error("get version faild", (Throwable)e);
                }
            }
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private String doRequestWithLogin(String url, String dataJson, String method, long connectTimeout, long readTimeout, boolean significant, int retry) throws MException {
        String str = this.doRequest(url, dataJson, method, connectTimeout, readTimeout, 0);
        if (!significant) {
            if (!this.isSuccess(str)) {
                this.parseException(str);
            }
            return str;
        }
        if (!this.isSuccess(str)) {
            if (this.isTokenExpire(str) || this.lastSuccessBeforeSixHour()) {
                this.loginAndSetToken();
            }
            logger.info(" ======= !tokenExpire.get() " + !this.tokenExpire.get());
            if (!this.tokenExpire.get()) {
                if (retry != 0) {
                    --retry;
                }
                str = this.doRequest(url, dataJson, method, 2L, 2L, retry);
            }
        }
        if (!this.isSuccess(str)) {
            this.parseException(str);
        }
        return str;
    }

    private void parseException(String str) throws MException {
        if (str != null && !"".equals(str)) {
            Map map = (Map)this.gson.fromJson(str, HashMap.class);
            if (500.0 == (Double)map.get("code")) {
                throw new MException(999994, map.get("message") == null ? "" : map.get("message").toString());
            }
            throw new MException(999994, "\u548c\u540e\u53f0\u901a\u8baf\u5931\u8d25");
        }
        throw new MException(999994, "\u548c\u540e\u53f0\u901a\u8baf\u5931\u8d25");
    }

    private Response downloadtWithLogin(String url, String method, boolean significant, String cookie, int retry) throws MException {
        Response doRequest = this.doDownload(url, method, cookie);
        if (doRequest == null) {
            throw new MException(999994, "\u4e0b\u8f7d\u8bf7\u6c42\u8d85\u65f6");
        }
        String header = doRequest.header("Content-Type");
        boolean failed = header.contains("json");
        if (!significant) {
            if (failed) {
                throw new MException(999994, "\u548c\u540e\u53f0\u901a\u8baf\u5931\u8d25");
            }
            return doRequest;
        }
        if (failed) {
            if (failed) {
                this.loginAndSetToken();
            }
            logger.info(" ======= !tokenExpire.get() " + !this.tokenExpire.get());
            if (!this.tokenExpire.get()) {
                if (retry != 0) {
                    --retry;
                }
                doRequest = this.doDownload(url, method, cookie);
            }
        }
        if (failed) {
            throw new MException(999994, "\u548c\u540e\u53f0\u901a\u8baf\u5931\u8d25");
        }
        return doRequest;
    }

    private String doRequest(String url, String dataJson, String method, long connectTimeout, long readTimeout, int retry) {
        long start = System.currentTimeMillis();
        try {
            Request request = this.buildRequest(url, method, dataJson, this.buildCookie(""));
            String string = this.proceedRequest(request);
            return string;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + dataJson, e);
            return null;
        }
        finally {
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private Response doRequestLogin(String url, String dataJson, String method, long connectTimeout, long readTimeout, int retry) {
        long start = System.currentTimeMillis();
        try {
            Request request = this.buildRequest(url, method, dataJson, this.buildCookie(""));
            Response response = this.proceedLogin(request);
            return response;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + dataJson, e);
            return null;
        }
        finally {
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private Response doDownload(String url, String method, String cookie) {
        long start = System.currentTimeMillis();
        try {
            Request request = this.buildRequest(url, method, "", this.buildCookie(cookie));
            Response response = this.proceedStreamRequest(request);
            return response;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method, e);
            return null;
        }
        finally {
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private String doRequest(String url, Map<String, String> dataMap, String method, long connectTimeout, long readTimeout, int retry) {
        long start = System.currentTimeMillis();
        try {
            Request request = this.buildRequest(url, method, dataMap, this.buildCookie(""));
            String string = this.proceedRequest(request);
            return string;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + dataMap, e);
            return null;
        }
        finally {
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private Response doRequest(String url, String method) throws MException {
        long start = System.currentTimeMillis();
        try {
            Request request = this.buildRequest(url, method, "", this.buildCookie(""));
            Response response = this.proceedRequestReturnResp(request);
            return response;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + null, e);
            return null;
        }
        finally {
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private String doRequest(String url, String param, File file, String method, long connectTimeout, long readTimeout, int retry) throws MException {
        long start = System.currentTimeMillis();
        try {
            Request request = this.buildRequest(url, param, method, file, this.buildCookie(""));
            String string = this.proceedRequest(request);
            return string;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + file, e);
            throw new MException(6666, "https\u8bf7\u6c42\u5f02\u5e38");
        }
        finally {
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private String buildCookie(String cookie) {
        StringBuilder sb = new StringBuilder("");
        sb.append("cms_s_token=").append(this.baseApi.getToken());
        if (!StringUtils.isEmpty((String)cookie)) {
            sb.append("; ").append(cookie);
        }
        return sb.toString();
    }

    public synchronized boolean loginAndSetToken() {
        int retry = 3;
        String token = "";
        String accessToken = "";
        String refreshToken = "";
        String cmstmxToken = "";
        boolean firstLogin = true;
        if (!this.tokenExpire.get() && this.baseApi.getToken() != null && !"".equals(this.baseApi.getToken())) {
            if (this.lastTokenSuccessBeforeSixHour()) {
                logger.info("loginAndSetToken token EXPIRE " + StringUtils.replaceToken((String)this.baseApi.getToken()));
                firstLogin = false;
            } else {
                logger.info("loginAndSetToken token exists " + StringUtils.replaceToken((String)this.baseApi.getToken()));
                return true;
            }
        }
        long start = System.currentTimeMillis();
        String fullUrl = this.buildUrl(LOGIN_URL, null);
        String dataJson = this.buildLoginParam(firstLogin);
        do {
            --retry;
            try {
                Response resp = this.doRequestLogin(fullUrl, dataJson, POST, 10L, 10L, 0);
                String resultString = resp.body().string();
                LinkedTreeMap<String, String> result = this.getTokenFromResult(resultString);
                token = (String)result.get((Object)"oldToken");
                accessToken = (String)result.get((Object)"accessToken");
                refreshToken = (String)result.get((Object)"refreshToken");
                cmstmxToken = (String)result.get((Object)"cmstmxToken");
            }
            catch (Throwable e) {
                logger.error("login error ", e);
            }
        } while ((token == null || "".equals(token)) && retry > 0);
        logger.info("loginAndSetToken takes " + (System.currentTimeMillis() - start) + " " + StringUtils.replaceToken((String)token) + " " + LOGIN_URL);
        if (token != null && !"".equals(token)) {
            this.baseApi.setToken(token);
            this.baseApi.setRefreshToken(refreshToken);
            this.baseApi.setAccessToken(accessToken);
            this.baseApi.setCmstmxToken(cmstmxToken);
            this.tokenExpire.compareAndSet(true, false);
            logger.info("loginAndSetToken set new token ======== \u8bbe\u7f6e token \u6210\u529f======== " + StringUtils.replaceToken((String)this.baseApi.getToken()));
            return true;
        }
        return false;
    }

    private LinkedTreeMap<String, String> getTokenFromResult(String resultString) {
        Map map;
        if (resultString != null && !"".equals(resultString) && 200.0 == (Double)(map = (Map)this.gson.fromJson(resultString, HashMap.class)).get("code") && map.get("res") != null) {
            return (LinkedTreeMap)map.get("res");
        }
        return null;
    }

    private Request buildRequest(String url, String method, String dataJson, String cookie) throws MException {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (cookie != null && !"".equals(cookie)) {
            builder.header("Cookie", cookie);
        }
        builder.addHeader("Cache-Control", "no-cache");
        if (!StringUtils.isEmpty((String)this.baseApi.getAccessToken())) {
            builder.addHeader("access-token", this.baseApi.getAccessToken());
        }
        if (!StringUtils.isEmpty((String)this.baseApi.getRefreshToken())) {
            builder.addHeader("refresh-token", this.baseApi.getRefreshToken());
        }
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        if (POST.equals(method)) {
            if (dataJson != null && !"".equals(dataJson)) {
                builder.post(FormBody.create((MediaType)JSON, (String)dataJson));
            } else {
                builder.post(FormBody.create(null, (String)""));
            }
        } else if (GET.equals(method)) {
            builder.get();
        } else {
            throw new MException(999994, "\u8bf7\u6c42\u65b9\u6cd5\u975ePOST\uff0cGET");
        }
        logger.info("http request " + url + "  " + method + " cookie: " + StringUtils.replaceCookie((String)cookie) + " data: " + dataJson);
        return builder.build();
    }

    private Request buildRequest(String url, String method, Map<String, String> dataMap, String cookie) throws MException {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (cookie != null && !"".equals(cookie)) {
            builder.header("Cookie", cookie);
        }
        builder.addHeader("Cache-Control", "no-cache");
        if (!StringUtils.isEmpty((String)this.baseApi.getAccessToken())) {
            builder.addHeader("access-token", this.baseApi.getAccessToken());
        }
        if (!StringUtils.isEmpty((String)this.baseApi.getRefreshToken())) {
            builder.addHeader("refresh-token", this.baseApi.getRefreshToken());
        }
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        if (POST.equals(method)) {
            if (dataMap != null && !dataMap.isEmpty()) {
                FormBody.Builder bodyBuild = new FormBody.Builder();
                for (Map.Entry<String, String> entry : dataMap.entrySet()) {
                    bodyBuild.add(entry.getKey(), entry.getValue());
                }
                FormBody formBody = bodyBuild.build();
                builder.post((RequestBody)formBody);
            } else {
                builder.post(FormBody.create(null, (String)""));
            }
        } else if (GET.equals(method)) {
            builder.get();
        } else {
            throw new MException(999994, "\u8bf7\u6c42\u65b9\u6cd5\u975ePOST\uff0cGET");
        }
        logger.info("http request " + url + "  " + method + " cookie: " + StringUtils.replaceCookie((String)cookie) + " data: " + dataMap);
        return builder.build();
    }

    private Request buildRequest(String url, String param, String method, File file, String cookie) throws MException {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (cookie != null && !"".equals(cookie)) {
            builder.header("Cookie", cookie);
        }
        builder.addHeader("Cache-Control", "no-cache");
        if (!StringUtils.isEmpty((String)this.baseApi.getAccessToken())) {
            builder.addHeader("access-token", this.baseApi.getAccessToken());
        }
        if (!StringUtils.isEmpty((String)this.baseApi.getRefreshToken())) {
            builder.addHeader("refresh-token", this.baseApi.getRefreshToken());
        }
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        if (POST.equals(method)) {
            if (file != null) {
                String fileType = HttpClientService.getMimeType(file.getName());
                MultipartBody.Builder mbuilder = new MultipartBody.Builder();
                mbuilder.setType(MultipartBody.FORM);
                mbuilder.addFormDataPart(param, file.getName(), RequestBody.create((MediaType)MediaType.parse((String)fileType), (File)file));
                builder.post((RequestBody)mbuilder.build());
                logger.info("\u6587\u4ef6\u4e0a\u4f20\uff1a" + file.getName());
            } else {
                builder.post(FormBody.create(null, (String)""));
            }
        } else if (GET.equals(method)) {
            builder.get();
        } else {
            throw new MException(999994, "\u8bf7\u6c42\u65b9\u6cd5\u975ePOST\uff0cGET");
        }
        logger.info("http request " + url + "  " + method + " cookie: " + StringUtils.replaceCookie((String)cookie) + " data: " + file);
        return builder.build();
    }

    private static String getMimeType(String filename) {
        FileNameMap filenameMap = URLConnection.getFileNameMap();
        String contentType = filenameMap.getContentTypeFor(filename);
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private OkHttpClient buildHttpClient(long connectTimeout, long readTimeout) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(connectTimeout, TimeUnit.SECONDS).readTimeout(readTimeout, TimeUnit.SECONDS);
        builder.sslSocketFactory(this.createSSLSocketFactory());
        builder.hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        return builder.build();
    }

    private String buildLoginParam(boolean firstLogin) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        long loginTime = System.currentTimeMillis();
        param.put("userId", this.baseApi.getUserId());
        param.put("partyId", this.baseApi.getPartyId());
        param.put("postId", this.baseApi.getPostId());
        param.put("regionId", 0);
        param.put("loginTime", loginTime);
        param.put("mac", CommUtils.getMAC());
        String ip = "";
        try {
            ip = DesEncrypt.encrypt((String)(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip")));
            param.put("ip", ip);
            param.put("localIp", DesEncrypt.encrypt((String)CommUtils.getIP()));
        }
        catch (Exception e) {
            logger.error("ip\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
        param.put("sn", CommUtils.getSerialNumber());
        param.put("uuid", this.me.getAppId());
        param.put("cpu", CommUtils.getCPUSerial());
        param.put("sno", "");
        param.put("pcn", CommUtils.getPCName());
        param.put("pi", CommUtils.getPI());
        param.put("vol", CommUtils.getVolNew());
        param.put("osv", CommUtils.getOSV());
        param.put("port", this.eCore.getInt("port"));
        param.put("terminalType", "PC");
        JsonObject jsonObj = new JsonObject();
        jsonObj.add("terminal_name", (JsonElement)new JsonPrimitive("T-master"));
        jsonObj.add("terminal_version", (JsonElement)new JsonPrimitive("V" + this.ms.getValue("client_version")));
        String json = jsonObj.toString().replace(",", "$");
        param.put("text", json);
        param.put("appId", this.me.getAppId());
        param.put("firstLogin", firstLogin);
        param.put("ciphertext", this.baseApi.getPwd());
        String clientVersion = this.ms.getProps("client.properties").getDesValue("client_version") == null ? "" : this.ms.getProps("client.properties").getDesValue("client_version");
        param.put("clientVersion", clientVersion);
        StringBuilder sb = new StringBuilder(this.baseApi.getUserId());
        sb.append(loginTime).append(ip).append(CommUtils.getMAC()).append(this.baseApi.getPostId()).append(this.baseApi.getPartyId()).append(this.me.getAppId()).append(this.baseApi.getPwd()).append(clientVersion).append(TOKEN_KEY);
        String sign = MD5Utils.MD5((String)sb.toString());
        param.put("sign", sign);
        return this.gson.toJson(param);
    }

    private boolean isSuccess(String resultString) {
        if (resultString != null && !"".equals(resultString)) {
            try {
                Map map = (Map)this.gson.fromJson(resultString, HashMap.class);
                return 200.0 == (Double)map.get("code");
            }
            catch (Exception exception) {
                return true;
            }
        }
        return false;
    }

    private boolean isTokenNotExpire(String resultString) {
        if (resultString != null && !"".equals(resultString)) {
            try {
                Map map = (Map)this.gson.fromJson(resultString, HashMap.class);
                if (302.0 != (Double)map.get("code")) {
                    this.tokenExpire.compareAndSet(true, false);
                    logger.debug("loginAndSetToken token NOT expire " + this.baseApi.getToken());
                    return true;
                }
            }
            catch (Exception exception) {
                return true;
            }
        }
        return false;
    }

    private boolean isTokenExpire(String resultString) {
        Map map;
        if (resultString != null && !"".equals(resultString) && 302.0 == (Double)(map = (Map)this.gson.fromJson(resultString, HashMap.class)).get("code")) {
            this.tokenExpire.compareAndSet(false, true);
            logger.info("loginAndSetToken token expire " + this.baseApi.getToken());
            return true;
        }
        return false;
    }

    private String proceedRequest(Request request) {
        Response response = null;
        try {
            String body;
            response = this.getOkHttpClient().newCall(request).execute();
            String string = body = response.body() == null ? " null" : response.body().string();
            if (request.url().toString().trim().endsWith("clientLogin")) {
                logger.info("http response " + request.url() + " , " + response.code());
            } else {
                logger.info("http response " + request.url() + " , " + response.code() + " , " + body);
            }
            if (response.isSuccessful()) {
                this.setLastSuccess();
                if (this.isTokenNotExpire(body)) {
                    this.setLastTokenSuccess();
                }
                String string2 = body;
                return string2;
            }
            logger.error("http response error \u5f02\u5e38 " + request.url() + " , " + response.code() + " , " + body);
            return null;
        }
        catch (IOException e) {
            logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
            return null;
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    private Response proceedLogin(Request request) {
        Response response = null;
        try {
            response = this.getOkHttpClient().newCall(request).execute();
        }
        catch (IOException e) {
            logger.error("\u767b\u5f55\u51fa\u9519", (Throwable)e);
        }
        return response;
    }

    private Response proceedRequestReturnResp(Request request) {
        Response response = null;
        try {
            response = this.getOkHttpClient().newCall(request).execute();
            return response;
        }
        catch (IOException e) {
            logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
            return null;
        }
    }

    private Response proceedStreamRequest(Request request) {
        Response response = null;
        try {
            response = this.getOkHttpClientLongTimeOut().newCall(request).execute();
            String header = response.header("Content-Type");
            boolean failed = header.contains("json");
            logger.info("http response " + request.url() + " , " + response.code());
            if (response.isSuccessful()) {
                this.setLastSuccess();
                if (failed) {
                    this.setLastTokenSuccess();
                }
                return response;
            }
            logger.error("http response error \u5f02\u5e38 " + request.url() + " , " + response.code());
            return null;
        }
        catch (IOException e) {
            logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
            return null;
        }
    }

    private String buildUrl(String url, Map<String, String> data) {
        logger.info("http===" + Thread.currentThread().getName() + " " + url);
        StringBuffer stringBuffer = new StringBuffer(this.ms.getValue("web.domain"));
        stringBuffer.append(baseUrl).append(url);
        if (data == null || data.size() == 0) {
            return stringBuffer.toString();
        }
        if (!url.endsWith("?")) {
            stringBuffer.append("?");
        }
        data.entrySet().forEach(entry -> {
            StringBuffer stringBuffer2 = stringBuffer.append(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue() + "&");
        });
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {}
        return ssfFactory;
    }

    private boolean lastTokenSuccessBeforeSixHour() {
        return System.currentTimeMillis() - this.getLastTokenSuccess() > this.SIX_HOUR;
    }

    public long getLastTokenSuccess() {
        return this.lastTokenSuccess;
    }

    public void setLastTokenSuccess() {
        this.lastTokenSuccess = System.currentTimeMillis();
    }

    private boolean lastSuccessBeforeSixHour() {
        return System.currentTimeMillis() - this.getLastSuccess() > this.SIX_HOUR;
    }

    public long getLastSuccess() {
        return this.lastSuccess;
    }

    public void setLastSuccess() {
        this.lastSuccess = System.currentTimeMillis();
    }

    public CreditToken getCreditToken(String url, boolean significant) throws MException {
        return this.getCreditToken(url, null, GET, 10L, 10L, significant);
    }

    private CreditToken getCreditToken(String url, String dataJson, String method, long connectTimeout, long readTimeout, boolean significant) {
        CreditToken creditToken = new CreditToken();
        if (url.isEmpty()) {
            return creditToken;
        }
        long start = System.currentTimeMillis();
        Response response = null;
        BufferedReader bufferedReader = null;
        try {
            String resStr;
            Request.Builder rbuilder = new Request.Builder().cacheControl(new CacheControl.Builder().noCache().build());
            rbuilder.url(url);
            rbuilder.addHeader("Cache-Control", "no-Cache");
            rbuilder.addHeader("Connection", "close");
            if (!StringUtils.isEmpty((String)this.baseApi.getAccessToken())) {
                rbuilder.addHeader("access-token", this.baseApi.getAccessToken());
            }
            if (!StringUtils.isEmpty((String)this.baseApi.getRefreshToken())) {
                rbuilder.addHeader("refresh-token", this.baseApi.getRefreshToken());
            }
            if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
                rbuilder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
            }
            Request request = rbuilder.build();
            logger.info("http request " + url + "  " + method);
            response = this.getOkHttpClient().newCall(request).execute();
            String string = resStr = response.body() == null ? null : response.body().string();
            if (StringUtils.isEmpty((String)resStr)) {
                CreditToken creditToken2 = creditToken;
                return creditToken2;
            }
            if (response.isSuccessful()) {
                HashMap map = (HashMap)this.gson.fromJson(resStr, HashMap.class);
                creditToken.setOk("ok".equals(map.get("state")));
                creditToken.setToken((String)map.get("token"));
                CreditToken creditToken3 = creditToken;
                return creditToken3;
            }
            logger.error("http response error \u5f02\u5e38 " + request.url() + " , " + response.code());
            CreditToken creditToken4 = creditToken;
            return creditToken4;
        }
        catch (Throwable e) {
            logger.error("doRequest error " + url + " " + method + "  " + dataJson, e);
            return null;
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.error("get credit token faild", (Throwable)e);
                }
            }
            logger.info("http_request takes " + (System.currentTimeMillis() - start) + " " + method + " " + url);
        }
    }

    private class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            logger.info(" " + hostname + " " + session);
            return true;
        }
    }
}

