/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoDialog;
import cms.tmx.algorithm.viewers.AlgoUtils;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import java.util.Calendar;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoTwapDialog
extends AlgoDialog {
    private static final Logger logger = LogManager.getLogger(AlgoTwapDialog.class);
    @FXML
    private Spinner<Integer> spnTimeSlice;
    @FXML
    private HBox hboxStartTime;
    @FXML
    private HBox hboxEndTime;
    @FXML
    private TextField txtStartHour;
    @FXML
    private TextField txtStartMinute;
    @FXML
    private TextField txtEndHour;
    @FXML
    private TextField txtEndMinute;
    @FXML
    private Label lbStartErr;
    @FXML
    private Label lbEndErr;
    @FXML
    private Label lbSliceErr;
    @FXML
    private ComboBox<MxNode> cmbAggress;
    @Inject
    protected IFundAccountService fundAccMng;
    protected IntSpinnerCtrl ctrlSlice = new IntSpinnerCtrl(true, 2, 1);
    @Inject
    private CcsAccountMap accountMap;
    private int sliceMax = 0;
    private int sliceMin = 0;

    @Override
    @FXML
    public void initialize() {
        this.initValues();
        if (this.algo.getAlgorithm().isReadOnly()) {
            this.initParam();
            this.gridPane.setDisable(true);
            return;
        }
        super.initialize();
        if (!this.algo.getAlgorithm().isClear()) {
            this.initParam();
        }
        if (this.algo.getAlgorithm().isUpdate()) {
            this.disable(new Node[]{this.cmbFundAcc, this.cmbSecAcc, this.txtCode, this.rdoSell, this.rdoBuy, this.spnQuantity});
        }
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"agress_level", (String)"0");
        this.cmbAggress.setItems(node.getNodes());
        this.cmbAggress.setValue((Object)node);
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.ctrlSlice.ctrl(this.spnTimeSlice);
        this.spnTimeSlice.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnTimeSlice.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnTimeSlice, (int)0, (int)1);
        SpinnerUtils.arrowsStyle(this.spnTimeSlice);
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtEndHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtEndMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndMinute));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        AlgoModel.timeLimit(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute, AlgoUtils.isRepo(this.refItem));
    }

    @Override
    protected void checks() {
        super.checks();
        this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
            if (!AlgoModel.timeIsValid(start, AlgoUtils.isRepo(this.refItem))) {
                this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty()}));
        this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int minuter;
            int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
            int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
            if (!AlgoModel.timeIsValid(end, AlgoUtils.isRepo(this.refItem))) {
                this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                return false;
            }
            if (end <= start) {
                this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4");
                return false;
            }
            Calendar calender = Calendar.getInstance();
            int hour = calender.get(11);
            if (end < hour * 60 + (minuter = calender.get(12))) {
                this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.algo.minuteProperty()}));
        this.registerCheck((Node)this.lbSliceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int slice = this.getInt(this.spnTimeSlice.getEditor());
            if (slice > this.sliceMax || slice < this.sliceMin) {
                this.lbSliceErr.setText("\u8bf7\u8f93\u5165\u65f6\u95f4\u7247\u6570:" + this.sliceMin + "~" + this.sliceMax);
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnTimeSlice.getEditor().textProperty()}));
    }

    @Override
    protected void onSecurityChange() {
        super.onSecurityChange();
        this.spnQuantity.getEditor().clear();
        this.lbQtyErr.setOpacity(0.0);
    }

    private void sliceChange() {
        int startHour = this.getInt(this.txtStartHour);
        int startMinute = this.getInt(this.txtStartMinute);
        int endHour = this.getInt(this.txtEndHour);
        int endMinute = this.getInt(this.txtEndMinute);
        this.sliceMax = AlgoModel.computeSlice(startHour, startMinute, endHour, endMinute);
        this.sliceMin = this.sliceMax / 10;
        this.sliceMin = this.sliceMin < 2 ? 1 : this.sliceMin;
        int sliceDef = this.sliceMax / 5;
        sliceDef = sliceDef < 2 ? 1 : sliceDef;
        this.spnTimeSlice.getEditor().setText(String.valueOf(sliceDef));
    }

    public boolean isOK(ButtonType bt) {
        if (this.algo.getAlgorithm().isReadOnly()) {
            return true;
        }
        this.algo.setBuy(this.rdoBuy.isSelected());
        this.algo.setFundAccId(this.accountMap.getFundAcc(this.cmbFundAcc.getEditor().getText()).getExtAccntId());
        this.algo.setSecAccId(this.accountMap.getSecAcc(this.cmbSecAcc.getEditor().getText(), "").getExtSecAccntId());
        this.algo.setCount(Integer.valueOf(this.spnQuantity.getEditor().getText().replaceAll(",", "")));
        this.algo.setStartHour(Integer.valueOf(this.txtStartHour.getText()));
        this.algo.setStartMinute(Integer.valueOf(this.txtStartMinute.getText()));
        this.algo.setEndHour(Integer.valueOf(this.txtEndHour.getText()));
        this.algo.setEndMinute(Integer.valueOf(this.txtEndMinute.getText()));
        this.algo.setAggress(Integer.valueOf(((MxNode)this.cmbAggress.getValue()).getRaw()));
        this.algo.setSlice(Integer.valueOf(this.spnTimeSlice.getEditor().getText().replaceAll(",", "")));
        try {
            if (this.algo.getAlgorithm().isUpdate()) {
                this.model.update(this.algo);
            } else {
                this.model.submit(this.algo);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getDesc());
            return false;
        }
        return true;
    }

    private void initParam() {
        boolean isBuy = this.algo.getAlgorithm().getAlgoParam().isBuy();
        this.rdoBuy.setSelected(isBuy);
        this.rdoSell.setSelected(!isBuy);
        this.cmbFundAcc.getEditor().setText(this.algo.getFundAccId());
        this.cmbSecAcc.getEditor().setText(this.algo.getSecAccId());
        String type = this.algo.getAlgorithm().getAlgoParam().getType();
        String market = this.algo.getAlgorithm().getAlgoParam().getMarket();
        String code = this.algo.getAlgorithm().getAlgoParam().getCode();
        String name = this.algo.getAlgorithm().getAlgoParam().getName();
        if (!this.algo.getAlgorithm().isClear()) {
            RefItem item = this.refMng.getItem(type, market, code);
            if (item != null) {
                this.txtCode.setText(code);
                this.lbCode.setText(name);
                this.txtCode.setUserData((Object)item);
                this.onSecurityChange();
            }
        } else {
            this.txtCode.setText(code);
            this.lbCode.setText(name);
            this.lbCanQty.setText("");
        }
        this.spnQuantity.getEditor().setText(String.valueOf(this.algo.getCount()));
        if (this.algo.getAlgorithm().isUpdate()) {
            this.spnQuantity.getEditor().setText(String.valueOf(this.algo.getCount() - this.algo.getAlgorithm().getAlgoParam().getDealCount()));
        }
        this.txtStartHour.setText(AlgoModel.complement(this.algo.getStartHour()));
        this.txtStartMinute.setText(AlgoModel.complement(this.algo.getStartMinute()));
        this.txtEndHour.setText(AlgoModel.complement(this.algo.getEndHour()));
        this.txtEndMinute.setText(AlgoModel.complement(this.algo.getEndMinute()));
        MxNode node = ((MxNode)this.cmbAggress.getValue()).getNode(String.valueOf(this.algo.getAggress()));
        this.cmbAggress.getSelectionModel().select((Object)node);
        this.spnTimeSlice.getEditor().setText(String.valueOf(this.algo.getSlice()));
        String unit = QueryUtils.getUnit((String)type, (String)market);
        this.lbUnit.setText(unit);
    }
}

