/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoFactory;
import cms.tmx.algorithm.models.AlgoTradeModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsDealModel;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoTradePart
extends MxPart {
    @FXML
    private TableView<Algorithm> tableAlgo;
    @FXML
    private TableColumn<Algorithm, Object> colOrder;
    @FXML
    private TableView<AlgoBaseOrder> tableBase;
    @FXML
    private TableColumn<AlgoBaseOrder, String> type;
    @FXML
    private Button btnRefresh;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnLookNow;
    @FXML
    private Button btnCopyNow;
    @Inject
    private AlgoTradeModel tradeModel;
    @Inject
    private AlgoQueryModel queryModel;
    @Inject
    private MxAlert alert;
    @Inject
    private AlgoFactory factory;
    @Inject
    private AlgoFuncControl algofunc;
    private static final Logger logger = LogManager.getLogger(AlgoTradePart.class);
    private MxList<AlgoBaseOrder> mxList = new MxList();
    protected InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mxList.update((List)this.queryModel.getOrderList());
        this.mxList.getList().sort((a, b) -> b.getBaseId().compareTo(a.getBaseId()));
        this.tableBase.sort();
        this.tableBase.refresh();
    });

    @FXML
    public void initialize() {
        this.initValue();
        this.createTable();
        this.queryModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnModel));
        this.tableBase.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            MEvent event = new MEvent();
            String id = "";
            if (now != null) {
                id = String.valueOf(now.getBaseId()) + "_" + now.getId();
            }
            event.put((Object)"baseid", (Object)id);
            CcsOrderModel.baseId = id;
            CcsDealModel.baseId = id;
            if (now.getPortfolioName().equals("")) {
                CcsOrderModel.isNormal = true;
                CcsDealModel.isNormal = true;
            } else {
                CcsOrderModel.isNormal = false;
                CcsDealModel.isNormal = false;
            }
            this.es.sendEvent("algo.base.id", event);
        });
        this.refresh();
    }

    private void initValue() {
        FxUtils.makePC((Node)this.btnRefresh, (String)"strong", (boolean)true);
        this.btnCancel.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.tableBase.getSelectionModel().getSelectedItem() == null) {
                return true;
            }
            switch (((AlgoBaseOrder)this.tableBase.getSelectionModel().getSelectedItem()).getStatus().getRaw()) {
                case "2": 
                case "3": 
                case "5": {
                    return true;
                }
            }
            return false;
        }, (Observable[])new Observable[]{this.tableBase.getSelectionModel().selectedItemProperty()}));
        this.btnLookNow.disableProperty().bind((ObservableValue)this.tableBase.getSelectionModel().selectedItemProperty().isNull());
        this.btnCopyNow.disableProperty().bind((ObservableValue)this.tableBase.getSelectionModel().selectedItemProperty().isNull());
    }

    @FXML
    public void refresh() {
        try {
            this.queryModel.queryBaseOrder();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void lookOver() {
        AlgoBaseOrder abo = (AlgoBaseOrder)this.tableBase.getSelectionModel().getSelectedItem();
        boolean isOk = this.factory.dialog(abo, false);
        if (isOk) {
            this.refresh();
        }
    }

    @FXML
    public void copyParam() {
        AlgoBaseOrder abo = (AlgoBaseOrder)this.tableBase.getSelectionModel().getSelectedItem();
        this.factory.dialog(abo, true);
    }

    @FXML
    public void cancel() {
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u7ec8\u6b62\u7b97\u6cd5\uff0c\u5e76\u64a4\u9500\u8be5\u7b97\u6cd5\u7684\u672a\u5b8c\u6210\u59d4\u6258\uff1f")) {
            AlgoBaseOrder order = (AlgoBaseOrder)this.tableBase.getSelectionModel().getSelectedItem();
            try {
                this.tradeModel.cancelOrder(order);
                this.alert.alert(Alert.AlertType.INFORMATION, "\u7b97\u6cd5\u8ba2\u5355[" + order.getId() + "]\uff0c\u64a4\u9500\u63d0\u4ea4\u6210\u529f\uff01");
            }
            catch (MException e) {
                String msg = e.getMessage();
                if ("\u4f20\u5165\u7684\u8ba2\u5355\u7f16\u53f7\u65e0\u6548".equals(msg)) {
                    msg = "\u4f20\u5165\u7684\u8ba2\u5355\u7f16\u53f7\u65e0\u6548\uff01\uff08\u5982\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7b49\u5f85\u7ed3\u679c\uff09";
                }
                this.alert.alert(Alert.AlertType.ERROR, msg);
                logger.error((Object)e, (Throwable)e);
            }
            this.refresh();
        }
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableAlgo);
        this.colOrder.setCellValueFactory(data -> this.setOperate((Algorithm)data.getValue()));
        TableUtils.initValueFactory(this.tableBase);
        this.type.setCellValueFactory(data -> ((AlgoBaseOrder)data.getValue()).getAlgorithm().nameProperty());
        this.tableBase.setItems(this.mxList.getList());
        this.tableBase.setPlaceholder((Node)new Label());
    }

    private ReadOnlyObjectWrapper<Object> setOperate(Algorithm algo) {
        Button order = new Button("\u4e0b\u5355");
        order.getStyleClass().add((Object)"btnOperation");
        order.setOnAction(event -> {
            this.tableAlgo.getSelectionModel().select((Object)algo);
            this.factory.launch(algo, false);
        });
        return new ReadOnlyObjectWrapper((Object)order);
    }
}

