/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.viewers.AlgoDialog;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoRangeTradeDialog
extends AlgoDialog {
    private static final Logger logger = LogManager.getLogger(AlgoRangeTradeDialog.class);
    @FXML
    private Spinner<Double> spnPriceUp;
    @FXML
    private Spinner<Double> spnPriceLow;
    @FXML
    private Label lbLowErr;
    @FXML
    private Label lbUpErr;
    @FXML
    private Label lbSliceErr;
    @FXML
    private ComboBox<MxNode> cmbDepth;
    @FXML
    private ComboBox<MxNode> cmbTimeSlice;
    protected DoubleSpinnerCtrl ctrlPriceUp = new DoubleSpinnerCtrl(true, 6, 0);
    protected DoubleSpinnerCtrl ctrlPriceLow = new DoubleSpinnerCtrl(true, 6, 0);
    ObservableList<MxNode> listDepth = FxUtils.newList();
    @Inject
    private CcsAccountMap accountMap;

    @Override
    @FXML
    public void initialize() {
        this.initValues();
        if (this.algo.getAlgorithm().isReadOnly()) {
            this.initParam();
            this.gridPane.setDisable(true);
            return;
        }
        super.initialize();
        if (!this.algo.getAlgorithm().isClear()) {
            this.initParam();
        }
        if (this.algo.getAlgorithm().isUpdate()) {
            this.disable(new Node[]{this.cmbFundAcc, this.cmbSecAcc, this.txtCode, this.rdoSell, this.rdoBuy, this.spnQuantity});
        }
    }

    protected void initValues() {
        MxNode node = MxNodeFactory.create((String)"algo_time_interval", (String)"1");
        this.cmbTimeSlice.setItems(node.getNodes());
        this.cmbTimeSlice.setValue((Object)node);
        this.cmbDepth.setItems(this.listDepth);
        this.rdoBuy.selectedProperty().addListener((ob, old, now) -> {
            String depth = now != false ? "depth_sell" : "depth_buy";
            MxNode mn = MxNodeFactory.create((String)depth, (String)"1");
            this.listDepth.setAll((Collection)mn.getNodes());
            this.cmbDepth.setValue((Object)mn);
        });
        this.rdoBuy.setSelected(true);
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.ctrlPriceUp.ctrl(this.spnPriceUp);
        this.ctrlPriceLow.ctrl(this.spnPriceLow);
        this.spnPriceUp.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceUp.getEditor()));
        this.spnPriceLow.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceLow.getEditor()));
        SpinnerUtils.addIntArrowKeyHandler((Spinner)this.spnQuantity, (int)0, (int)100);
        SpinnerUtils.arrowsStyle(this.spnPriceUp);
        SpinnerUtils.arrowsStyle(this.spnPriceLow);
    }

    @Override
    protected void checks() {
        super.checks();
        this.registerCheck((Node)this.lbLowErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            double priceLow = this.getDouble(this.spnPriceLow);
            if (priceLow == 0.0) {
                this.lbLowErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u4e0b\u9650");
                return false;
            }
            if (this.spnPriceUp.getEditor().getText().isEmpty()) {
                return true;
            }
            double priceUp = this.getDouble(this.spnPriceUp);
            if (priceUp < priceLow) {
                this.lbLowErr.setText("\u4ef7\u683c\u4e0b\u9650  <= \u4ef7\u683c\u4e0a\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnPriceUp.getEditor().textProperty(), this.spnPriceLow.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbUpErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> this.getDouble(this.spnPriceUp) != 0.0, (Observable[])new Observable[]{this.spnPriceUp.getEditor().textProperty()}));
    }

    @Override
    protected void onSecurityChange() {
        super.onSecurityChange();
        this.spnQuantity.getEditor().clear();
        this.spnPriceLow.getEditor().clear();
        this.spnPriceUp.getEditor().clear();
        this.lbQtyErr.setOpacity(0.0);
        this.lbLowErr.setOpacity(0.0);
        this.lbUpErr.setOpacity(0.0);
        this.ctrlPriceLow.setScale(this.getScale());
        this.ctrlPriceUp.setScale(this.getScale());
    }

    @Override
    public void codeKeyPress(TextField ctrl, KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (ctrl == this.txtCode) {
                this.spnQuantity.requestFocus();
                this.spnQuantity.getEditor().selectAll();
            } else {
                this.spnQuantity.getEditor();
            }
            key.consume();
        }
    }

    public boolean isOK(ButtonType bt) {
        if (this.algo.getAlgorithm().isReadOnly()) {
            return true;
        }
        this.algo.setBuy(this.rdoBuy.isSelected());
        this.algo.setFundAccId(this.accountMap.getFundAcc(this.cmbFundAcc.getEditor().getText()).getExtAccntId());
        this.algo.setSecAccId(this.accountMap.getSecAcc(this.cmbSecAcc.getEditor().getText(), "").getExtSecAccntId());
        this.algo.setPriceUp(this.getDouble(this.spnPriceUp));
        this.algo.setPriceLow(this.getDouble(this.spnPriceLow));
        this.algo.setCount(Integer.parseInt(this.spnQuantity.getEditor().getText().replaceAll(",", "")));
        this.algo.setDepth(Integer.parseInt(((MxNode)this.cmbDepth.getValue()).getRaw()));
        this.algo.setSlice(Integer.parseInt(((MxNode)this.cmbTimeSlice.getValue()).getRaw()));
        try {
            if (this.algo.getAlgorithm().isUpdate()) {
                this.model.update(this.algo);
            } else {
                this.model.submit(this.algo);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getDesc());
            return false;
        }
        return true;
    }

    private void initParam() {
        boolean isBuy = this.algo.getAlgorithm().getAlgoParam().isBuy();
        this.rdoBuy.setSelected(isBuy);
        this.rdoSell.setSelected(!isBuy);
        this.cmbFundAcc.getEditor().setText(this.algo.getFundAccId());
        this.cmbSecAcc.getEditor().setText(this.algo.getSecAccId());
        String type = this.algo.getAlgorithm().getAlgoParam().getType();
        String market = this.algo.getAlgorithm().getAlgoParam().getMarket();
        String code = this.algo.getAlgorithm().getAlgoParam().getCode();
        String name = this.algo.getAlgorithm().getAlgoParam().getName();
        this.txtCode.setText(code);
        this.lbCode.setText(name);
        RefItem item = this.refMng.getItem(type, market, code);
        if (!this.algo.getAlgorithm().isClear()) {
            if (item != null) {
                this.txtCode.setText(code);
                this.lbCode.setText(name);
                this.txtCode.setUserData((Object)item);
                this.onSecurityChange();
            }
        } else {
            this.txtCode.setText(code);
            this.lbCode.setText(name);
            this.lbCanQty.setText("");
        }
        int scale = item == null ? 3 : item.getScale();
        this.spnPriceUp.getEditor().setText(StringUtils.toStr((double)this.algo.getPriceUp(), (int)scale));
        this.spnPriceLow.getEditor().setText(StringUtils.toStr((double)this.algo.getPriceLow(), (int)scale));
        this.spnQuantity.getEditor().setText(String.valueOf(this.algo.getCount()));
        if (this.algo.getAlgorithm().isUpdate()) {
            this.spnQuantity.getEditor().setText(String.valueOf(this.algo.getCount() - this.algo.getAlgorithm().getAlgoParam().getDealCount()));
        }
        this.cmbDepth.getSelectionModel().select(this.algo.getDepth() - 1);
        this.cmbTimeSlice.getSelectionModel().select(this.algo.getSlice() - 1);
        String unit = QueryUtils.getUnit((String)type, (String)market);
        this.lbUnit.setText(unit);
    }
}

