/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.LoadPartModel;
import cms.tmx.control.dialog.BaseValid;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.IUIService;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public abstract class AlgoNodeHk
extends MxPart
implements BaseValid {
    @FXML
    public ComboBox<MxNode> cmbAlgo;
    @FXML
    public TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    public RadioButton buyRadio;
    @FXML
    public RadioButton sellRadio;
    @FXML
    public RadioButton sellShortRadio;
    @FXML
    protected VBox vboxAlgo;
    @FXML
    public Button btnOrder;
    @FXML
    protected ComboBox<MxNode> cmbTif;
    @FXML
    public Spinner<Double> spnPrice;
    @FXML
    private Label lbQty;
    @FXML
    public Spinner<Integer> spnQty;
    @FXML
    public Label lbUnit;
    @FXML
    public Label lbExpUnit;
    @FXML
    public TextField txtStartHour;
    @FXML
    public TextField txtStartMinute;
    @FXML
    public TextField txtEndHour;
    @FXML
    public TextField txtEndMinute;
    @FXML
    protected Spinner<Integer> spnPriceBid;
    @FXML
    public TextField txtDealPercent;
    @FXML
    protected Label lbAlgoErr;
    @FXML
    protected Label lbCodeErr;
    @FXML
    protected Label lbPriceErr;
    @FXML
    protected Label lbQtyErr;
    @FXML
    protected Label lbStartErr;
    @FXML
    protected Label lbEndErr;
    @FXML
    protected Label lbStart;
    @FXML
    protected Label lbEnd;
    @FXML
    protected Label qtyMag;
    @FXML
    protected Label qtyExpMag;
    @FXML
    protected Label lbPriceLimitErr;
    @FXML
    protected Label lbDealPercentErr;
    @FXML
    protected Label lbOptional;
    @Inject
    public AlgoQueryModel algo;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected IUIService uiService;
    @Inject
    protected AlgoFuncControl algoFunc;
    @Inject
    protected AlgoConfControls algoConf;
    protected Map<String, List<Node>> mapAlgo = new HashMap<String, List<Node>>();
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 0);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected ToggleGroup group = new ToggleGroup();
    protected SecSuggest spCode = new SecSuggest();
    protected SecConverter secCvt;
    protected static final Logger logger = LogManager.getLogger(AlgoNodeHk.class);
    protected String buySymbol = "\u4e70\u5165";
    protected String sellSymbol = "\u5356\u51fa";
    protected String sellShortSymbol = "\u5356\u7a7a";
    public double priceUpLimit = 0.0;
    public double priceDownLimit = 0.0;
    public boolean priceUpAndDownLimit = true;
    public int scale = 0;
    public RefItem refItem = null;
    public Boolean isBuy = null;
    @Inject
    private LoadPartModel load;
    public MxNode nodeDepth = null;
    public MxNode nodeAggress = null;
    public MxNode nodeInterval = null;
    public MxNode nodeMinute = null;
    public MxNode nodePriceType = null;
    private ObservableList<MxNode> algoList = FxUtils.newList();
    public static final String limitShort = "50#SHORTSELL";
    public static final String limitTwap = "50#TWAP";
    public static final String limitVwap = "50#VWAP";
    public static final String limitPov = "50#POV";
    public static final String marketShort = "49#SHORTSELL";
    public static final String marketTwap = "49#TWAP";
    public static final String marketVwap = "49#VWAP";
    public static final String marketPov = "49#POV";
    protected Map<ObservableBooleanValue, Node> mapValid = new LinkedHashMap<ObservableBooleanValue, Node>();
    private String startTime = "";
    private String endTime = "";

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("AlgoNodeHk.fxml");
        }
        return url;
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException e) {
            logger.error("init part failed", (Throwable)e);
        }
    }

    protected void initControl() {
        this.cmbAlgo.setItems(this.algoList);
        this.cmbAlgo.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectedAlgo((MxNode)now));
        this.txtCode.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCode.selectAll());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        TooltipUtil.bind((Label)this.lbName);
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.sellShortRadio.setToggleGroup(this.group);
        this.group.selectedToggleProperty().addListener((ob, old, now) -> this.onBSChange(((RadioButton)now).getId()));
        this.buyRadio.setSelected(true);
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        this.ctrlPrice.ctrl(this.spnPrice);
        this.spnPrice.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPrice.getEditor()));
        this.ctrlCount.ctrl(this.spnQty);
        this.spnQty.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnQty.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnQty, (int)0, (int)100);
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.spnQty.getEditor());
        MxNode node = MxNodeFactory.createNew((String)"tif_undefined_str", (String)"48");
        this.cmbTif.setItems(node.getNodes());
        this.cmbTif.setValue((Object)node);
        this.cmbTif.setDisable(true);
        this.txtDealPercent.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtDealPercent.selectAll());
        String percent = "^(([0-9]|([1-4][0-9])|(50)))?$";
        this.txtDealPercent.setTextFormatter((TextFormatter)new MxFormatter(percent, 2));
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtEndHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtEndMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndMinute));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        AlgoModel.timeLimitHk(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute);
        SpinnerUtils.arrowsStyle(this.spnQty);
        SpinnerUtils.arrowsStyle(this.spnPrice);
        this.spnQty.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.enterKeyOrder((KeyEvent)event));
        this.cmbAlgo.getSelectionModel().select(0);
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    protected void loseFocus(Boolean val) {
    }

    public void selectedAlgo(MxNode algo) {
        if (algo == null) {
            return;
        }
        if (limitShort.equals(algo.getRaw()) || marketShort.equals(algo.getRaw())) {
            this.sellShortRadio.setSelected(true);
            this.buyRadio.setDisable(true);
            this.sellRadio.setDisable(true);
        } else {
            this.buyRadio.setDisable(false);
            this.sellRadio.setDisable(false);
        }
        this.spnPrice.getEditor().clear();
        this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(algo.getRaw()));
        this.clear(true);
    }

    protected void clear(boolean isAlgo) {
        if (!isAlgo) {
            this.spnPrice.getEditor().clear();
            this.spnQty.getEditor().clear();
        }
        this.txtDealPercent.clear();
        AlgoModel.timeLimitHk(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute);
        this.setDefTime();
        if (isAlgo) {
            this.lbCodeErr.setOpacity(0.0);
        }
        this.lbAlgoErr.setOpacity(0.0);
        this.lbPriceErr.setOpacity(0.0);
        this.lbQtyErr.setOpacity(0.0);
        this.lbStartErr.setOpacity(0.0);
        this.lbEndErr.setOpacity(0.0);
        this.lbDealPercentErr.setOpacity(0.0);
    }

    protected void onBSChange(String now) {
        if (this.buyRadio.getId().equals(now)) {
            this.btnOrder.setText(this.buySymbol);
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else if (this.sellRadio.getId().equals(now)) {
            this.btnOrder.setText(this.sellSymbol);
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText(this.sellShortSymbol);
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
    }

    protected void checks() {
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.txtCode.isFocused()) {
                if (this.txtCode.getText().isEmpty()) {
                    this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                    return false;
                }
                if (this.lbName.getText().isEmpty()) {
                    this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.focusedProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.textProperty(), this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbPriceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            double priceLow = this.getDouble(this.spnPrice);
            if (priceLow == 0.0) {
                this.lbPriceErr.setText("\u8bf7\u8f93\u5165\u4ea4\u6613\u4ef7\u683c");
                return false;
            }
            if (this.spnPrice.getEditor().getText().isEmpty()) {
                return true;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnPrice.getEditor().textProperty(), this.spnPrice.getEditor().textProperty()}));
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                if (!AlgoModel.timeIsValidHk(start)) {
                    this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:59");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty()}));
        }
        this.registerCheck((Node)this.lbDealPercentErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int mktPct = this.getInt(this.txtDealPercent);
            if (mktPct >= 1 && mktPct <= 50) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtDealPercent.textProperty()}));
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : StringUtils.parseInt((String)txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected double getDouble(TextField tf) {
        String txt = tf.getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected void initAlgo() {
        this.vboxAlgo.getChildren().clear();
        List<Node> list = this.getItems(new Node[]{this.cmbTif, this.spnQty, this.spnPrice, this.txtStartHour, this.txtEndHour});
        this.mapAlgo.put(limitShort, list);
        this.mapAlgo.put(limitTwap, list);
        this.mapAlgo.put(limitVwap, list);
        list = this.getItems(new Node[]{this.cmbTif, this.spnQty, this.spnPrice, this.txtStartHour, this.txtEndHour, this.txtDealPercent});
        this.mapAlgo.put(limitPov, list);
        list = this.getItems(new Node[]{this.cmbTif, this.spnQty, this.txtStartHour, this.txtEndHour});
        this.mapAlgo.put(marketShort, list);
        this.mapAlgo.put(marketTwap, list);
        this.mapAlgo.put(marketVwap, list);
        list = this.getItems(new Node[]{this.cmbTif, this.spnQty, this.txtStartHour, this.txtEndHour, this.txtDealPercent});
        this.mapAlgo.put(marketPov, list);
        MxNode node = MxNodeFactory.create((String)"hk_algo_name");
        this.algoList.addAll((Collection)node.getNodes());
    }

    protected List<Node> getItems(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent().getParent());
            ++n2;
        }
        return list;
    }

    public ObservableList<Node> getChildren() {
        return ((VBox)VBox.class.cast(this.content)).getChildren();
    }

    public boolean valid() {
        ObservableList list = this.vboxAlgo.getChildren();
        for (Map.Entry<ObservableBooleanValue, Node> entry : this.mapValid.entrySet()) {
            this.checkNode(entry.getValue(), entry.getKey());
            if (!list.contains(entry.getValue().getParent()) && !entry.getValue().equals(this.lbCodeErr) && !entry.getValue().equals(this.lbAlgoErr) || entry.getKey().get()) continue;
            return false;
        }
        return true;
    }

    protected void enterKeyOrder(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    public void order() {
    }

    protected AlgoParam submitParam(RefItem refItem) {
        AlgoParam param = (AlgoParam)this.of.create(AlgoParam.class);
        param.setAlgoTypeNode((MxNode)this.cmbAlgo.getValue());
        param.setMarket(refItem.getMarket());
        param.setType(refItem.getType());
        param.setCode(refItem.getCode());
        param.setName(refItem.getName());
        param.setSide(this.getSide());
        param.setPrice(this.getDouble(this.spnPrice));
        param.setCount(this.getInt(this.spnQty.getEditor()));
        param.setStartHour(this.getInt(this.txtStartHour));
        param.setStartMinute(this.getInt(this.txtStartMinute));
        param.setEndHour(this.getInt(this.txtEndHour));
        param.setEndMinute(this.getInt(this.txtEndMinute));
        param.setMarketPercent(this.getDouble(this.txtDealPercent));
        return param;
    }

    private int getSide() {
        if (this.buyRadio.isSelected()) {
            return 49;
        }
        if (this.sellRadio.isSelected()) {
            return 50;
        }
        return 53;
    }

    public Map<ObservableBooleanValue, Node> getValids() {
        return this.mapValid;
    }

    public RadioButton getBuyRadio() {
        return this.buyRadio;
    }

    public static String subZeroAndDot(String s) {
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    public void setDefTime(String start, String end) {
        if (start.equals(this.startTime) && end.equals(this.endTime)) {
            return;
        }
        this.startTime = start;
        this.endTime = end;
        int first = start.indexOf(":");
        int second = start.indexOf(":", first + 1);
        this.txtStartHour.setText(start.substring(0, first));
        this.txtStartMinute.setText(start.substring(first + 1, second));
        first = end.indexOf(":");
        second = end.indexOf(":", first + 1);
        this.txtEndHour.setText(end.substring(0, first));
        this.txtEndMinute.setText(end.substring(first + 1, second));
    }

    public void setDefTime() {
        if (this.startTime.isEmpty() || this.endTime.isEmpty()) {
            return;
        }
        int first = this.startTime.indexOf(":");
        int second = this.startTime.indexOf(":", first + 1);
        this.txtStartHour.setText(this.startTime.substring(0, first));
        this.txtStartMinute.setText(this.startTime.substring(first + 1, second));
        first = this.endTime.indexOf(":");
        second = this.endTime.indexOf(":", first + 1);
        this.txtEndHour.setText(this.endTime.substring(0, first));
        this.txtEndMinute.setText(this.endTime.substring(first + 1, second));
    }

    public List<Algorithm> getAlgos(String engine) {
        return this.getAlgos(engine, null);
    }

    public abstract List<Algorithm> getAlgos(String var1, Boolean var2);

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }
}

