/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoNode;
import cms.tmx.algorithm.viewers.AlgoUtils;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoNodeDialogContent
extends AlgoNode {
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private AlgoModel param;
    @Inject
    private IMarketDataMng mktMng;
    protected SecSuggest spCode = new SecSuggest();
    protected AutoCompletion<RefItem> autoCompletionAlgo;
    public AlgoParam algo;
    private MxDialog dialog;
    @Inject
    private IRefDataMng refMng;

    @FXML
    public void initialize() {
        super.initAlgo();
        this.initControl();
    }

    public void doOrderFill() {
        AlgoParam param = this.algo;
        String type = param.getType();
        String market = param.getMarket();
        if (StringUtils.belongto((String)market, (String[])new String[]{"SHSC", "SZSC"})) {
            type = String.valueOf(type) + market;
        }
        String code = param.getCode();
        int algoNewType = param.getAlgoNewType();
        this.refItem = this.refMng.getItem(type, market, code);
        String unit = QueryUtils.getUnit((String)type, (String)market);
        int scale = this.refItem.getScale();
        this.txtCode.setText(code);
        this.lbName.setText(this.refItem.getName());
        boolean isBuy = param.getSide() == 49 || param.getSide() == 71;
        int algoSelect = 0;
        this.cmbEngine.getSelectionModel().select((Object)"Mise\u5f15\u64ce");
        this.cmbAlgo.setItems(this.getAlgoList());
        if (algoNewType == 21) {
            algoSelect = 2;
        } else if (algoNewType == 22) {
            algoSelect = 3;
        } else if (algoNewType == 23) {
            algoSelect = 4;
        }
        this.cmbAlgo.getSelectionModel().select(algoSelect);
        this.buyRadio.setSelected(isBuy);
        this.sellRadio.setSelected(!isBuy);
        boolean isRepo = AlgoUtils.isRepo(this.refItem);
        this.buyRadio.setText(isRepo ? "\u6b63\u56de\u8d2d" : "\u4e70");
        this.sellRadio.setText(isRepo ? "\u9006\u56de\u8d2d" : "\u5356");
        this.spnQty.getEditor().setText(String.valueOf(param.getCount()));
        this.ctrlCount.setUnit(this.refItem.getBuyUnit());
        this.lbUnit.setText(unit);
        this.lbExpUnit.setText(unit);
        this.ctrlPriceLow.setScale(scale);
        this.ctrlPriceUp.setScale(scale);
        this.ctrlPriceMost.setScale(scale);
        double priceUp = param.getPriceUp();
        double priceLow = param.getPriceLow();
        if (algoNewType == 22) {
            priceUp = param.getLimitPrice();
            priceLow = param.getLimitPrice();
        }
        this.spnPriceUp.getEditor().setText(String.valueOf(priceUp));
        this.spnPriceLow.getEditor().setText(String.valueOf(priceLow));
        this.txtCode.setEditable(false);
        this.txtStartHour.setText(AlgoModel.complement(param.getStartHour()));
        this.txtStartMinute.setText(AlgoModel.complement(param.getStartMinute()));
        this.txtEndHour.setText(AlgoModel.complement(param.getEndHour()));
        this.txtEndMinute.setText(AlgoModel.complement(param.getEndMinute()));
        MxNode node = ((MxNode)this.cmbAggress.getValue()).getNode(String.valueOf(param.getAggress()));
        this.cmbAggress.getSelectionModel().select((Object)node);
        this.spnTimeSlice.getEditor().setText(String.valueOf(param.getSlice()));
        this.spnSumMinute.getEditor().setText(String.valueOf(param.getSumMinute()));
        this.txtMarketPercent.setText(String.valueOf((int)(param.getMarketPercent() * 100.0)));
        if (param.getQtyExposed() > 0) {
            this.lbOptional.setVisible(false);
        } else {
            this.lbOptional.setVisible(true);
        }
        this.spnQtyExposed.getEditor().setText(String.valueOf(param.getQtyExposed()));
        MxNode nodePriceType = ((MxNode)this.cmbIcePriceType.getValue()).getNode(String.valueOf(param.getPriceType()));
        this.cmbIcePriceType.getSelectionModel().select((Object)nodePriceType);
        this.disable();
    }

    public void disable() {
        this.cmbEngine.setDisable(true);
        this.buyRadio.setDisable(true);
        this.sellRadio.setDisable(true);
        this.spnQty.setDisable(true);
        this.spnPriceUp.setDisable(true);
        this.spnPriceLow.setDisable(true);
        this.txtStartHour.setDisable(true);
        this.txtStartMinute.setDisable(true);
        this.txtEndHour.setDisable(true);
        this.txtEndMinute.setDisable(true);
        this.cmbAggress.setDisable(true);
        this.spnTimeSlice.setDisable(true);
        this.spnSumMinute.setDisable(true);
        this.txtMarketPercent.setDisable(true);
        this.spnQtyExposed.setDisable(true);
        this.cmbIcePriceType.setDisable(true);
    }

    public void disable(int algoType, boolean disable, boolean passQty) {
        for (Node node : (List)this.mapAlgo.get(algoType)) {
            node.setDisable(disable);
        }
        this.lbStart.setDisable(disable);
        this.lbEnd.setDisable(disable);
        if (passQty) {
            this.spnQty.getParent().setDisable(false);
        }
        this.cmbAlgo.getParent().setDisable(disable);
        this.txtCode.setEditable(!disable);
        this.buyRadio.getParent().setDisable(disable);
        if (!disable) {
            this.txtCode.clear();
            this.lbName.setText("");
            this.txtCode.requestFocus();
            this.spnPriceLow.getEditor().clear();
            this.spnPriceUp.getEditor().clear();
            this.spnPriceMost.getEditor().clear();
            this.txtRise.clear();
            this.txtPercent.clear();
            this.spnQty.getEditor().clear();
            AlgoModel.timeLimit(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute, AlgoUtils.isRepo(this.refItem));
            this.spnTimeSlice.getEditor().clear();
            this.txtDelay.clear();
        }
    }

    private ObservableList<Algorithm> getAlgoList() {
        ObservableList list = FxUtils.newList();
        list.add((Object)this.algoFunc.getAlgorithm(19));
        list.add((Object)this.algoFunc.getAlgorithm(20));
        list.add((Object)this.algoFunc.getAlgorithm(21));
        list.add((Object)this.algoFunc.getAlgorithm(22));
        list.add((Object)this.algoFunc.getAlgorithm(23));
        return list;
    }

    @Override
    public void initControl() {
        super.initControl();
    }

    @Override
    protected void checks() {
        super.checks();
    }

    @Override
    public void order() {
    }

    public TextField getTxtCode() {
        return this.txtCode;
    }

    @Override
    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        return this.algoFunc.getRegularAlgo(engine, isBuy);
    }

    public void setMxDialog(MxDialog dialog) {
        this.dialog = dialog;
    }
}

