/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoAnnotationDialog;
import cms.tmx.algorithm.viewers.AlgoUtils;
import cms.tmx.algorithm.viewers.LoadPartModel;
import cms.tmx.control.dialog.BaseValid;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public abstract class AlgoNode
extends MxPart
implements BaseValid {
    @FXML
    public ComboBox<String> cmbEngine;
    @FXML
    public ComboBox<Algorithm> cmbAlgo;
    @FXML
    private Label lbAlgoDesc;
    @FXML
    public TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    public RadioButton buyRadio;
    @FXML
    public RadioButton sellRadio;
    @FXML
    protected VBox vboxAlgo;
    @FXML
    public Button btnOrder;
    @FXML
    public Spinner<Double> spnPriceUp;
    @FXML
    public Spinner<Double> spnPriceLow;
    @FXML
    public Spinner<Double> spnPriceMost;
    @FXML
    public ComboBox<MxNode> cmbPriceBase;
    @FXML
    public Label lbPriceMost;
    @FXML
    public CheckBox cboxRise;
    @FXML
    public TextField txtRise;
    @FXML
    public ComboBox<MxNode> cmbDepth;
    @FXML
    public TextField txtPercent;
    @FXML
    private Label lbQty;
    @FXML
    public Spinner<Integer> spnQty;
    @FXML
    public Label lbUnit;
    @FXML
    public Label lbExpUnit;
    @FXML
    public TextField txtStartHour;
    @FXML
    public TextField txtStartMinute;
    @FXML
    public TextField txtEndHour;
    @FXML
    public TextField txtEndMinute;
    @FXML
    public ComboBox<MxNode> cmbAggress;
    @FXML
    public Spinner<Integer> spnTimeSlice;
    @FXML
    public ComboBox<MxNode> cmbTimeSlice;
    @FXML
    public TextField txtDelay;
    @FXML
    protected TextField txtPartication;
    @FXML
    protected Spinner<Integer> spnWithdrawTime;
    @FXML
    protected Spinner<Integer> spnPriceBid;
    @FXML
    protected ComboBox<MxNode> cmbTarget;
    @FXML
    protected Spinner<Integer> spnOrderIntevel;
    @FXML
    protected Spinner<Integer> spnSumMinute;
    @FXML
    protected TextField txtMarketPercent;
    @FXML
    public Spinner<Integer> spnQtyExposed;
    @FXML
    public ComboBox<MxNode> cmbIcePriceType;
    @FXML
    protected Label lbAlgoErr;
    @FXML
    protected Label lbCodeErr;
    @FXML
    protected Label lbLowErr;
    @FXML
    protected Label lbUpErr;
    @FXML
    protected Label lbPriceMostErr;
    @FXML
    protected Label lbRiseErr;
    @FXML
    protected Label lbPercentErr;
    @FXML
    protected Label lbQtyErr;
    @FXML
    protected Label lbStartErr;
    @FXML
    protected Label lbEndErr;
    @FXML
    protected Label lbSliceErr;
    @FXML
    protected Label lbDelayErr;
    @FXML
    protected Label lbStart;
    @FXML
    protected Label lbEnd;
    @FXML
    protected Label qtyMag;
    @FXML
    protected Label qtyExpMag;
    @FXML
    protected Label lbPriceLimitErr;
    @FXML
    protected Label lbFloatPercentErr;
    @FXML
    protected Label lbDiskPercentErr;
    @FXML
    protected Label lbFloatNumErr;
    @FXML
    protected Label lbDiskNumErr;
    @FXML
    protected Label lbDelaySpErr;
    @FXML
    protected Label lbSumMinuteErr;
    @FXML
    protected Label lbMarketPercentErr;
    @FXML
    protected Label lbOptional;
    @Inject
    public AlgoQueryModel algo;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected IUIService uiService;
    @Inject
    protected AlgoFuncControl algoFunc;
    @Inject
    protected AlgoConfControls algoConf;
    protected Map<Integer, List<Node>> mapAlgo = new HashMap<Integer, List<Node>>();
    public DoubleSpinnerCtrl ctrlPriceUp = new DoubleSpinnerCtrl(true, 6, 0);
    public DoubleSpinnerCtrl ctrlPriceLow = new DoubleSpinnerCtrl(true, 6, 0);
    public DoubleSpinnerCtrl ctrlPriceMost = new DoubleSpinnerCtrl(true, 6, 0);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected IntSpinnerCtrl ctrlExposedCount = new IntSpinnerCtrl(true, 9, 100);
    protected IntSpinnerCtrl ctrlSlice = new IntSpinnerCtrl(true, 3, 1);
    protected IntSpinnerCtrl ctrlWithdraw = new IntSpinnerCtrl(true, 3, 1);
    protected IntSpinnerCtrl ctrlMinute = new IntSpinnerCtrl(true, 1, 1);
    protected ToggleGroup group = new ToggleGroup();
    protected SecSuggest spCode = new SecSuggest();
    protected SecConverter secCvt;
    protected static final Logger logger = LogManager.getLogger(AlgoNode.class);
    protected String buySymbol = "\u4e70\u5165";
    protected String sellSymbol = "\u5356\u51fa";
    public double priceUpLimit = 0.0;
    public double priceDownLimit = 0.0;
    public boolean priceUpAndDownLimit = true;
    public int scale = 0;
    public RefItem refItem = null;
    public Boolean isBuy = null;
    public boolean isHk = false;
    @Inject
    private LoadPartModel load;
    public MxNode nodeBasePrice = null;
    public MxNode nodeDepth = null;
    public MxNode nodeAggress = null;
    public MxNode nodeInterval = null;
    public MxNode nodeMinute = null;
    public MxNode nodePriceType = null;
    private ObservableList<Algorithm> algoList = FxUtils.newList();
    protected int sliceMax = 0;
    protected int sliceMin = 0;
    public static final int inline = 0;
    public static final int sniper = 1;
    public static final int iceberging = 2;
    public static final int twap = 5;
    public static final int vwap = 6;
    public static final int range = 7;
    public static final int liquBuy = 10;
    public static final int liquSell = 11;
    public static final int limitTwap = 12;
    public static final int limitVwap = 13;
    public static final int misetwap = 15;
    public static final int misevwap = 16;
    public static final int limitPrice = 18;
    public static final int miseLimitWapBuy = 19;
    public static final int miseLimitWapSell = 20;
    public static final int misePov = 21;
    public static final int miseIcebergBuy = 22;
    public static final int miseIcebergSell = 23;
    public static final int miseLimitPovBuy = 24;
    public static final int miseLimitPovSell = 25;
    protected Map<ObservableBooleanValue, Node> mapValid = new LinkedHashMap<ObservableBooleanValue, Node>();
    private String startTime = "";
    private String endTime = "";

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("AlgoNode.fxml");
        }
        return url;
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException e) {
            logger.error("init part failed", (Throwable)e);
        }
    }

    protected void initControl() {
        ObservableList engineList = FxUtils.newList();
        engineList.add((Object)"Apama\u5f15\u64ce");
        engineList.add((Object)"Mise\u5f15\u64ce");
        this.cmbEngine.setItems(engineList);
        this.cmbAlgo.setItems(this.algoList);
        this.cmbAlgo.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectedAlgo((Algorithm)now));
        this.cmbEngine.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.cmbAlgo.getItems().removeAll(this.algoList);
            this.algoList.clear();
            if (this.isBuy != null) {
                this.algoList.addAll(this.getAlgos((String)now, this.isBuy));
            } else {
                this.algoList.addAll(this.getAlgos((String)now, null));
            }
            this.cmbAlgo.setItems(this.algoList);
            this.cmbAlgo.show();
            this.cmbAlgo.hide();
            this.cmbAlgo.getSelectionModel().select(0);
        });
        this.lbAlgoDesc.setOnMouseClicked(event -> {
            AlgoAnnotationDialog obj = (AlgoAnnotationDialog)((Object)((Object)this.of.create(AlgoAnnotationDialog.class)));
            MxDialog dialog = this.df.create((DialogObj)obj, "\u7b97\u6cd5\u6ce8\u91ca");
            dialog.launch();
        });
        this.txtCode.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCode.selectAll());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)now));
        this.buyRadio.setSelected(true);
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        this.ctrlPriceUp.ctrl(this.spnPriceUp);
        this.ctrlPriceLow.ctrl(this.spnPriceLow);
        this.spnPriceUp.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceUp.getEditor()));
        this.spnPriceLow.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceLow.getEditor()));
        this.ctrlPriceMost.ctrl(this.spnPriceMost);
        this.spnPriceMost.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceMost.getEditor()));
        SpinnerUtils.addDoubleArrowKeyHandler(this.spnPriceMost, (double)0.0, (double)0.01);
        this.cboxRise.setText("\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b");
        this.lbRiseErr.setText("\u8bf7\u8f93\u5165\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b");
        this.txtRise.setDisable(true);
        String percent = "^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100(\\.(\\d){0,2})?)$";
        this.txtRise.setTextFormatter((TextFormatter)new MxFormatter(percent, 5));
        this.cboxRise.selectedProperty().addListener((ob, old, now) -> {
            this.txtRise.setDisable(now == false);
            this.cmbPriceBase.setDisable(now == false);
            this.spnPriceMost.setDisable(now.booleanValue());
            this.optionChange((boolean)now);
        });
        this.nodeBasePrice = MxNodeFactory.create((String)"base_price", (String)"0");
        this.cmbPriceBase.setItems(this.nodeBasePrice.getNodes());
        this.cmbPriceBase.setValue((Object)this.nodeBasePrice);
        this.cmbPriceBase.setDisable(true);
        this.ctrlCount.ctrl(this.spnQty);
        this.spnQty.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnQty.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnQty, (int)0, (int)100);
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.spnQty.getEditor());
        this.nodeDepth = MxNodeFactory.createNew((String)"depth_sell", (String)"1");
        this.cmbDepth.setItems(this.nodeDepth.getNodes());
        this.cmbDepth.setValue((Object)this.nodeDepth);
        this.txtPercent.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtPercent.selectAll());
        percent = "^(([0-9]|([1-9][0-9])|(100)))?$";
        this.txtPercent.setTextFormatter((TextFormatter)new MxFormatter(percent, 3));
        this.txtPercent.setText("100");
        this.nodeAggress = MxNodeFactory.create((String)"agress_level", (String)"0");
        this.cmbAggress.setItems(this.nodeAggress.getNodes());
        this.cmbAggress.setValue((Object)this.nodeAggress);
        this.ctrlSlice.ctrl(this.spnTimeSlice);
        this.spnTimeSlice.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnTimeSlice.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnTimeSlice, (int)0, (int)1);
        this.nodeInterval = MxNodeFactory.create((String)"algo_time_interval", (String)"1");
        this.cmbTimeSlice.setItems(this.nodeInterval.getNodes());
        this.cmbTimeSlice.setValue((Object)this.nodeInterval);
        this.ctrlMinute.ctrl(this.spnSumMinute);
        SpinnerValueFactory.IntegerSpinnerValueFactory minuteSpinner = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 5, 5);
        this.spnSumMinute.setValueFactory((SpinnerValueFactory)minuteSpinner);
        this.txtMarketPercent.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtMarketPercent.selectAll());
        percent = "^(([0-9]|([1-4][0-9])|(50)))?$";
        this.txtMarketPercent.setTextFormatter((TextFormatter)new MxFormatter(percent, 2));
        this.nodePriceType = MxNodeFactory.create((String)"iceberg_price_type", (String)"1");
        this.cmbIcePriceType.setItems(this.nodePriceType.getNodes());
        this.cmbIcePriceType.setValue((Object)this.nodePriceType);
        this.ctrlExposedCount.ctrl(this.spnQtyExposed);
        this.spnQtyExposed.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnQtyExposed.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnQtyExposed, (int)0, (int)100);
        TextFieldUtils.showMagnitude((Label)this.qtyExpMag, (TextField)this.spnQtyExposed.getEditor());
        this.spnQtyExposed.getEditor().addEventHandler(InputEvent.ANY, e -> {
            if (this.spnQtyExposed.getEditor().getText().isEmpty()) {
                this.lbOptional.setVisible(true);
            } else {
                this.lbOptional.setVisible(false);
            }
        });
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtEndHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtEndMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndMinute));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        if (this.isHk()) {
            AlgoModel.timeLimitHk(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute);
        } else {
            AlgoModel.timeLimit(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute, AlgoUtils.isRepo(this.refItem));
        }
        this.ctrlWithdraw.ctrl(this.spnWithdrawTime);
        SpinnerUtils.arrowsStyle(this.spnQty);
        SpinnerUtils.arrowsStyle(this.spnPriceLow);
        SpinnerUtils.arrowsStyle(this.spnPriceUp);
        SpinnerUtils.arrowsStyle(this.spnPriceMost);
        SpinnerUtils.arrowsStyle(this.spnTimeSlice);
        SpinnerUtils.arrowsStyle(this.spnWithdrawTime);
        SpinnerUtils.arrowsStyle(this.spnSumMinute);
        SpinnerUtils.arrowsStyle(this.spnQtyExposed);
        this.spnQty.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.enterKeyOrder((KeyEvent)event));
        this.spnQtyExposed.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.enterKeyOrder((KeyEvent)event));
        this.txtDelay.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        this.txtDelay.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtDelay.selectAll());
        this.cmbEngine.getSelectionModel().select(0);
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    protected void loseFocus(Boolean val) {
    }

    public void selectedAlgo(Algorithm algo) {
        if (algo == null) {
            return;
        }
        int type = algo.getType();
        this.buyRadio.setDisable(false);
        this.sellRadio.setDisable(false);
        switch (type) {
            case 10: {
                this.buyRadio.setSelected(true);
                this.buyRadio.setDisable(true);
                this.sellRadio.setDisable(true);
                this.lbPriceMost.setText("\u6700\u9ad8\u4e70\u4ef7");
                break;
            }
            case 11: {
                this.sellRadio.setSelected(true);
                this.buyRadio.setDisable(true);
                this.sellRadio.setDisable(true);
                this.lbPriceMost.setText("\u6700\u4f4e\u5356\u4ef7");
            }
        }
        if (type == 19 || type == 20) {
            type = this.buyRadio.isSelected() ? 19 : 20;
            this.priceUpAndDownLimit = false;
        } else if (type == 22) {
            type = this.buyRadio.isSelected() ? 22 : 23;
            this.priceUpAndDownLimit = false;
        } else if (type == 23) {
            type = this.buyRadio.isSelected() ? 24 : 25;
            this.priceUpAndDownLimit = false;
        }
        this.spnPriceUp.getEditor().clear();
        this.spnPriceLow.getEditor().clear();
        this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(type));
        this.clear(true);
    }

    protected void clear(boolean isAlgo) {
        if (!isAlgo) {
            this.spnPriceUp.getEditor().clear();
            this.spnPriceLow.getEditor().clear();
        }
        this.spnPriceMost.getEditor().clear();
        this.cmbDepth.getSelectionModel().select(0);
        this.cmbTimeSlice.getSelectionModel().select(0);
        this.cmbAggress.getSelectionModel().select(0);
        this.txtRise.clear();
        this.txtPercent.setText("100");
        this.txtDelay.setText("3");
        this.txtMarketPercent.clear();
        this.cboxRise.setSelected(false);
        if (this.isHk()) {
            AlgoModel.timeLimitHk(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute);
        } else {
            AlgoModel.timeLimit(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute, AlgoUtils.isRepo(this.refItem));
        }
        this.setDefTime();
        if (isAlgo) {
            this.lbCodeErr.setOpacity(0.0);
        }
        this.lbLowErr.setOpacity(0.0);
        this.lbUpErr.setOpacity(0.0);
        this.lbPriceMostErr.setOpacity(0.0);
        this.lbRiseErr.setOpacity(0.0);
        this.lbPercentErr.setOpacity(0.0);
        this.lbQtyErr.setOpacity(0.0);
        this.lbStartErr.setOpacity(0.0);
        this.lbEndErr.setOpacity(0.0);
        this.lbSliceErr.setOpacity(0.0);
        this.lbDelayErr.setOpacity(0.0);
        this.lbPriceLimitErr.setOpacity(0.0);
        this.lbFloatPercentErr.setOpacity(0.0);
        this.lbDiskPercentErr.setOpacity(0.0);
        this.lbFloatNumErr.setOpacity(0.0);
        this.lbDiskNumErr.setOpacity(0.0);
        this.lbDelaySpErr.setOpacity(0.0);
    }

    public void optionChange(boolean flag) {
        MxNode node = (MxNode)this.cmbPriceBase.getValue();
        node.removeNode("1");
        if (flag) {
            node.removeNode("0");
            node = node.getNode("2");
        } else {
            node.addNode("0");
            node = node.getNode("0");
        }
        this.cmbPriceBase.setValue((Object)node);
    }

    protected void onBSChange(Boolean now) {
        String depth = now != false ? "depth_sell" : "depth_buy";
        MxNode node = MxNodeFactory.create((String)depth, (String)"1");
        this.cmbDepth.getItems().setAll((Collection)node.getNodes());
        this.cmbDepth.setValue((Object)node);
        this.cboxRise.setText(now != false ? "\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b" : "\u6700\u4f4e\u4e0b\u6d6e\u6bd4\u4f8b");
        this.lbRiseErr.setText(now != false ? "\u8bf7\u8f93\u5165\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b" : "\u8bf7\u8f93\u5165\u6700\u4f4e\u4e0b\u6d6e\u6bd4\u4f8b");
        this.lbPriceMostErr.setText(now != false ? "\u8bf7\u8f93\u5165\u6700\u9ad8\u4e70\u4ef7" : "\u8bf7\u8f93\u5165\u6700\u4f4e\u5356\u4ef7");
        if (now.booleanValue()) {
            this.btnOrder.setText(this.buySymbol);
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        } else {
            this.btnOrder.setText(this.sellSymbol);
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
        }
        Algorithm algo = (Algorithm)this.cmbAlgo.getValue();
        if (algo == null) {
            return;
        }
        int type = algo.getType();
        if (type == 19 || type == 20) {
            type = now != false ? 19 : 20;
            this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(type));
        } else if (type == 22) {
            type = now != false ? 22 : 23;
            this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(type));
        } else if (type == 23) {
            type = now != false ? 24 : 25;
            this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(type));
        }
    }

    protected void checks() {
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.txtCode.isFocused()) {
                if (this.txtCode.getText().isEmpty()) {
                    this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                    return false;
                }
                if (this.lbName.getText().isEmpty()) {
                    this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.focusedProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.textProperty(), this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbLowErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            double priceLow = this.getDouble(this.spnPriceLow);
            if (priceLow == 0.0) {
                this.lbLowErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u4e0b\u9650");
                return false;
            }
            if (this.priceDownLimit != 0.0 && priceLow < this.priceDownLimit) {
                BigDecimal big = new BigDecimal(String.valueOf(this.priceDownLimit));
                big.setScale(3, 4);
                this.lbLowErr.setText("\u4ef7\u683c\u4e0b\u9650\u4e0d\u80fd\u5c0f\u4e8e" + String.format("%." + this.scale + "f", Double.valueOf(AlgoNode.subZeroAndDot(big.toPlainString()))));
                return false;
            }
            if (this.spnPriceUp.getEditor().getText().isEmpty()) {
                return true;
            }
            double priceUp = this.getDouble(this.spnPriceUp);
            if (this.priceUpAndDownLimit && priceUp < priceLow) {
                this.lbLowErr.setText("\u4ef7\u683c\u4e0b\u9650  <= \u4ef7\u683c\u4e0a\u9650");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnPriceUp.getEditor().textProperty(), this.spnPriceLow.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbUpErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            double priceUp = this.getDouble(this.spnPriceUp);
            if (priceUp == 0.0) {
                this.lbUpErr.setText("\u8bf7\u8f93\u5165\u4ef7\u683c\u4e0a\u9650");
                return false;
            }
            if (this.priceUpLimit != 0.0 && priceUp > this.priceUpLimit) {
                BigDecimal big = new BigDecimal(String.valueOf(this.priceUpLimit));
                big.setScale(3, 4);
                this.lbUpErr.setText("\u4ef7\u683c\u4e0a\u9650\u4e0d\u80fd\u5927\u4e8e" + String.format("%." + this.scale + "f", Double.valueOf(AlgoNode.subZeroAndDot(big.toPlainString()))));
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnPriceUp.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbPriceMostErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.cboxRise.isSelected()) {
                if (!StringUtils.isDouble((String)this.spnPriceMost.getEditor().getText())) {
                    return false;
                }
                if (this.getDouble(this.spnPriceMost) == 0.0) {
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.spnPriceMost.getEditor().textProperty(), this.cboxRise.selectedProperty()}));
        this.registerCheck((Node)this.lbRiseErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.cboxRise.isSelected() || StringUtils.isDouble((String)this.txtRise.getText()), (Observable[])new Observable[]{this.txtRise.textProperty(), this.cboxRise.selectedProperty()}));
        this.registerCheck((Node)this.lbPercentErr, (ObservableBooleanValue)this.txtPercent.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPercentErr, (ObservableBooleanValue)this.txtPercent.textProperty().isNotEqualTo("0"));
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                if (this.isHk()) {
                    if (!AlgoModel.timeIsValidHk(start)) {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:59");
                        return false;
                    }
                } else {
                    boolean isRepo = AlgoUtils.isRepo(this.refItem);
                    if (!AlgoModel.timeIsValid(start, isRepo)) {
                        if (isRepo) {
                            this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                        } else {
                            this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                        }
                        return false;
                    }
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty()}));
        }
        this.registerCheck((Node)this.lbSliceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int slice = this.getInt(this.spnTimeSlice.getEditor());
            if (slice > this.sliceMax || slice < this.sliceMin) {
                this.lbSliceErr.setText("\u8bf7\u8f93\u5165\u65f6\u95f4\u7247\u6570:" + this.sliceMin + "~" + this.sliceMax);
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnTimeSlice.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbDelayErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int delay = this.getInt(this.txtDelay);
            if (delay > 0 && delay <= 86400) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtDelay.textProperty()}));
        this.registerCheck((Node)this.lbSumMinuteErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int sumMin = this.getInt(this.spnSumMinute.getEditor());
            if (sumMin >= 1 && sumMin <= 5) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.spnSumMinute.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbMarketPercentErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int mktPct = this.getInt(this.txtMarketPercent);
            if (mktPct >= 1 && mktPct <= 50) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtMarketPercent.textProperty()}));
    }

    protected void sliceChange() {
        int startHour = this.getInt(this.txtStartHour);
        int startMinute = this.getInt(this.txtStartMinute);
        int endHour = this.getInt(this.txtEndHour);
        int endMinute = this.getInt(this.txtEndMinute);
        this.sliceMax = AlgoModel.computeSlice(startHour, startMinute, endHour, endMinute);
        this.sliceMin = this.sliceMax / 10;
        this.sliceMin = this.sliceMin < 2 ? 1 : this.sliceMin;
        int sliceDef = this.sliceMax / 5;
        sliceDef = sliceDef < 2 ? 1 : sliceDef;
        this.spnTimeSlice.getEditor().setText(String.valueOf(sliceDef));
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : StringUtils.parseInt((String)txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected double getDouble(TextField tf) {
        String txt = tf.getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected void initAlgo() {
        this.vboxAlgo.getChildren().clear();
        List<Node> list = this.getItems(new Node[]{this.spnQty, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapAlgo.put(5, list);
        this.mapAlgo.put(6, list);
        this.mapAlgo.put(15, list);
        this.mapAlgo.put(16, list);
        this.mapAlgo.put(7, this.getItems(new Node[]{this.spnPriceLow, this.spnPriceUp, this.spnQty, this.cmbDepth, this.cmbTimeSlice}));
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceMost, this.txtRise, this.cmbPriceBase, this.cmbDepth, this.txtPercent, this.txtDelay});
        this.mapAlgo.put(10, list);
        this.mapAlgo.put(11, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceLow, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapAlgo.put(12, list);
        this.mapAlgo.put(13, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceLow, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.txtPartication, this.spnWithdrawTime});
        this.mapAlgo.put(0, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceBid, this.cmbTarget, this.spnOrderIntevel});
        this.mapAlgo.put(1, list);
        list = this.getItems(new Node[]{this.spnQty, this.txtStartHour, this.txtEndHour});
        this.mapAlgo.put(2, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapAlgo.put(19, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceLow, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice});
        this.mapAlgo.put(20, list);
        list = this.getItems(new Node[]{this.spnQty, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice, this.spnSumMinute, this.txtMarketPercent});
        this.mapAlgo.put(21, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnQtyExposed, this.cmbIcePriceType, this.spnPriceUp, this.txtStartHour, this.txtEndHour});
        this.mapAlgo.put(22, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnQtyExposed, this.cmbIcePriceType, this.spnPriceLow, this.txtStartHour, this.txtEndHour});
        this.mapAlgo.put(23, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceUp, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice, this.spnSumMinute, this.txtMarketPercent});
        this.mapAlgo.put(24, list);
        list = this.getItems(new Node[]{this.spnQty, this.spnPriceLow, this.txtStartHour, this.txtEndHour, this.cmbAggress, this.spnTimeSlice, this.spnSumMinute, this.txtMarketPercent});
        this.mapAlgo.put(25, list);
    }

    protected List<Node> getItems(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent().getParent());
            ++n2;
        }
        return list;
    }

    public ObservableList<Node> getChildren() {
        return ((VBox)VBox.class.cast(this.content)).getChildren();
    }

    public boolean valid() {
        ObservableList list = this.vboxAlgo.getChildren();
        for (Map.Entry<ObservableBooleanValue, Node> entry : this.mapValid.entrySet()) {
            this.checkNode(entry.getValue(), entry.getKey());
            if (!list.contains(entry.getValue().getParent()) && !entry.getValue().equals(this.lbCodeErr) && !entry.getValue().equals(this.lbAlgoErr) || entry.getKey().get()) continue;
            return false;
        }
        return true;
    }

    protected void enterKeyOrder(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    public void order() {
    }

    protected AlgoParam submitParam(RefItem refItem) {
        AlgoParam param = (AlgoParam)this.of.create(AlgoParam.class);
        param.setAlgorithm((Algorithm)this.cmbAlgo.getValue());
        param.setMarket(refItem.getMarket());
        param.setType(refItem.getType());
        param.setCode(refItem.getCode());
        param.setName(refItem.getName());
        param.setBuy(this.buyRadio.isSelected());
        param.setPriceUp(this.getDouble(this.spnPriceUp));
        param.setPriceLow(this.getDouble(this.spnPriceLow));
        if (this.cboxRise.isSelected()) {
            param.setPercentRise(this.getDouble(this.txtRise) / 100.0);
            param.setBasePrice(Integer.parseInt(((MxNode)this.cmbPriceBase.getValue()).getRaw()));
        } else {
            param.setPriceMost(this.getDouble(this.spnPriceMost));
        }
        if (this.cmbDepth.getValue() != null) {
            param.setDepth(Integer.parseInt(((MxNode)this.cmbDepth.getValue()).getRaw()));
        }
        param.setPercentDepth(this.getDouble(this.txtPercent) / 100.0);
        param.setCount(this.getInt(this.spnQty.getEditor()));
        param.setStartHour(this.getInt(this.txtStartHour));
        param.setStartMinute(this.getInt(this.txtStartMinute));
        param.setEndHour(this.getInt(this.txtEndHour));
        param.setEndMinute(this.getInt(this.txtEndMinute));
        int aggress = Integer.valueOf(((MxNode)this.cmbAggress.getValue()).getRaw());
        param.setAggress(aggress);
        int type = ((Algorithm)this.cmbAlgo.getValue()).getType();
        int slice = this.getInt(this.spnTimeSlice.getEditor());
        if (type == 7) {
            slice = Integer.parseInt(((MxNode)this.cmbTimeSlice.getValue()).getRaw());
        }
        param.setSlice(slice);
        param.setDelay(this.getInt(this.txtDelay));
        int sumMinute = this.getInt(this.spnSumMinute.getEditor());
        param.setSumMinute(sumMinute);
        param.setMarketPercent(this.getDouble(this.txtMarketPercent) / 100.0);
        int priceType = Integer.valueOf(((MxNode)this.cmbIcePriceType.getValue()).getRaw());
        param.setPriceType(priceType);
        param.setQtyExposed(this.getInt(this.spnQtyExposed.getEditor()));
        return param;
    }

    public Map<ObservableBooleanValue, Node> getValids() {
        return this.mapValid;
    }

    public RadioButton getBuyRadio() {
        return this.buyRadio;
    }

    public static String subZeroAndDot(String s) {
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    public void setDefTime(String start, String end) {
        if (start.equals(this.startTime) && end.equals(this.endTime)) {
            return;
        }
        this.startTime = start;
        this.endTime = end;
        int first = start.indexOf(":");
        int second = start.indexOf(":", first + 1);
        this.txtStartHour.setText(start.substring(0, first));
        this.txtStartMinute.setText(start.substring(first + 1, second));
        first = end.indexOf(":");
        second = end.indexOf(":", first + 1);
        this.txtEndHour.setText(end.substring(0, first));
        this.txtEndMinute.setText(end.substring(first + 1, second));
    }

    public void setDefTime() {
        if (this.startTime.isEmpty() || this.endTime.isEmpty()) {
            return;
        }
        int first = this.startTime.indexOf(":");
        int second = this.startTime.indexOf(":", first + 1);
        this.txtStartHour.setText(this.startTime.substring(0, first));
        this.txtStartMinute.setText(this.startTime.substring(first + 1, second));
        first = this.endTime.indexOf(":");
        second = this.endTime.indexOf(":", first + 1);
        this.txtEndHour.setText(this.endTime.substring(0, first));
        this.txtEndMinute.setText(this.endTime.substring(first + 1, second));
    }

    public List<Algorithm> getAlgos(String engine) {
        return this.getAlgos(engine, null);
    }

    public abstract List<Algorithm> getAlgos(String var1, Boolean var2);

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    public boolean isHk() {
        return this.isHk;
    }

    public void setHk(boolean isHk) {
        this.isHk = isHk;
    }
}

