/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.util.Calendar;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javax.inject.Inject;

public class AlgoMiseWapDialog
extends DialogObj {
    @FXML
    private VBox vbNode;
    @FXML
    private HBox hboxStartTime;
    @FXML
    private TextField txtStartHour;
    @FXML
    private TextField txtStartMinute;
    @FXML
    private HBox hboxEndTime;
    @FXML
    private TextField txtEndHour;
    @FXML
    private TextField txtEndMinute;
    @FXML
    protected Label lbStartErr;
    @FXML
    protected Label lbEndErr;
    @FXML
    protected Label lbTimeSliceErr;
    @FXML
    protected ComboBox<MxNode> cmbAggress;
    @FXML
    public Spinner<Integer> spnTimeSlice;
    @FXML
    public Label lbHint;
    @Inject
    protected AlgoModel algo;
    @Inject
    protected MObjFactory of;
    @Inject
    protected AlgoConfControls algoConf;
    protected IntSpinnerCtrl ctrlSlice = new IntSpinnerCtrl(true, 3, 1);
    public boolean isAllRepo;
    protected Boolean limitPriceHint;
    protected int sliceMax = 0;
    protected int sliceMin = 0;
    public String start = "";
    public String end = "";

    @FXML
    public void initialize() {
        this.initControls();
        this.initParam();
        this.checks();
    }

    private void initParam() {
        this.txtStartHour.setText(AlgoModel.complement(this.algo.getStartHour()));
        this.txtStartMinute.setText(AlgoModel.complement(this.algo.getStartMinute()));
        this.txtEndHour.setText(AlgoModel.complement(this.algo.getEndHour()));
        this.txtEndMinute.setText(AlgoModel.complement(this.algo.getEndMinute()));
        MxNode node = ((MxNode)this.cmbAggress.getValue()).getNode(String.valueOf(this.algo.getAggress()));
        this.cmbAggress.getSelectionModel().select((Object)node);
        if (this.algo.getSlice() != 0 && this.algo.getSlice() <= this.sliceMax && this.algo.getSlice() >= this.sliceMin) {
            this.spnTimeSlice.getEditor().setText(String.valueOf(this.algo.getSlice()));
        }
    }

    private void initControls() {
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        if (this.algo.getStartHour() == 0 && this.algo.getEndHour() == 0) {
            Platform.runLater(() -> {
                if ("".equals(this.start) && "".equals(this.end)) {
                    AlgoModel.timeLimit(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute, this.isAllRepo);
                } else {
                    this.setDefTime();
                }
            });
        }
        this.txtStartHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtEndMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtEndHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtEndMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndMinute));
        MxNode node = MxNodeFactory.create((String)"agress_level", (String)"0");
        this.cmbAggress.setItems(node.getNodes());
        this.cmbAggress.setValue((Object)node);
        this.ctrlSlice.ctrl(this.spnTimeSlice);
        this.spnTimeSlice.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnTimeSlice.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnTimeSlice, (int)0, (int)1);
        String limitUpHint = "\u9650\u4ef7\u4ef7\u683c\u53d6\u5404\u6210\u5206\u80a1\u4e0a\u9650\u4ef7\u683c\uff0c\u82e5\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u8fdb\u884c\u9650\u4ef7\u63a7\u5236";
        String limitLowHint = "\u9650\u4ef7\u4ef7\u683c\u53d6\u5404\u6210\u5206\u80a1\u4e0b\u9650\u4ef7\u683c\uff0c\u82e5\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u8fdb\u884c\u9650\u4ef7\u63a7\u5236";
        if (this.limitPriceHint != null) {
            this.lbHint.setVisible(true);
            this.lbHint.setDisable(false);
            this.lbHint.setText(this.limitPriceHint != false ? limitUpHint : limitLowHint);
        }
    }

    private void checks() {
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                if (!AlgoModel.timeIsValid(start, this.isAllRepo)) {
                    if (this.isAllRepo) {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                    } else {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                    }
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty()}));
            this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int minuter;
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
                if (!AlgoModel.timeIsValid(end, this.isAllRepo)) {
                    if (this.isAllRepo) {
                        this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                    } else {
                        this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                    }
                    return false;
                }
                if (end < start) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65f6\u95f4");
                    return false;
                }
                Calendar calender = Calendar.getInstance();
                int hour = calender.get(11);
                if (end < hour * 60 + (minuter = calender.get(12))) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.algo.minuteProperty()}));
        }
        this.registerCheck((Node)this.lbTimeSliceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int slice = this.getInt(this.spnTimeSlice.getEditor());
            if (slice > this.sliceMax || slice < this.sliceMin) {
                this.lbTimeSliceErr.setText("\u8bf7\u8f93\u5165\u65f6\u95f4\u7247\u6570:" + this.sliceMin + "~" + this.sliceMax);
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnTimeSlice.getEditor().textProperty()}));
    }

    protected void sliceChange() {
        int startHour = this.getInt(this.txtStartHour);
        int startMinute = this.getInt(this.txtStartMinute);
        int endHour = this.getInt(this.txtEndHour);
        int endMinute = this.getInt(this.txtEndMinute);
        this.sliceMax = AlgoModel.computeSlice(startHour, startMinute, endHour, endMinute);
        this.sliceMin = this.sliceMax / 10;
        this.sliceMin = this.sliceMin < 2 ? 1 : this.sliceMin;
        int sliceDef = this.sliceMax / 5;
        sliceDef = sliceDef < 2 ? 1 : sliceDef;
        this.spnTimeSlice.getEditor().setText(String.valueOf(sliceDef));
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected boolean isOK(ButtonType bt) {
        this.algo.setStartHour(Integer.valueOf(this.txtStartHour.getText()));
        this.algo.setStartMinute(Integer.valueOf(this.txtStartMinute.getText()));
        this.algo.setEndHour(Integer.valueOf(this.txtEndHour.getText()));
        this.algo.setEndMinute(Integer.valueOf(this.txtEndMinute.getText()));
        this.algo.setAggress(Integer.valueOf(((MxNode)this.cmbAggress.getValue()).getRaw()));
        this.algo.setSlice(Integer.valueOf(this.spnTimeSlice.getEditor().getText().replaceAll(",", "")));
        this.algo.ready();
        return true;
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : Integer.parseInt(txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : Double.parseDouble(txt);
    }

    public void setMise(AlgoModel algo) {
        this.algo = algo;
    }

    public void setLimitPriceHint(Boolean isLimitUp) {
        this.limitPriceHint = isLimitUp;
    }

    public void setDefTime() {
        if (this.start.isEmpty() || this.end.isEmpty()) {
            return;
        }
        int first = this.start.indexOf(":");
        int second = this.start.indexOf(":", first + 1);
        this.txtStartHour.setText(this.start.substring(0, first));
        this.txtStartMinute.setText(this.start.substring(first + 1, second));
        first = this.end.indexOf(":");
        second = this.end.indexOf(":", first + 1);
        this.txtEndHour.setText(this.end.substring(0, first));
        this.txtEndMinute.setText(this.end.substring(first + 1, second));
    }

    public void setDisable(boolean isDisable) {
        this.vbNode.setDisable(isDisable);
        if (isDisable) {
            this.lbStartErr.setVisible(false);
            this.lbEndErr.setVisible(false);
        }
    }
}

