/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.util.Calendar;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javax.inject.Inject;

public class AlgoMiseDefaultDialog
extends DialogObj {
    @FXML
    public AnchorPane anchorPane;
    @FXML
    private ComboBox<MxNode> cmbPriceTerms;
    @FXML
    private Spinner<Double> spnExceedPrice;
    @FXML
    private ComboBox<MxNode> cmbDatumQty;
    @FXML
    private Spinner<Integer> spnDatumPercent;
    @FXML
    private Spinner<Integer> spnOrderIntevel;
    @FXML
    private Spinner<Integer> spnCancelIntevel;
    @FXML
    private Spinner<Integer> spnMinitabQty;
    @FXML
    private Spinner<Integer> spnWaveRang;
    @FXML
    private Spinner<Integer> spnMinQty;
    @FXML
    private Spinner<Integer> spnMaxQty;
    @FXML
    private HBox hboxStartTime;
    @FXML
    private TextField txtStartHour;
    @FXML
    private TextField txtStartMinute;
    @FXML
    private HBox hboxEndTime;
    @FXML
    private TextField txtEndHour;
    @FXML
    private TextField txtEndMinute;
    @FXML
    private TextField txtOrderTime;
    @FXML
    private Label lbPriceTermsErr;
    @FXML
    private Label lbDatumPercentErr;
    @FXML
    private Label lbDatumQtyErr;
    @FXML
    private Label lbOrderIntevelErr;
    @FXML
    private Label lbCancelIntevelErr;
    @FXML
    private Label lbMinitabQtyErr;
    @FXML
    private Label lbMinQtyErr;
    @FXML
    private Label lbMaxQtyErr;
    @FXML
    protected Label lbStartErr;
    @FXML
    protected Label lbEndErr;
    @FXML
    private Label lbOrderTimeErr;
    @FXML
    private Label lbWaveRangErr;
    protected DoubleSpinnerCtrl ctrlExceedPrice = new DoubleSpinnerCtrl(true, 2, 2);
    protected IntSpinnerCtrl ctrlDatumPercent = new IntSpinnerCtrl(true, 3, 1);
    protected IntSpinnerCtrl ctrlOrderIntevel = new IntSpinnerCtrl(true, 5, 1);
    protected IntSpinnerCtrl ctrlCancelPercent = new IntSpinnerCtrl(true, 5, 1);
    protected IntSpinnerCtrl ctrlMinitabQty = new IntSpinnerCtrl(true, 7, 1);
    protected IntSpinnerCtrl ctrlWaveRang = new IntSpinnerCtrl(true, 3, 1);
    protected IntSpinnerCtrl ctrlMinQty = new IntSpinnerCtrl(true, 7, 1);
    protected IntSpinnerCtrl ctrlMaxQty = new IntSpinnerCtrl(true, 7, 1);
    @Inject
    protected AlgoModel algo;
    @Inject
    protected MObjFactory of;
    @Inject
    protected AlgoConfControls algoConf;
    public boolean isAllRepo;
    public String start = "";
    public String end = "";

    @FXML
    public void initialize() {
        this.initControls();
        this.initParam();
        this.checks();
    }

    private void initParam() {
        this.cmbPriceTerms.getSelectionModel().select((Object)this.algo.getPriceterms());
        this.spnExceedPrice.getEditor().setText(String.valueOf(this.algo.getExceedPrice()));
        this.cmbDatumQty.getSelectionModel().select((Object)this.algo.getDatumQty());
        this.spnDatumPercent.getEditor().setText(String.valueOf(this.algo.getDatumPercent()));
        this.spnOrderIntevel.getEditor().setText(String.valueOf(this.algo.getOrderIntevel()));
        this.spnCancelIntevel.getEditor().setText(String.valueOf(this.algo.getCancelIntevel()));
        this.spnMinitabQty.getEditor().setText(String.valueOf(this.algo.getMinitabQty()));
        this.spnWaveRang.getEditor().setText(String.valueOf(this.algo.getWaveRang()));
        this.spnMinQty.getEditor().setText(String.valueOf(this.algo.getMinQty()));
        this.spnMaxQty.getEditor().setText(String.valueOf(this.algo.getMaxQty()));
        this.txtOrderTime.setText(String.valueOf(this.algo.getOrderTime()));
        this.txtStartHour.setText(AlgoModel.complement(this.algo.getStartHour()));
        this.txtStartMinute.setText(AlgoModel.complement(this.algo.getStartMinute()));
        this.txtEndHour.setText(AlgoModel.complement(this.algo.getEndHour()));
        this.txtEndMinute.setText(AlgoModel.complement(this.algo.getEndMinute()));
    }

    private void initControls() {
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("price_terms", "0");
        node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw()));
        this.cmbPriceTerms.setItems(node.getNodes());
        this.ctrlExceedPrice.ctrl(this.spnExceedPrice);
        String percent = "^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$";
        this.spnExceedPrice.getEditor().setTextFormatter((TextFormatter)new MxFormatter(percent, 5));
        this.spnExceedPrice.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectDecimal((TextField)this.spnExceedPrice.getEditor()));
        this.spnExceedPrice.getEditor().setText("0.00");
        node = MxNodeFactory.create((String)"datum_qty", (String)"0");
        node.getNodes().sort((o1, o2) -> Integer.valueOf(o1.getRaw()) - Integer.valueOf(o2.getRaw()));
        this.cmbDatumQty.setItems(node.getNodes());
        this.ctrlDatumPercent.ctrl(this.spnDatumPercent);
        percent = "^([0-9]|[1-9][0-9]|100)$";
        this.spnDatumPercent.getEditor().setTextFormatter((TextFormatter)new MxFormatter(percent, 3));
        this.ctrlOrderIntevel.ctrl(this.spnOrderIntevel);
        this.spnOrderIntevel.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        this.ctrlCancelPercent.ctrl(this.spnCancelIntevel);
        this.spnCancelIntevel.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        this.spnOrderIntevel.getEditor().setText("60");
        this.spnCancelIntevel.getEditor().setText("60");
        this.ctrlMinitabQty.ctrl(this.spnMinitabQty);
        this.spnMinitabQty.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 7));
        this.spnMinitabQty.getEditor().setText("1");
        this.ctrlWaveRang.ctrl(this.spnWaveRang);
        this.spnWaveRang.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 3));
        this.spnWaveRang.getEditor().setTextFormatter((TextFormatter)new MxFormatter(percent, 3));
        this.spnWaveRang.getEditor().setText("5");
        this.ctrlMinQty.ctrl(this.spnMinQty);
        this.ctrlMaxQty.ctrl(this.spnMaxQty);
        this.spnMinQty.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 7));
        this.spnMaxQty.getEditor().setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 7));
        this.spnMinQty.getEditor().setText("100");
        this.spnMaxQty.getEditor().setText("10000");
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtEndHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtEndMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtEndHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.txtEndMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtEndMinute.selectAll());
        if (this.algo.getStartHour() == 0) {
            Platform.runLater(() -> {
                AlgoModel.timeLimit(this.txtStartHour, this.txtStartMinute, this.txtEndHour, this.txtEndMinute, this.isAllRepo);
                this.setDefTime();
            });
        }
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtEndHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtEndMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtEndMinute));
        this.txtOrderTime.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 4));
        this.txtOrderTime.setText("10");
        SpinnerUtils.arrowsStyle(this.spnExceedPrice);
        SpinnerUtils.arrowsStyle(this.spnDatumPercent);
        SpinnerUtils.arrowsStyle(this.spnOrderIntevel);
        SpinnerUtils.arrowsStyle(this.spnCancelIntevel);
        SpinnerUtils.arrowsStyle(this.spnMinitabQty);
        SpinnerUtils.arrowsStyle(this.spnWaveRang);
        SpinnerUtils.arrowsStyle(this.spnMinQty);
        SpinnerUtils.arrowsStyle(this.spnMaxQty);
    }

    private void checks() {
        this.registerCheck((Node)this.lbPriceTermsErr, (ObservableBooleanValue)this.cmbPriceTerms.valueProperty().isNotNull());
        this.registerCheck((Node)this.lbDatumQtyErr, (ObservableBooleanValue)this.cmbDatumQty.valueProperty().isNotNull());
        this.registerCheck((Node)this.lbWaveRangErr, (ObservableBooleanValue)this.spnWaveRang.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbDatumPercentErr, (ObservableBooleanValue)this.spnDatumPercent.getEditor().textProperty().greaterThan("0"));
        this.registerCheck((Node)this.lbDatumPercentErr, (ObservableBooleanValue)this.spnDatumPercent.getEditor().textProperty().greaterThan("0"));
        this.registerCheck((Node)this.lbOrderIntevelErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int orderIntevel = this.getInt(this.spnOrderIntevel.getEditor());
            if (orderIntevel >= 3 && orderIntevel <= 86400) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.spnOrderIntevel.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbCancelIntevelErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int orderIntevel = this.getInt(this.spnCancelIntevel.getEditor());
            if (orderIntevel >= 3 && orderIntevel <= 86400) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.spnCancelIntevel.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbMinitabQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int orderIntevel = this.getInt(this.spnMinitabQty.getEditor());
            if (orderIntevel >= 1 && orderIntevel <= 1000000) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.spnMinitabQty.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbMinQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int min = this.getInt(this.spnMinQty.getEditor());
            int max = this.getInt(this.spnMaxQty.getEditor());
            if (min < 100 || min > 1000000) {
                this.lbMinQtyErr.setText("\u8bf7\u8f93\u5165\u5355\u7b14\u6700\u5c0f\u91cf100-1000000");
                return false;
            }
            if (min > max) {
                this.lbMinQtyErr.setText("\u5355\u7b14\u6700\u5c0f\u91cf\u4e0d\u80fd\u5927\u4e8e\u5355\u7b14\u6700\u5927\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMinQty.getEditor().textProperty(), this.spnMaxQty.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbMaxQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int min = this.getInt(this.spnMinQty.getEditor());
            int max = this.getInt(this.spnMaxQty.getEditor());
            if (max < 100 || max > 1000000) {
                this.lbMaxQtyErr.setText("\u8bf7\u8f93\u5165\u5355\u7b14\u6700\u5927\u91cf100-1000000");
                return false;
            }
            if (min > max) {
                this.lbMaxQtyErr.setText("\u5355\u7b14\u6700\u5927\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u5355\u7b14\u6700\u5c0f\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMaxQty.getEditor().textProperty(), this.spnMinQty.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbOrderTimeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int orderIntevel = this.getInt(this.txtOrderTime);
            if (orderIntevel >= 1 && orderIntevel <= 1000) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtOrderTime.textProperty()}));
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                if (!AlgoModel.timeIsValid(start, this.isAllRepo)) {
                    if (this.isAllRepo) {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                    } else {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                    }
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty()}));
            this.registerCheck((Node)this.lbEndErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                int minuter;
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                int end = this.getInt(this.txtEndHour) * 60 + this.getInt(this.txtEndMinute);
                if (!AlgoModel.timeIsValid(end, this.isAllRepo)) {
                    if (this.isAllRepo) {
                        this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                    } else {
                        this.lbEndErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                    }
                    return false;
                }
                if (end < start) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65f6\u95f4");
                    return false;
                }
                Calendar calender = Calendar.getInstance();
                int hour = calender.get(11);
                if (end < hour * 60 + (minuter = calender.get(12))) {
                    this.lbEndErr.setText("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty(), this.txtEndHour.textProperty(), this.txtEndMinute.textProperty(), this.algo.minuteProperty()}));
        }
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected boolean isOK(ButtonType bt) {
        this.algo.setPriceterms((MxNode)this.cmbPriceTerms.getSelectionModel().getSelectedItem());
        this.algo.setExceedPrice(Double.parseDouble(this.spnExceedPrice.getEditor().getText()));
        this.algo.setDatumQty((MxNode)this.cmbDatumQty.getSelectionModel().getSelectedItem());
        this.algo.setDatumPercent(Integer.parseInt(this.spnDatumPercent.getEditor().getText()));
        this.algo.setOrderIntevel(Integer.parseInt(this.spnOrderIntevel.getEditor().getText()));
        this.algo.setCancelIntevel(Integer.parseInt(this.spnCancelIntevel.getEditor().getText()));
        this.algo.setMinitabQty(Integer.parseInt(this.spnMinitabQty.getEditor().getText()));
        this.algo.setWaveRang(Integer.parseInt(this.spnWaveRang.getEditor().getText()));
        this.algo.setMinQty(Integer.parseInt(this.spnMinQty.getEditor().getText()));
        this.algo.setMaxQty(Integer.parseInt(this.spnMaxQty.getEditor().getText()));
        this.algo.setStartHour(Integer.valueOf(this.txtStartHour.getText()));
        this.algo.setStartMinute(Integer.valueOf(this.txtStartMinute.getText()));
        this.algo.setEndHour(Integer.valueOf(this.txtEndHour.getText()));
        this.algo.setEndMinute(Integer.valueOf(this.txtEndMinute.getText()));
        this.algo.setOrderTime(Integer.parseInt(this.txtOrderTime.getText()));
        this.algo.ready();
        return true;
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : Integer.parseInt(txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : Double.parseDouble(txt);
    }

    public void setMise(AlgoModel algo) {
        this.algo = algo;
    }

    public void setDefTime() {
        if (this.start.isEmpty() || this.end.isEmpty()) {
            return;
        }
        int first = this.start.indexOf(":");
        int second = this.start.indexOf(":", first + 1);
        this.txtStartHour.setText(this.start.substring(0, first));
        this.txtStartMinute.setText(this.start.substring(first + 1, second));
        first = this.end.indexOf(":");
        second = this.end.indexOf(":", first + 1);
        this.txtEndHour.setText(this.end.substring(0, first));
        this.txtEndMinute.setText(this.end.substring(first + 1, second));
    }
}

