/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;

public class AlgoFollowUpDialog
extends DialogObj {
    @FXML
    public VBox ctTradePanel;
    @FXML
    public TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    public RadioButton buyRadio;
    @FXML
    public RadioButton sellRadio;
    @FXML
    protected VBox vboxAlgo;
    @FXML
    private Label lbQty;
    @FXML
    public Spinner<Integer> spnQty;
    @FXML
    public Label lbUnit;
    @FXML
    public Spinner<Double> spnPriceLimit;
    @FXML
    public Label lbPriceLimit;
    @FXML
    public ComboBox<MxNode> cmbPriceBaseSp;
    @FXML
    public ComboBox<MxNode> cmbFloatWay;
    @FXML
    public Spinner<Double> spnFloatNum;
    @FXML
    public Spinner<Double> spnFloatPercent;
    @FXML
    public ComboBox<MxNode> cmbDiskWay;
    @FXML
    public Spinner<Integer> spnDiskNum;
    @FXML
    public Label lbUnitDisk;
    @FXML
    public Spinner<Double> spnDiskPercent;
    @FXML
    public TextField txtDelaySp;
    @FXML
    public TableView<AccntSecInfo> tableAccSecInfo;
    @FXML
    private TableColumn<AccntSecInfo, String> investorId;
    @FXML
    private TableColumn<AccntSecInfo, Number> orderQty;
    @FXML
    private TableColumn<AccntSecInfo, String> secAccntId;
    @FXML
    protected Label lbCodeErr;
    @FXML
    protected Label lbQtyErr;
    @FXML
    protected Label qtyMag;
    @FXML
    protected Label lbPriceLimitErr;
    @FXML
    protected Label lbFloatPercentErr;
    @FXML
    protected Label lbDiskPercentErr;
    @FXML
    protected Label lbFloatNumErr;
    @FXML
    protected Label lbDiskNumErr;
    @FXML
    protected Label lbDelaySpErr;
    @FXML
    protected Label qtyDiskMag;
    @Inject
    protected AlgoModel algo;
    @Inject
    protected MObjFactory of;
    @Inject
    public IRefDataMng refMng;
    protected Parent content;
    protected Map<Integer, List<Node>> mapAlgo = new HashMap<Integer, List<Node>>();
    protected DoubleSpinnerCtrl ctrlPriceLimit = new DoubleSpinnerCtrl(true, 6, 0);
    protected DoubleSpinnerCtrl ctrlFloatNum = new DoubleSpinnerCtrl(false, 6, 0);
    protected DoubleSpinnerCtrl ctrlFloatWay = new DoubleSpinnerCtrl(false, 7, 2);
    protected DoubleSpinnerCtrl ctrlDiskWay = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected IntSpinnerCtrl ctrlDiskNum = new IntSpinnerCtrl(true, 9, 100);
    protected ToggleGroup group = new ToggleGroup();
    protected SecSuggest spCode = new SecSuggest();
    protected SecConverter secCvt;
    public MxNode nodeBasePriceSp = null;
    public MxNode nodeDiskWay = null;
    public MxNode nodeFloatWay = null;
    protected RefItem refItem = null;
    protected int sliceMax = 0;
    protected int sliceMin = 0;
    public static final int limitPrice = 18;
    protected ButtonType[] btnType = new ButtonType[]{new ButtonType("\u5173\u95ed", ButtonBar.ButtonData.OK_DONE), ButtonType.CANCEL};

    @FXML
    public void initialize() {
        this.initAlgo();
        this.initControl();
        this.createTable();
        if (this.algo.getAlgorithm().isReadOnly()) {
            this.initParam();
            this.ctTradePanel.setDisable(true);
            return;
        }
    }

    private void initParam() {
        boolean isBuy = this.algo.getAlgorithm().getAlgoParam().isBuy();
        this.lbQty.setText(isBuy ? "\u4e70\u5165\u6570\u91cf" : "\u5356\u51fa\u6570\u91cf");
        this.buyRadio.setSelected(isBuy);
        this.sellRadio.setSelected(!isBuy);
        String type = this.algo.getAlgorithm().getAlgoParam().getType();
        String market = this.algo.getAlgorithm().getAlgoParam().getMarket();
        String code = this.algo.getAlgorithm().getAlgoParam().getCode();
        String name = this.algo.getAlgorithm().getAlgoParam().getName();
        this.txtCode.setText(code);
        this.lbName.setText(name);
        RefItem item = this.refMng.getItem(type, market, code);
        this.spnQty.getEditor().setText(String.valueOf(this.algo.getCount()));
        int scale = item == null ? 3 : item.getScale();
        MxNode node = ((MxNode)this.cmbPriceBaseSp.getValue()).getNode(String.valueOf(this.algo.getBasePrice()));
        this.cmbPriceBaseSp.getSelectionModel().select((Object)node);
        this.spnPriceLimit.getEditor().setText(StringUtils.toStr((double)this.algo.getPriceMost(), (int)scale));
        this.spnQty.getEditor().setText(String.valueOf(this.algo.getCount()));
        String unit = QueryUtils.getUnit((String)type, (String)market);
        this.lbUnit.setText(unit);
        this.lbUnitDisk.setText(unit);
        this.cmbFloatWay.getSelectionModel().select((Object)((MxNode)this.cmbFloatWay.getValue()).getNode(String.valueOf(this.algo.getFloatWay())));
        this.cmbDiskWay.getSelectionModel().select((Object)((MxNode)this.cmbDiskWay.getValue()).getNode(String.valueOf(this.algo.getDiskWay())));
        this.spnFloatNum.getEditor().setText(StringUtils.toStr((double)this.algo.getFloatNum(), (int)scale));
        this.spnDiskNum.getEditor().setText(StringUtils.toStr((double)this.algo.getDiskNum(), (int)0));
        this.spnFloatPercent.getEditor().setText(StringUtils.toStr((double)(this.algo.getFloatPercent() * 100.0), (int)2));
        this.spnDiskPercent.getEditor().setText(StringUtils.toStr((double)(this.algo.getDiskPercent() * 100.0), (int)2));
        this.txtDelaySp.setText(StringUtils.toStr((double)this.algo.getDelay(), (int)0));
        ObservableList infos = FxUtils.newList();
        infos.addAll((Collection)this.algo.getAccSecInfoList());
        this.tableAccSecInfo.setItems(infos);
    }

    protected void createTable() {
        this.investorId.setCellValueFactory(data -> ((AccntSecInfo)data.getValue()).investorIdProperty());
        this.secAccntId.setCellValueFactory(data -> ((AccntSecInfo)data.getValue()).secAccntIdProperty());
        this.orderQty.setCellValueFactory(data -> ((AccntSecInfo)data.getValue()).orderQtyProperty());
        this.tableAccSecInfo.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAccSecInfo);
    }

    protected void initControl() {
        this.spCode.setAllSuggestions(this.getRefItems());
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange(this.txtCode));
        this.txtCode.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCode.selectAll());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.buyRadio.setToggleGroup(this.group);
        this.sellRadio.setToggleGroup(this.group);
        this.buyRadio.selectedProperty().bindBidirectional((Property)this.algo.buyProperty());
        this.buyRadio.selectedProperty().addListener((ob, old, now) -> this.onBSChange((Boolean)now));
        this.buyRadio.setSelected(true);
        this.nodeBasePriceSp = MxNodeFactory.create((String)"base_price_sp", (String)"1");
        this.initPriceGear(this.nodeBasePriceSp);
        this.cmbPriceBaseSp.setItems(this.nodeBasePriceSp.getNodes());
        this.cmbPriceBaseSp.setValue((Object)this.nodeBasePriceSp);
        this.nodeFloatWay = MxNodeFactory.create((String)"float_way", (String)"1");
        this.cmbFloatWay.setItems(this.nodeFloatWay.getNodes());
        this.cmbFloatWay.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectFloatWay((MxNode)now));
        this.cmbFloatWay.setValue((Object)this.nodeFloatWay);
        this.ctrlFloatWay.ctrl(this.spnFloatPercent);
        this.ctrlFloatWay.setUnit(1.0);
        this.spnFloatPercent.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnFloatPercent.getEditor()));
        SpinnerUtils.addDoubleArrowKeyHandler(this.spnFloatPercent, (double)0.0, (double)1.0);
        this.spnFloatNum.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnFloatNum.getEditor()));
        SpinnerUtils.addDoubleArrowKeyHandler(this.spnFloatNum, (double)0.0, (double)0.01);
        this.nodeDiskWay = MxNodeFactory.create((String)"disk_way", (String)"2");
        this.cmbDiskWay.setItems(this.nodeDiskWay.getNodes());
        this.cmbDiskWay.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectDiskWay((MxNode)now));
        this.cmbDiskWay.setValue((Object)this.nodeDiskWay);
        this.ctrlDiskWay.ctrl(this.spnDiskPercent);
        this.ctrlDiskWay.setUnit(1.0);
        this.spnDiskPercent.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnDiskPercent.getEditor()));
        SpinnerUtils.addDoubleArrowKeyHandler(this.spnDiskPercent, (double)0.0, (double)1.0);
        this.ctrlDiskNum.ctrl(this.spnDiskNum);
        this.spnDiskNum.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnDiskNum.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnDiskNum, (int)0, (int)100);
        TextFieldUtils.showMagnitude((Label)this.qtyDiskMag, (TextField)this.spnDiskNum.getEditor());
        this.spnPriceLimit.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnPriceLimit.getEditor()));
        SpinnerUtils.addDoubleArrowKeyHandler(this.spnPriceLimit, (double)0.0, (double)0.01);
        this.ctrlCount.ctrl(this.spnQty);
        this.spnQty.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnQty.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnQty, (int)0, (int)100);
        TextFieldUtils.showMagnitude((Label)this.qtyMag, (TextField)this.spnQty.getEditor());
        SpinnerUtils.arrowsStyle(this.spnQty);
        SpinnerUtils.arrowsStyle(this.spnPriceLimit);
        SpinnerUtils.arrowsStyle(this.spnFloatNum);
        SpinnerUtils.arrowsStyle(this.spnFloatPercent);
        SpinnerUtils.arrowsStyle(this.spnDiskNum);
        SpinnerUtils.arrowsStyle(this.spnDiskPercent);
        this.txtDelaySp.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        this.txtDelaySp.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtDelaySp.selectAll());
    }

    private Collection<RefItem> getRefItems() {
        return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
    }

    private void selectFloatWay(MxNode now) {
        if (now == null) {
            return;
        }
        if ("1".equals(now.getRaw())) {
            this.vboxAlgo.getChildren().remove((Object)this.spnFloatPercent.getParent().getParent());
            this.vboxAlgo.getChildren().remove((Object)this.spnFloatNum.getParent().getParent());
            this.vboxAlgo.getChildren().add(4, (Object)this.spnFloatPercent.getParent().getParent());
        } else if ("2".equals(now.getRaw())) {
            this.vboxAlgo.getChildren().remove((Object)this.spnFloatPercent.getParent().getParent());
            this.vboxAlgo.getChildren().remove((Object)this.spnFloatNum.getParent().getParent());
            this.vboxAlgo.getChildren().add(4, (Object)this.spnFloatNum.getParent().getParent());
        } else {
            this.vboxAlgo.getChildren().remove((Object)this.spnFloatPercent.getParent().getParent());
            this.vboxAlgo.getChildren().remove((Object)this.spnFloatNum.getParent().getParent());
        }
    }

    private void selectDiskWay(MxNode now) {
        if (now == null) {
            return;
        }
        if ("2".equals(now.getRaw())) {
            this.vboxAlgo.getChildren().remove((Object)this.spnDiskNum.getParent().getParent().getParent());
            this.vboxAlgo.getChildren().add("3".equals(((MxNode)this.cmbFloatWay.getValue()).getRaw()) ? 5 : 6, (Object)this.spnDiskPercent.getParent().getParent());
        } else {
            this.vboxAlgo.getChildren().remove((Object)this.spnDiskPercent.getParent().getParent());
            this.vboxAlgo.getChildren().add("3".equals(((MxNode)this.cmbFloatWay.getValue()).getRaw()) ? 5 : 6, (Object)this.spnDiskNum.getParent().getParent().getParent());
        }
    }

    private void initPriceGear(MxNode node) {
        this.removeOthers(node, "10");
        node.addNode("10");
        node.addNode("9");
        node.addNode("8");
        node.addNode("7");
        node.addNode("6");
        node.addNode("5");
        node.addNode("4");
        node.addNode("3");
        node.addNode("2");
        node.addNode("1");
        node.addNode("11");
        node.addNode("12");
        node.addNode("13");
        node.addNode("14");
        node.addNode("15");
        node.addNode("16");
        node.addNode("17");
        node.addNode("18");
        node.addNode("19");
        node.addNode("20");
        node.addNode("21");
        node.addNode("22");
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    protected void loseFocus(Boolean val) {
    }

    protected void clear(boolean isAlgo) {
        this.spnPriceLimit.getEditor().clear();
        this.spnFloatPercent.getEditor().clear();
        this.spnDiskPercent.getEditor().clear();
        this.spnFloatNum.getEditor().clear();
        this.spnDiskNum.getEditor().clear();
        this.cmbFloatWay.getSelectionModel().select(0);
        this.cmbDiskWay.getSelectionModel().select(0);
        this.txtDelaySp.setText("1");
        if (isAlgo) {
            this.lbCodeErr.setOpacity(0.0);
        }
        this.lbQtyErr.setOpacity(0.0);
        this.lbPriceLimitErr.setOpacity(0.0);
        this.lbFloatPercentErr.setOpacity(0.0);
        this.lbDiskPercentErr.setOpacity(0.0);
        this.lbFloatNumErr.setOpacity(0.0);
        this.lbDiskNumErr.setOpacity(0.0);
        this.lbDelaySpErr.setOpacity(0.0);
    }

    protected void onBSChange(Boolean now) {
        this.lbPriceLimit.setText(now != false ? "\u6700\u9ad8\u4e70\u5165\u4ef7" : "\u6700\u4f4e\u5356\u51fa\u4ef7");
    }

    public void onSecurityChange(TextField txtCode) {
        this.refItem = (RefItem)txtCode.getUserData();
        MarketItem mkt = this.algo.getMI();
        mkt.setRefItem(this.refItem);
        this.algo.onSecChange();
        String name = mkt.getStop().getValue() != false ? mkt.getStatus() : mkt.getRefItem().getName();
        this.lbName.setText(name);
        this.doChange(this.refItem);
    }

    public void doChange(RefItem refItem) {
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (refItem == null) {
            return;
        }
        String unit = "";
        if (refItem != null) {
            String type = refItem.getType();
            String market = refItem.getMarket();
            unit = QueryUtils.getUnit((String)type, (String)market);
            this.ctrlCount.setUnit(refItem.getBuyUnit());
        }
        this.lbUnit.setText(unit);
        this.lbUnitDisk.setText(unit);
        this.clear(false);
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : StringUtils.parseInt((String)txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected double getDouble(TextField tf) {
        String txt = tf.getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected void initAlgo() {
        this.vboxAlgo.getChildren().clear();
        List<Node> list = this.getItems(new Node[]{this.spnQty, this.spnPriceLimit, this.cmbPriceBaseSp, this.cmbFloatWay, this.spnFloatPercent, this.cmbDiskWay, this.txtDelaySp});
        this.mapAlgo.put(18, list);
        this.vboxAlgo.getChildren().setAll(list);
        this.clear(true);
    }

    protected List<Node> getItems(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent().getParent());
            ++n2;
        }
        return list;
    }

    public List<Node> getItems(int type) {
        return this.mapAlgo.get(type);
    }

    public ObservableList<Node> getChildren() {
        return ((VBox)VBox.class.cast(this.content)).getChildren();
    }

    public RadioButton getBuyRadio() {
        return this.buyRadio;
    }

    public void setPrice(Double price) {
        this.spnPriceLimit.getEditor().setText(price.toString());
    }

    public boolean isOK(ButtonType bt) {
        return true;
    }

    public ButtonType[] getTypes() {
        return this.btnType;
    }

    public void setAlgorithm(Algorithm algorithm) {
        AlgoParam param = algorithm.getAlgoParam();
        this.algo.update(param);
        this.algo.setAlgorithm(algorithm);
        if (algorithm.isReadOnly()) {
            this.btnType = new ButtonType[]{new ButtonType("\u5173\u95ed", ButtonBar.ButtonData.OK_DONE)};
        }
    }
}

