/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.viewers.AlgoDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoEnhanceLiquidityDialog
extends AlgoDialog {
    private static final Logger logger = LogManager.getLogger(AlgoEnhanceLiquidityDialog.class);
    @FXML
    private ComboBox<MxNode> cmbBasePrice;
    @FXML
    private ComboBox<MxNode> cmbDepth;
    @FXML
    private Spinner<Double> spnMostPrice;
    @FXML
    private TextField txtRise;
    @FXML
    private TextField txtPercent;
    @FXML
    private TextField txtDelay;
    @FXML
    private Label lbMaxQty;
    @FXML
    private Label lbCanPrice;
    @FXML
    private Label lbPercentErr;
    @FXML
    private Label lbMaxPriceErr;
    @FXML
    private Label lbRiseErr;
    @FXML
    private Label lbBasePriceErr;
    @FXML
    private Label lbDepthErr;
    @FXML
    private Label lbDelayErr;
    @FXML
    private Label labStop;
    @FXML
    private CheckBox cboxRise;
    @FXML
    private Label labUnitMaxBuy;
    @Inject
    private CcsAccountMap accountMap;
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 0);
    public static boolean isBuy = true;

    @Override
    @FXML
    public void initialize() {
        this.initValues();
        if (this.algo.getAlgorithm().isReadOnly()) {
            this.initParam();
            this.gridPane.setDisable(true);
            return;
        }
        super.initialize();
        if (!this.algo.getAlgorithm().isClear()) {
            this.initParam();
        }
        if (this.algo.getAlgorithm().isUpdate()) {
            this.disable(new Node[]{this.cmbFundAcc, this.cmbSecAcc, this.txtCode, this.rdoSell, this.rdoBuy, this.spnQuantity});
        }
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"base_price", (String)"0");
        this.cmbBasePrice.setItems(node.getNodes());
        this.cmbBasePrice.setValue((Object)node);
        this.cmbBasePrice.setDisable(true);
        String depth_type = isBuy ? "depth_sell" : "depth_buy";
        node = MxNodeFactory.create((String)depth_type, (String)"1");
        this.cmbDepth.setItems(node.getNodes());
        this.cmbDepth.setValue((Object)node);
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.rdoBuy.setDisable(true);
        this.rdoSell.setDisable(true);
        this.group.selectToggle((Toggle)(isBuy ? this.rdoBuy : this.rdoSell));
        this.lbQty.setText(isBuy ? "\u4e70\u5165\u6570\u91cf" : "\u5356\u51fa\u6570\u91cf");
        this.lbMaxQty.setText(isBuy ? "\u53ef\u4e70\u6570\u91cf" : "\u53ef\u5356\u6570\u91cf");
        this.lbCanPrice.setText(isBuy ? "\u6700\u9ad8\u4e70\u4ef7" : "\u6700\u4f4e\u5356\u4ef7");
        this.lbMaxPriceErr.setText(isBuy ? "\u8bf7\u8f93\u5165\u6700\u9ad8\u4e70\u4ef7" : "\u8bf7\u8f93\u5165\u6700\u4f4e\u5356\u4ef7");
        this.ctrlPrice.ctrl(this.spnMostPrice);
        this.spnMostPrice.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> TextFieldUtils.selectPriceDecimal((TextField)this.spnMostPrice.getEditor()));
        SpinnerUtils.addIntArrowKeyHandler((Spinner)this.spnQuantity, (int)0, (int)100);
        SpinnerUtils.addDoubleArrowKeyHandler(this.spnMostPrice, (double)0.0, (double)0.01);
        SpinnerUtils.arrowsStyle((Spinner)this.spnQuantity);
        SpinnerUtils.arrowsStyle(this.spnMostPrice);
        this.txtPercent.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtPercent.selectAll());
        this.txtDelay.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtDelay.selectAll());
        String percent = "^(([0-9]|([1-9][0-9])|(100)))?$";
        this.txtPercent.setTextFormatter((TextFormatter)new MxFormatter(percent, 3));
        this.txtDelay.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        this.txtPercent.setText("100");
        this.txtDelay.setText("3");
        this.cboxRise.setText(isBuy ? "\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b" : "\u6700\u4f4e\u4e0b\u6d6e\u6bd4\u4f8b");
        this.lbRiseErr.setText(isBuy ? "\u8bf7\u8f93\u5165\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b" : "\u8bf7\u8f93\u5165\u6700\u4f4e\u4e0b\u6d6e\u6bd4\u4f8b");
        this.txtRise.setDisable(true);
        this.txtRise.setTextFormatter((TextFormatter)new MxFormatter("^((([0-9]|([1-9][0-9])))(\\.(\\d){0,2})?)|(100)$", 5));
        this.cboxRise.selectedProperty().addListener((ob, old, now) -> {
            this.txtRise.setDisable(now == false);
            this.cmbBasePrice.setDisable(now == false);
            this.spnMostPrice.setDisable(now.booleanValue());
            this.optionChange((boolean)now);
        });
    }

    @Override
    protected void checks() {
        super.checks();
        this.registerCheck((Node)this.lbMaxPriceErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.cboxRise.isSelected()) {
                if (!StringUtils.isDouble((String)this.spnMostPrice.getEditor().getText())) {
                    return false;
                }
                if (this.getDouble(this.spnMostPrice) == 0.0) {
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMostPrice.getEditor().textProperty(), this.cboxRise.selectedProperty()}));
        this.registerCheck((Node)this.lbRiseErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.cboxRise.isSelected() || StringUtils.isDouble((String)this.txtRise.getText()), (Observable[])new Observable[]{this.txtRise.textProperty(), this.cboxRise.selectedProperty()}));
        this.registerCheck((Node)this.lbPercentErr, (ObservableBooleanValue)this.txtPercent.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPercentErr, (ObservableBooleanValue)this.txtPercent.textProperty().isNotEqualTo("0"));
        this.registerCheck((Node)this.lbDelayErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            int delay = this.getInt(this.txtDelay);
            if (delay > 0 && delay <= 86400) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtDelay.textProperty()}));
    }

    @Override
    protected void onSecurityChange() {
        super.onSecurityChange();
        this.spnQuantity.getEditor().clear();
        this.spnMostPrice.getEditor().clear();
        this.lbQtyErr.setOpacity(0.0);
        this.lbMaxPriceErr.setOpacity(0.0);
        this.ctrlPrice.setScale(this.getScale());
    }

    public boolean isOK(ButtonType bt) {
        if (this.algo.getAlgorithm().isReadOnly()) {
            return true;
        }
        this.algo.setBuy(this.rdoBuy.isSelected());
        this.algo.setFundAccId(this.accountMap.getFundAcc(this.cmbFundAcc.getEditor().getText()).getExtAccntId());
        this.algo.setSecAccId(this.accountMap.getSecAcc(this.cmbSecAcc.getEditor().getText(), "").getExtSecAccntId());
        this.algo.setCount(Integer.parseInt(this.spnQuantity.getEditor().getText().replaceAll(",", "")));
        if (this.cboxRise.isSelected()) {
            this.algo.setPercentRise(Double.parseDouble(this.txtRise.getText()) / 100.0);
            this.algo.setBasePrice(Integer.parseInt(((MxNode)this.cmbBasePrice.getValue()).getRaw()));
            this.algo.setPriceMost(0.0);
        } else {
            this.algo.setPercentRise(0.0);
            this.algo.setBasePrice(Integer.parseInt(((MxNode)this.cmbBasePrice.getValue()).getRaw()));
            this.algo.setPriceMost(this.getDouble(this.spnMostPrice));
        }
        this.algo.setDepth(Integer.parseInt(((MxNode)this.cmbDepth.getValue()).getRaw()));
        this.algo.setPercentDepth(Double.parseDouble(this.txtPercent.getText()) / 100.0);
        this.algo.setDelay(Integer.parseInt(this.txtDelay.getText()));
        try {
            if (this.algo.getAlgorithm().isUpdate()) {
                this.model.update(this.algo);
            } else {
                this.model.submit(this.algo);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getDesc());
        }
        return true;
    }

    public void optionChange(boolean flag) {
        MxNode node = (MxNode)this.cmbBasePrice.getValue();
        node.clear();
        if (flag) {
            node.removeNode("0");
            node = node.getNode("1");
        } else {
            node.addNode("0");
            node = node.getNode("0");
        }
        this.cmbBasePrice.setValue((Object)node);
    }

    public static void setBuy(boolean deal) {
        isBuy = deal;
    }

    private void initParam() {
        boolean isBuy = this.algo.getAlgorithm().getAlgoParam().isBuy();
        this.lbQty.setText(isBuy ? "\u4e70\u5165\u6570\u91cf" : "\u5356\u51fa\u6570\u91cf");
        this.lbMaxQty.setText(isBuy ? "\u53ef\u4e70\u6570\u91cf" : "\u53ef\u5356\u6570\u91cf");
        this.lbCanPrice.setText(isBuy ? "\u6700\u9ad8\u4e70\u4ef7" : "\u6700\u4f4e\u5356\u4ef7");
        this.cboxRise.setText(isBuy ? "\u6700\u9ad8\u4e0a\u6da8\u6bd4\u4f8b" : "\u6700\u4f4e\u4e0b\u6d6e\u6bd4\u4f8b");
        this.rdoBuy.setSelected(isBuy);
        this.rdoSell.setSelected(!isBuy);
        this.cmbFundAcc.getEditor().setText(this.algo.getFundAccId());
        this.cmbSecAcc.getEditor().setText(this.algo.getSecAccId());
        String type = this.algo.getAlgorithm().getAlgoParam().getType();
        String market = this.algo.getAlgorithm().getAlgoParam().getMarket();
        String code = this.algo.getAlgorithm().getAlgoParam().getCode();
        String name = this.algo.getAlgorithm().getAlgoParam().getName();
        this.txtCode.setText(code);
        this.lbCode.setText(name);
        RefItem item = this.refMng.getItem(type, market, code);
        if (!this.algo.getAlgorithm().isClear()) {
            if (item != null) {
                this.txtCode.setText(code);
                this.lbCode.setText(name);
                this.txtCode.setUserData((Object)item);
                this.onSecurityChange();
            }
        } else {
            this.txtCode.setText(code);
            this.lbCode.setText(name);
            this.lbCanQty.setText("");
        }
        this.spnQuantity.getEditor().setText(String.valueOf(this.algo.getCount()));
        if (this.algo.getAlgorithm().isUpdate()) {
            this.spnQuantity.getEditor().setText(String.valueOf(this.algo.getCount() - this.algo.getAlgorithm().getAlgoParam().getDealCount()));
        }
        MxNode node = ((MxNode)this.cmbBasePrice.getValue()).getNode(String.valueOf(this.algo.getBasePrice()));
        this.cmbBasePrice.getSelectionModel().select((Object)node);
        if (node.getRaw().equals("0")) {
            double price = this.algo.getPriceMost();
            int scale = item == null ? 3 : item.getScale();
            this.spnMostPrice.getEditor().setText(StringUtils.toStr((double)price, (int)scale));
        } else {
            this.cboxRise.setSelected(true);
            this.txtRise.setText(String.valueOf(this.algo.getPercentRise() * 100.0));
        }
        node = ((MxNode)this.cmbDepth.getValue()).getNode(String.valueOf(this.algo.getDepth()));
        this.cmbDepth.getSelectionModel().select((Object)node);
        this.txtPercent.setText(String.format("%.0f", this.algo.getPercentDepth() * 100.0));
        this.txtDelay.setText(String.valueOf(this.algo.getDelay()));
        String unit = QueryUtils.getUnit((String)type, (String)market);
        this.lbUnit.setText(unit);
    }
}

