/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.viewers;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.models.AlgoTradeModel;
import cms.tmx.algorithm.models.CanQtyModel;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlgoDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(AlgoDialog.class);
    protected ButtonType[] btnType = new ButtonType[]{new ButtonType("\u4e0b\u5355", ButtonBar.ButtonData.OK_DONE), ButtonType.CANCEL};
    @FXML
    protected GridPane gridPane;
    @FXML
    protected RadioButton rdoBuy;
    @FXML
    protected RadioButton rdoSell;
    @FXML
    protected ComboBox<String> cmbFundAcc;
    @FXML
    protected ComboBox<String> cmbSecAcc;
    @FXML
    protected TextField txtCode;
    @FXML
    protected Label lbCode;
    @FXML
    protected Label lbQty;
    @FXML
    protected Label lbUnit;
    @FXML
    protected Label lbExpUnit;
    @FXML
    protected Label lbCanQty;
    @FXML
    protected Spinner<Integer> spnQuantity;
    @Inject
    protected AlgoModel algo;
    @Inject
    protected AlgoTradeModel model;
    @Inject
    protected CcsPositionModel posModel;
    @FXML
    protected Label lbCodeErr;
    @FXML
    protected Label lbQtyErr;
    @FXML
    protected Label lbFundErr;
    @FXML
    protected Label lbSecErr;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @FXML
    protected Label lbTips;
    @Inject
    private CcsAccountMap accountMap;
    protected SecSuggest spCode = new SecSuggest();
    protected SecSuggest.StrSuggest spSec = SecSuggest.getStrSuggest();
    protected SecSuggest.StrSuggest spFund = SecSuggest.getStrSuggest();
    protected SecConverter secCvt;
    protected ToggleGroup group = new ToggleGroup();
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected ObservableList<String> listSecAcc = FxUtils.newList();
    protected Map<String, String> mapRecord = new HashMap<String, String>();
    protected CcsPosition ccsPosition = null;
    protected RefItem refItem = null;
    @Inject
    private CanQtyModel canQtyModel;
    private InvalidationListener refListener = ob -> {
        Collection list = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
        this.spCode.setAllSuggestions(list);
    };
    private InvalidationListener mktListener = ob -> this.updateCanQty();

    public ButtonType[] getTypes() {
        return this.btnType;
    }

    @FXML
    public void initialize() {
        this.listeners();
        this.initControls();
        this.checks();
        if (this.algo.getAlgorithm().isUpdate()) {
            this.lbTips.setVisible(true);
        }
    }

    public void onFinished(ButtonType bt) {
        this.algo.close();
        this.refMng.changedProperty().removeListener(this.refListener);
        this.algo.getMI().changedProperty().removeListener(this.mktListener);
    }

    protected void listeners() {
        this.ccsPosition = (CcsPosition)this.of.create(CcsPosition.class);
        this.refMng.changedProperty().addListener(this.refListener);
        this.algo.getMI().changedProperty().addListener(this.mktListener);
    }

    protected void initControls() {
        this.rdoBuy.setToggleGroup(this.group);
        this.rdoSell.setToggleGroup(this.group);
        this.rdoBuy.selectedProperty().bindBidirectional((Property)this.algo.buyProperty());
        this.rdoBuy.setSelected(true);
        this.rdoBuy.selectedProperty().addListener((ob, old, now) -> {
            this.lbQty.setText(now != false ? "\u6700\u5927\u53ef\u4e70" : "\u6700\u5927\u53ef\u5356");
            this.updateCanQty();
        });
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress(this.txtCode, (KeyEvent)event));
        this.txtCode.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCode.selectAll());
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.spFund.addPossibleSuggestions((Collection)this.accountMap.getFundAccList());
        Search.bindAutoCompletion((TextField)this.cmbFundAcc.getEditor(), (Callback)this.spFund);
        this.cmbFundAcc.getItems().addAll((Collection)this.accountMap.getFundAccList());
        this.cmbFundAcc.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbFundAcc.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.cmbFundAcc.getEditor().selectAll());
        this.cmbFundAcc.getEditor().textProperty().addListener((ob, old, now) -> this.secAccFilter());
        this.spSec.addPossibleSuggestions(this.listSecAcc);
        Search.bindAutoCompletion((TextField)this.cmbSecAcc.getEditor(), (Callback)this.spSec);
        this.cmbSecAcc.setItems(this.listSecAcc);
        this.cmbSecAcc.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.cmbSecAcc.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.cmbSecAcc.getEditor().selectAll());
        this.cmbSecAcc.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbSecAcc.getSelectionModel().select(now);
            this.cmbSecAcc.hide();
            if (this.listSecAcc.contains(now)) {
                SecAccount secAcc = this.accountMap.getSecAcc(now, "");
                String raw = secAcc.getExchange().getRaw();
                String fund = this.cmbFundAcc.getEditor().getText();
                this.mapRecord.put(fund, (String)now);
                this.mapRecord.put(String.valueOf(fund) + raw, (String)now);
            }
            this.updateCanQty();
        });
        this.cmbFundAcc.getSelectionModel().select(0);
        this.cmbSecAcc.getSelectionModel().select(0);
        this.ctrlCount.ctrl(this.spnQuantity);
        this.spnQuantity.getEditor().addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.spnQuantity.getEditor().selectAll());
        SpinnerUtils.addIntArrowKeyHandler(this.spnQuantity, (int)0, (int)100);
        SpinnerUtils.arrowsStyle(this.spnQuantity);
        this.canQtyModel.init(this.algo.getMI(), (Property<String>)this.lbCanQty.textProperty(), (Property<String>)this.lbCanQty.textProperty());
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() == 6 && this.algo.getMI().getStop().getValue().booleanValue()) {
            this.lbCode.setText(this.algo.getMI().getStatus());
        }
    }

    protected void checks() {
        this.registerCheck((Node)this.lbFundErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbFundAcc.getEditor().getText().isEmpty()) {
                this.lbFundErr.setText("\u8bf7\u8f93\u5165\u8d44\u91d1\u8d26\u53f7");
                return false;
            }
            if (this.accountMap.getFundAcc(this.cmbFundAcc.getEditor().getText()) == null) {
                this.lbFundErr.setText("\u8d44\u91d1\u8d26\u53f7\u4e0d\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbFundAcc.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbSecErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbSecAcc.getEditor().getText().isEmpty()) {
                this.lbSecErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u8d26\u53f7");
                return false;
            }
            if (!this.listSecAcc.contains((Object)this.cmbSecAcc.getEditor().getText())) {
                this.lbSecErr.setText("\u8bc1\u5238\u8d26\u53f7\u4e0d\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbSecAcc.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.txtCode.isFocused() && this.lbCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            if (this.txtCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            if (this.txtCode.getText().length() == 6 && this.lbCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.textProperty(), this.lbCode.textProperty(), this.txtCode.focusedProperty()}));
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.algo.getAlgorithm().isUpdate()) {
                return true;
            }
            int count = this.getInt(this.spnQuantity.getEditor());
            long canQty = Long.parseLong(this.lbCanQty.getText().replaceAll(",", ""));
            if (count == 0) {
                this.lbQtyErr.setText("\u8bf7\u8f93\u5165\u59d4\u6258\u6570\u91cf");
                return false;
            }
            if ((long)count > canQty) {
                this.lbQtyErr.setText("\u4e0d\u80fd\u8d85\u8fc7\u53ef\u59d4\u6258\u6570\u91cf");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnQuantity.getEditor().textProperty(), this.lbCanQty.textProperty()}));
    }

    protected void onSecurityChange() {
        this.refItem = (RefItem)this.txtCode.getUserData();
        MarketItem mkt = this.algo.getMI();
        mkt.setRefItem(this.refItem);
        this.algo.onSecChange();
        this.secAccFilter();
        String unit = "";
        if (this.refItem != null) {
            String type = this.refItem.getType();
            String market = this.refItem.getMarket();
            unit = QueryUtils.getUnit((String)type, (String)market);
            this.ctrlCount.setUnit(this.refItem.getBuyUnit());
        }
        String name = mkt.getStop().getValue() != false ? mkt.getStatus() : mkt.getRefItem().getName();
        this.lbUnit.setText(unit);
        this.lbExpUnit.setText(unit);
        this.lbCode.setText(name);
        this.updateCanQty();
    }

    protected int getScale() {
        int scale = 0;
        if (this.refItem != null) {
            scale = this.refItem.getScale();
        }
        return scale;
    }

    protected void secAccFilter() {
        String oldAcc;
        String fund = this.cmbFundAcc.getEditor().getText();
        this.cmbFundAcc.getSelectionModel().select((Object)fund);
        CcsFundAccount fundAcc = this.accountMap.getFundAcc(fund);
        if (fundAcc == null) {
            this.listSecAcc.clear();
            this.spSec.clearSuggestions();
            return;
        }
        this.cmbFundAcc.hide();
        ArrayList<String> listTemp = new ArrayList<String>();
        try {
            for (String sec : this.accountMap.getSecAccIdList(fund)) {
                if (this.refItem != null && this.accountMap.getSecAcc(sec, this.refItem.getMarket()) == null) continue;
                listTemp.add(sec);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.listSecAcc.setAll(listTemp);
        this.spSec.clearSuggestions();
        this.spSec.addPossibleSuggestions(this.listSecAcc);
        if (this.refItem != null) {
            fund = String.valueOf(fund) + this.refItem.getMarket();
        }
        if ((oldAcc = this.mapRecord.get(fund)) == null) {
            this.cmbSecAcc.getSelectionModel().select(0);
        } else {
            this.cmbSecAcc.getSelectionModel().select((Object)oldAcc);
        }
    }

    protected void updateCanQty() {
        CcsFundAccount fundAcc = this.accountMap.getFundAcc(this.cmbFundAcc.getEditor().getText());
        SecAccount secAcc = this.accountMap.getSecAcc(this.cmbSecAcc.getEditor().getText(), "");
        this.canQtyModel.updateCanQty(this.rdoBuy.isSelected() ? fundAcc : secAcc);
    }

    public void codeKeyPress(TextField ctrl, KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (ctrl == this.txtCode) {
                this.spnQuantity.requestFocus();
                this.spnQuantity.getEditor().selectAll();
            } else {
                this.spnQuantity.getEditor();
            }
            key.consume();
        }
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : StringUtils.parseInt((String)txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    public void setAlgorithm(Algorithm algorithm) {
        AlgoParam param = algorithm.getAlgoParam();
        this.algo.update(param);
        this.algo.setAlgorithm(algorithm);
        if (algorithm.isReadOnly()) {
            this.btnType = new ButtonType[]{new ButtonType("\u5173\u95ed", ButtonBar.ButtonData.OK_DONE)};
        }
    }

    public void disable(Node ... nodes) {
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            node.setDisable(true);
            ++n2;
        }
    }
}

