/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.models;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.models.AlgoTradeModel;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.portfolio.models.PortfolioTradeModel;
import cms.tmx.query.current.views.portfolio.AlgoQueryPart;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfolioAlgoModel
extends PortfolioTradeModel {
    public BooleanProperty changed = new SimpleBooleanProperty();
    @Inject
    private AlgoModel param;
    @Inject
    private AlgoTradeModel tradeModel;
    @Inject
    private MEventService es;

    @PostConstruct
    public void init() {
        super.init();
    }

    public List<CcsSingleEntrust> getEntrustList() throws MException {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem portItem : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem fundItem : this.getSelectedItems(portItem)) {
                for (TreeItem secItem : this.getNoZeroItems(fundItem)) {
                    Portfolio protfolio = ((PortfolioAccountDistribution)portItem.getValue()).getPortfolio();
                    CcsFundAccount fundAcc = ((PortfolioAccountDistribution)fundItem.getValue()).getAcc();
                    SecAccount secAcc = ((PortfolioAccountDistribution)secItem.getValue()).getSecAcc();
                    String fundAccId = fundAcc.getExtAccntId();
                    String secAccId = secAcc.getExtSecAccntId();
                    CcsSingleEntrust en = this.createEntrust(fundAccId, secAccId);
                    en.setSide(this.param.isBuy() ? 49 : 50);
                    en.setFundAccount((FundAccount)fundAcc);
                    en.setSecAccount(secAcc);
                    en.setInvestorId(fundAcc.getInvestId());
                    en.setInvestorSecId(secAcc.getInverstorSecId());
                    en.setQuantity(((PortfolioAccountDistribution)secItem.getValue()).getCount());
                    en.setSec(this.param.getCode());
                    en.setSecName(this.param.getName());
                    en.setMarket(this.param.getMarket());
                    en.setSecType(this.param.getType());
                    en.setPrice(this.getPrice());
                    en.setCanSell(((PortfolioAccountDistribution)secItem.getValue()).getCanSell());
                    en.setOrderType(50);
                    en.setAppID(this.isReverseRepo() ? "110" : "010");
                    if (!(fundAcc instanceof CcsSubFundAccount) || !(secAcc instanceof CcsSubSecAccount)) {
                        throw new MException(1, "\u8d26\u53f7\u9519\u8bef");
                    }
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAcc);
                    CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAcc);
                    en.setPortfolioId(protfolio.getId());
                    en.setPortfolioName(protfolio.getName());
                    en.setSubAccntId(subFundAcc.getSubAccntId());
                    en.setSubSecAccntId(subSecAcc.getSubSecAccntId());
                    enList.add(en);
                }
            }
        }
        return enList;
    }

    public synchronized String submit() throws MException {
        ObservableList list = FxUtils.newList();
        for (TreeItem portItem : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem fundItem : this.getSelectedItems(portItem)) {
                for (TreeItem secItem : this.getNoZeroItems(fundItem)) {
                    AlgoParam param = new AlgoParam();
                    param.update((Object)this.param);
                    Portfolio protfolio = ((PortfolioAccountDistribution)portItem.getValue()).getPortfolio();
                    CcsFundAccount fundAcc = ((PortfolioAccountDistribution)fundItem.getValue()).getAcc();
                    SecAccount secAcc = ((PortfolioAccountDistribution)secItem.getValue()).getSecAcc();
                    if (fundAcc instanceof CcsSubFundAccount && secAcc instanceof CcsSubSecAccount) {
                        CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAcc);
                        CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAcc);
                        param.setPortfolio(protfolio.getId());
                        param.setPortfolioName(protfolio.getName());
                        param.setFundAccId(fundAcc.getExtAccntId());
                        param.setSecAccId(secAcc.getExtSecAccntId());
                        param.setSubFundId(subFundAcc.getSubAccntId());
                        param.setSubSecId(subSecAcc.getSubSecAccntId());
                        param.setCount((int)((PortfolioAccountDistribution)secItem.getValue()).getCount());
                        list.add((Object)param);
                        continue;
                    }
                    throw new MException(1, "\u8d26\u53f7\u9519\u8bef");
                }
            }
        }
        PortfolioTradeModel.Result result = new PortfolioTradeModel.Result((PortfolioTradeModel)this);
        for (AlgoParam param : list) {
            try {
                this.tradeModel.submit(param);
                ++result.success;
            }
            catch (MException mException) {
                ++result.failed;
            }
        }
        this.changed();
        this.es.sendEvent(AlgoQueryPart.class.getName(), null);
        return result.getDesc();
    }

    public boolean valid() {
        for (TreeItem portItem : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem fundItem : this.getSelectedItems(portItem)) {
                if (this.getNoZeroItems(fundItem).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkOrderQty(boolean isBuy, int quantity) {
        int can = 0;
        for (TreeItem portItem : this.getSelectedItems(this.getAccDisModel().getRoot())) {
            for (TreeItem fundItem : this.getSelectedItems(portItem)) {
                if (isBuy) {
                    can = (int)((long)can + ((PortfolioAccountDistribution)fundItem.getValue()).getCanBuy());
                    continue;
                }
                for (TreeItem secItem : this.getNoZeroItems(fundItem)) {
                    can = (int)((long)can + ((PortfolioAccountDistribution)secItem.getValue()).getCanSell());
                }
            }
        }
        return quantity <= can;
    }

    public void setParam(AlgoParam param) {
        this.param.getMI().setRefItem(this.getMI().getRefItem());
        this.param.update(param);
    }

    public IntegerProperty minuteProperty() {
        return this.param.minuteProperty();
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    public void changed() {
        this.changed.set(!this.changed.get());
    }
}

