/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.models;

import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.query.current.models.CcsPositionModel;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CanQtyModel {
    private LongProperty canBuy = new SimpleLongProperty();
    private LongProperty canSell = new SimpleLongProperty();
    private BooleanProperty changedBuy = new SimpleBooleanProperty();
    private BooleanProperty changedSell = new SimpleBooleanProperty();
    private MarketItem mktItem = null;
    private CcsPosition ccsPosition = null;
    @Inject
    protected MObjFactory of;
    @Inject
    protected CcsPositionModel posModel;
    @Inject
    private ExecutorService exe;
    protected InvalidationListener lstnUpdate = ob -> this.setCanSell(((CcsPosition)CcsPosition.class.cast(ob)).getCanVol());

    @PostConstruct
    private void init() {
        if (this.posModel.getList().isEmpty()) {
            this.exe.execute(() -> this.posModel.initQuery());
        }
    }

    public void init(MarketItem item, Property<String> txtBuy, Property<String> txtSell) {
        this.mktItem = item;
        this.changedBuy.addListener(ob -> txtBuy.setValue((Object)String.valueOf(this.canBuy.get())));
        this.changedSell.addListener(ob -> txtSell.setValue((Object)String.valueOf(this.canSell.get())));
    }

    public void updateCanQty(Object obj) {
        this.resetListener();
        if (this.mktItem.isClear()) {
            this.setCanBuy(0L);
            this.setCanSell(0L);
            return;
        }
        if (obj instanceof CcsFundAccount) {
            this.canQtyFund((CcsFundAccount)CcsFundAccount.class.cast(obj));
        } else if (obj instanceof SecAccount) {
            this.canQtyPosi((SecAccount)SecAccount.class.cast(obj));
        }
    }

    public void canQtyFund(CcsFundAccount fundAcc) {
        if (fundAcc == null) {
            this.setCanBuy(0L);
            return;
        }
        double available = fundAcc.getAvailable();
        double price = this.mktItem.getNowPrice();
        if (price == 0.0) {
            price = this.mktItem.getClosePrice();
        }
        int unit = this.mktItem.getRefItem().getBuyUnit();
        long canQty = (long)(available / price) / (long)unit * (long)unit;
        this.setCanBuy(this.isSHbond() ? canQty / 10L : canQty);
    }

    private void canQtyPosi(SecAccount secAcc) {
        if (secAcc == null) {
            this.setCanSell(0L);
            return;
        }
        this.ccsPosition = this.posModel.getPosition(secAcc, this.mktItem.getRefItem().getCode());
        if (this.ccsPosition == null) {
            this.setCanSell(0L);
            return;
        }
        this.ccsPosition.canVolProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnUpdate));
        this.setCanSell(this.ccsPosition.getCanVol());
    }

    private void resetListener() {
        if (this.ccsPosition != null) {
            this.ccsPosition.canVolProperty().removeListener(this.lstnUpdate);
        }
    }

    private void setCanBuy(long qty) {
        Platform.runLater(() -> {
            this.canBuy.set(qty);
            this.changedBuy.set(!this.changedBuy.get());
        });
    }

    private void setCanSell(long qty) {
        Platform.runLater(() -> {
            this.canSell.set(qty);
            this.changedSell.set(!this.changedSell.get());
        });
    }

    public boolean isSHbond() {
        RefItem refItem = this.mktItem.getRefItem();
        String type = refItem.getType();
        String market = refItem.getMarket();
        return "BOND".equals(type) && "XSHG".equals(market);
    }
}

