/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgoMiseTradeApi;
import cms.tmx.api.trade.IAlgoParam;
import cms.tmx.api.trade.IAlgorithmTradeApi;
import cms.tmx.api.trade.info.MiseBasketInfo;
import cms.tmx.api.trade.info.MiseEf;
import cms.tmx.api.trade.info.MiseExtraFields;
import cms.tmx.api.trade.info.MiseGatewayData;
import cms.tmx.api.trade.info.MiseParam;
import cms.tmx.api.trade.info.MiseRemark;
import cms.tmx.api.trade.info.MiseRequset;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class AlgoTradeModel
extends MxModel {
    @Inject
    private IAlgorithmTradeApi api;
    @Inject
    private IAlgoMiseTradeApi algoApi;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    private IBaseApi iba;
    @Inject
    private CcsAccountMap map;

    @PostConstruct
    public void init() {
    }

    public void cancelOrder(AlgoBaseOrder order) throws MException {
        PAlgorithmTrade.AlgoBaseOrderCancel.Builder builder = PAlgorithmTrade.AlgoBaseOrderCancel.newBuilder();
        builder.setAlgoTypeValue(Integer.parseInt(order.getType().getRaw()));
        builder.setAlgoSysOrderId(order.getId());
        builder.setOpUser(this.iba.getOpUser());
        this.api.cancel(builder.build());
    }

    public void cancelFollowUpOrder(AlgoBaseOrder order) throws MException {
        PStrategy.BaseOrderCancelReq.Builder builder = PStrategy.BaseOrderCancelReq.newBuilder();
        builder.setSysOrderId(order.getId());
        builder.setOpUser(this.iba.getOpUser());
        this.api.cancel(builder.build());
    }

    public String submit(AlgoParam algo) throws MException {
        return this.api.submit((IAlgoParam)algo);
    }

    public String submitMise(AlgoParam algo) throws MException {
        double limitLow;
        double limitUp;
        String investorSecId;
        String investorId;
        String type = "";
        switch (algo.getAlgorithm().getType()) {
            case 15: {
                type = "TWAPBasketTrade";
                break;
            }
            case 16: {
                type = "VWAPBasketTrade";
                break;
            }
            case 19: {
                type = "HighLowLimitTWAP";
                break;
            }
            case 20: {
                type = "HighLowLimitVWAP";
                break;
            }
            case 21: {
                type = "TWAPOV";
                break;
            }
            case 22: {
                type = "ICEBERG";
                break;
            }
            case 23: {
                type = "HighLowLimitTWAPOV";
            }
        }
        String bizAcct = investorId = this.map.getCcsInvestId(algo.getFundAccId());
        CcsFundAccount accnt = this.map.getFundAcc(investorId);
        String currId = this.getCurrency(algo.getMarket());
        boolean isPort = false;
        if (!algo.getPortfolio().isEmpty()) {
            isPort = true;
            bizAcct = algo.getSubFundId();
        }
        String holderAcc = investorSecId = this.map.getCcsInverstorSecId(algo.getSecAccId());
        if (!algo.getSubSecId().isEmpty()) {
            holderAcc = algo.getSubSecId();
        }
        MiseParam para = new MiseParam();
        para.setAlgo_type(type);
        para.setBiz_acct(bizAcct);
        para.setBranch_code("");
        para.setOpUser(this.baseApi.getOpUser());
        para.setProduct_id("");
        para.setBroker_id("");
        para.setCounter_id("1");
        para.setOrder_flag("1");
        para.setGateway_id("0");
        ArrayList<Object[]> basketArr = new ArrayList<Object[]>();
        MiseBasketInfo arr = new MiseBasketInfo();
        arr.setMarketCode(this.getMarketCode(algo.getMarket()));
        arr.setSecCode(algo.getCode());
        arr.setHolderAccNo(holderAcc);
        arr.setCount(Long.valueOf(algo.getCount()));
        arr.setSide(algo.isBuy() ? "01" : "02");
        arr.setSampleVol(Integer.valueOf(1));
        arr.setWeight(Integer.valueOf(0));
        String reserved1 = "";
        double limitPrice = 0.0;
        if ("HighLowLimitTWAP".equals(type) || "HighLowLimitVWAP".equals(type)) {
            limitUp = algo.getPriceUp();
            limitLow = algo.getPriceLow();
            reserved1 = algo.isBuy() ? String.valueOf(limitUp) + "#" : "#" + limitLow;
        } else if ("TWAPOV".equals(type) || "HighLowLimitTWAPOV".equals(type)) {
            MiseEf ef = new MiseEf(Integer.valueOf(algo.getSumMinute()), Double.valueOf(algo.getMarketPercent()), Double.valueOf(algo.getPriceUp()), Double.valueOf(algo.getPriceLow()));
            reserved1 = ef.toString();
        } else if ("ICEBERG".equals(type)) {
            limitUp = algo.getPriceUp();
            limitLow = algo.getPriceLow();
            limitPrice = algo.isBuy() ? limitUp : limitLow;
        }
        arr.setReserved1(reserved1);
        String applId = this.getApplId(algo);
        String reserved2 = String.valueOf(algo.getType()) + "#" + applId;
        if (isPort) {
            reserved2 = String.valueOf(reserved2) + "#" + this.map.getCcsInverstorSecId(algo.getSecAccId());
        }
        arr.setReserved2(reserved2);
        basketArr.add(arr.getBasketInfo());
        MiseExtraFields extraFields = new MiseExtraFields();
        extraFields.setBasket(basketArr);
        MiseRemark remark = new MiseRemark();
        if (algo.getType().equals("REPO")) {
            remark.setSide(Integer.valueOf(algo.isBuy() ? 71 : 70));
        } else {
            remark.setSide(Integer.valueOf(algo.isBuy() ? 49 : 50));
        }
        remark.setType(algo.getType());
        remark.setCode(algo.getCode());
        remark.setMarket(algo.getMarket());
        remark.setName(algo.getName());
        remark.setInvestorId(investorId);
        remark.setInvestorSecId(investorSecId);
        remark.setSumMinute(Integer.valueOf(algo.getSumMinute()));
        remark.setMarketPercent(Double.valueOf(algo.getMarketPercent()));
        if (isPort) {
            remark.setPortfolio_name(algo.getPortfolioName());
        }
        remark.setEvaluation_version("2");
        extraFields.setRemark(remark.toString());
        String resourceId = algo.getResourceId();
        String instructionId = algo.getReference();
        String portfolioId = "";
        if (isPort) {
            portfolioId = algo.getPortfolio();
        }
        PBase.OpUser user = this.baseApi.getOpUser();
        MiseGatewayData gateway = new MiseGatewayData(user, currId, portfolioId, investorId, resourceId, instructionId);
        extraFields.setGateway_data(gateway.toString());
        extraFields.setTrade_platform_id(accnt.getCounterId());
        String startTime = String.valueOf(this.complement(algo.getStartHour())) + this.complement(algo.getStartMinute()) + "00";
        extraFields.setStart_time(startTime);
        String endTime = String.valueOf(this.complement(algo.getEndHour())) + this.complement(algo.getEndMinute()) + "00";
        extraFields.setEnd_time(endTime);
        if (!"ICEBERG".equals(type)) {
            extraFields.setAggressiveLevel(Integer.valueOf(algo.getAggress()));
            extraFields.setNumSlice(Integer.valueOf(algo.getSlice()));
        }
        extraFields.setPrice_type(Integer.valueOf(algo.getPriceType()));
        extraFields.setQty_exposed(Integer.valueOf(algo.getQtyExposed()));
        extraFields.setLimit_price(Double.valueOf(limitPrice));
        para.setExtra_fields(extraFields.toString());
        MiseRequset request = new MiseRequset();
        request.setPARA(para);
        this.algoApi.miseOrder(request);
        return "";
    }

    public String complement(Object obj) {
        String str = obj.toString();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)str)) {
            str = "0" + str;
        }
        return str;
    }

    public void update(AlgoParam algo) throws MException {
        this.api.update((IAlgoParam)algo);
    }

    public String submitFollowUpOrder(List<AlgoParam> algos, int totalNum) throws MException {
        LinkedList<AlgoParam> list = new LinkedList<AlgoParam>();
        list.addAll(algos);
        return this.api.submit(list, totalNum);
    }

    private String getMarketCode(String market) {
        String code = "";
        switch (market) {
            case "XSHG": {
                code = "1";
                break;
            }
            case "XSHE": {
                code = "2";
                break;
            }
            case "SHSC": {
                code = "5";
                break;
            }
            case "SZSC": {
                code = "A";
            }
        }
        return code;
    }

    private String getApplId(AlgoParam algo) {
        String applId = "010";
        if (algo.getMarket().equals("SHSC") || algo.getMarket().equals("SZSC")) {
            applId = "HKN";
        } else if (algo.getType().equals("REPO")) {
            applId = "110";
        } else if (algo.getCode().startsWith("688")) {
            applId = "700";
        }
        return applId;
    }

    private String getCurrency(String market) {
        String currId = "CNY";
        if (market.equals("SHSC") || market.equals("SZSC")) {
            currId = "HKD";
        }
        return currId;
    }
}

