/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.models;

import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoModel
extends AlgoParam {
    private IntegerProperty minute = new SimpleIntegerProperty();
    private boolean ready = false;
    @Inject
    private IMarketDataMng mktMng;
    protected MarketItem mktItem;
    @Inject
    private ScheduledExecutorService ses;
    private Future<?> future;
    private static int amB = 570;
    private static int amE = 689;
    private static int pmB = 780;
    private static int pmE = 899;
    private static int pmERepo = 929;
    private static int pmEHk = 959;

    @PostConstruct
    public void init() {
        this.timer();
        this.mktItem = this.mktMng.createItem(10);
    }

    private void timer() {
        this.future = this.ses.scheduleAtFixedRate(() -> {
            Calendar calender = Calendar.getInstance();
            int now = calender.get(12);
            int old = this.minute.get();
            if (old != now) {
                Platform.runLater(() -> this.minute.set(now));
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public void onSecChange() {
        this.mktMng.dye(this.mktItem);
    }

    public static String complement(Object obj) {
        String str = obj.toString();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)str)) {
            str = "0" + str;
        }
        return str;
    }

    public static void timeLimit(TextField startHour, TextField startMinute, TextField endHour, TextField endMinute, boolean isRepo) {
        Calendar calender = Calendar.getInstance();
        startHour.setText(AlgoModel.complement(calender.get(11)));
        startMinute.setText(AlgoModel.complement(calender.get(12)));
        if (isRepo) {
            endHour.setText("15");
            endMinute.setText("29");
        } else {
            endHour.setText("14");
            endMinute.setText("59");
        }
    }

    public static void timeLimitHk(TextField startHour, TextField startMinute, TextField endHour, TextField endMinute) {
        Calendar calender = Calendar.getInstance();
        startHour.setText(AlgoModel.complement(calender.get(11)));
        startMinute.setText(AlgoModel.complement(calender.get(12)));
        endHour.setText("15");
        endMinute.setText("59");
    }

    public static boolean timeIsValid(int time, boolean isRepo) {
        if (time >= amB && time <= amE) {
            return true;
        }
        return time >= pmB && time <= (isRepo ? pmERepo : pmE);
    }

    public static boolean timeIsValidHk(int time) {
        if (time >= amB && time <= amE) {
            return true;
        }
        return time >= pmB && time <= pmEHk;
    }

    public static int computeSlice(int startHour, int startMinute, int endHour, int endMinute) {
        int minute;
        int hour;
        int slice;
        LocalTime amTime = LocalTime.of(11, 30);
        LocalTime pmTime = LocalTime.of(12, 59);
        LocalTime start = LocalTime.of(startHour, startMinute);
        LocalTime end = LocalTime.of(endHour, endMinute);
        if (start.isBefore(amTime) && end.isAfter(pmTime)) {
            end = end.minusMinutes(90L);
        }
        if ((slice = (hour = end.getHour() - start.getHour()) * 60 + (minute = end.getMinute() - start.getMinute())) < 1) {
            slice = 1;
        }
        return slice;
    }

    public final String getType() {
        return this.mktItem.getRefItem().getType();
    }

    public final String getMarket() {
        return this.mktItem.getRefItem().getMarket();
    }

    public final String getCode() {
        return this.mktItem.getRefItem().getCode();
    }

    public final String getName() {
        return this.mktItem.getRefItem().getName();
    }

    public final IntegerProperty minuteProperty() {
        return this.minute;
    }

    public AlgoModel initMise() {
        this.setExceedPrice(0.0);
        this.setOrderIntevel(60);
        this.setCancelIntevel(60);
        this.setMinitabQty(1);
        this.setWaveRang(5);
        this.setMinQty(100);
        this.setMaxQty(10000);
        this.setOrderTime(10);
        this.notReady();
        return this;
    }

    public void ready() {
        this.ready = true;
    }

    public void notReady() {
        this.ready = false;
    }

    public boolean isReady() {
        return this.ready;
    }
}

