/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.algorithm.models;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoEnhanceLiquidityDialog;
import cms.tmx.algorithm.viewers.AlgoFollowUpDialog;
import cms.tmx.algorithm.viewers.AlgoLimitTwapDialog;
import cms.tmx.algorithm.viewers.AlgoMiseDefaultDialog;
import cms.tmx.algorithm.viewers.AlgoMiseWapDialog;
import cms.tmx.algorithm.viewers.AlgoNodeDialog;
import cms.tmx.algorithm.viewers.AlgoRangeTradeDialog;
import cms.tmx.algorithm.viewers.AlgoTwapDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.Algorithm;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class AlgoFactory {
    private static final Logger logger = LogManager.getLogger(AlgoFactory.class);
    @Inject
    private MEventService es;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;

    public void subscribe() {
        this.es.subscribe("algo.dialog", event -> this.dialog(event));
        this.es.subscribe("update.algo.event", event -> this.updateAlgo(event));
    }

    public boolean dialog(AlgoBaseOrder abo, boolean copy) {
        return this.setupAlgo(abo, copy);
    }

    public void dialog(MEvent event) {
        AlgoBaseOrder abo = (AlgoBaseOrder)event.getObj(AlgoBaseOrder.class);
        this.setupAlgo(abo, false);
    }

    public void updateAlgo(MEvent event) {
        AlgoBaseOrder abo = (AlgoBaseOrder)event.getObj(AlgoBaseOrder.class);
        this.updateAlgo(abo);
    }

    private boolean setupAlgo(AlgoBaseOrder abo, boolean copy) {
        boolean result = false;
        Algorithm algo = abo.getAlgorithm();
        algo.setAlgoParam(abo.getAlgoParam());
        if (copy) {
            algo.setClear(false);
            result = this.launch(algo, abo.isMiseSingleSecuirty());
            algo.setClear(true);
        } else {
            algo.setReadOnly(true);
            result = this.launch(algo, abo.isMiseSingleSecuirty());
            algo.setReadOnly(false);
        }
        return result;
    }

    private boolean updateAlgo(AlgoBaseOrder abo) {
        boolean result = false;
        Algorithm algo = abo.getAlgorithm();
        algo.setAlgoParam(abo.getAlgoParam());
        algo.getAlgoParam().setSysId(abo.getId());
        algo.getAlgoParam().setDealCount(abo.getDealCount());
        algo.setClear(false);
        algo.setUpdate(true);
        this.launch(algo, abo.isMiseSingleSecuirty());
        algo.setClear(true);
        algo.setUpdate(false);
        return result;
    }

    public boolean launch(Algorithm algo, boolean isMiseSingleSecurity) {
        MxDialog dialog = null;
        int type = algo.getType();
        String name = algo.getName();
        switch (type) {
            case 5: 
            case 6: {
                AlgoTwapDialog twap = (AlgoTwapDialog)((Object)this.of.create(AlgoTwapDialog.class));
                twap.setAlgorithm(algo);
                dialog = this.df.create((DialogObj)twap, name);
                break;
            }
            case 7: {
                AlgoRangeTradeDialog range = (AlgoRangeTradeDialog)((Object)this.of.create(AlgoRangeTradeDialog.class));
                range.setAlgorithm(algo);
                dialog = this.df.create((DialogObj)range, name);
                break;
            }
            case 10: 
            case 11: {
                AlgoEnhanceLiquidityDialog.setBuy(algo.getType() == 10);
                AlgoEnhanceLiquidityDialog liquidity = (AlgoEnhanceLiquidityDialog)((Object)this.of.create(AlgoEnhanceLiquidityDialog.class));
                liquidity.setAlgorithm(algo);
                dialog = this.df.create((DialogObj)liquidity, name);
                break;
            }
            case 12: 
            case 13: {
                AlgoLimitTwapDialog limit = (AlgoLimitTwapDialog)((Object)this.of.create(AlgoLimitTwapDialog.class));
                limit.setAlgorithm(algo);
                dialog = this.df.create((DialogObj)limit, name);
                break;
            }
            case 14: {
                AlgoMiseDefaultDialog mise = (AlgoMiseDefaultDialog)((Object)this.of.create(AlgoMiseDefaultDialog.class));
                AlgoModel mo = (AlgoModel)((Object)this.of.create(AlgoModel.class));
                mo.update(algo.getAlgoParam());
                mise.setMise(mo);
                mise.isAllRepo = true;
                dialog = this.df.create((DialogObj)mise, name);
                mise.anchorPane.setDisable(true);
                break;
            }
            case 15: 
            case 16: {
                if (isMiseSingleSecurity) {
                    name = name.replace("\u7bee\u5b50", "MISE_");
                }
                AlgoMiseWapDialog miseWap = (AlgoMiseWapDialog)((Object)this.of.create(AlgoMiseWapDialog.class));
                AlgoModel moWap = (AlgoModel)((Object)this.of.create(AlgoModel.class));
                moWap.update(algo.getAlgoParam());
                miseWap.setMise(moWap);
                miseWap.isAllRepo = true;
                dialog = this.df.create((DialogObj)miseWap, name);
                miseWap.setDisable(true);
                break;
            }
            case 18: {
                AlgoFollowUpDialog follow = (AlgoFollowUpDialog)((Object)this.of.create(AlgoFollowUpDialog.class));
                follow.setAlgorithm(algo);
                dialog = this.df.create((DialogObj)follow, name);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (isMiseSingleSecurity) {
                    name = name.replace("\u7bee\u5b50", "MISE_");
                    AlgoNodeDialog obj = (AlgoNodeDialog)((Object)this.of.create(AlgoNodeDialog.class));
                    dialog = this.df.create((DialogObj)obj, name);
                    obj.init(dialog, algo);
                    break;
                }
                dialog = this.createBasketDialog(algo, name);
            }
        }
        if (dialog == null) {
            logger.error("algo dialog faild:" + algo.getName() + "\uff0c\u76ee\u524d\u4e0d\u652f\u6301");
        } else {
            ButtonType bt = dialog.launch();
            if (bt != null && !algo.isReadOnly()) {
                return bt.getButtonData() == ButtonBar.ButtonData.OK_DONE;
            }
        }
        return false;
    }

    private MxDialog createBasketDialog(Algorithm algo, String name) {
        AlgoMiseWapDialog miseWap = (AlgoMiseWapDialog)((Object)this.of.create(AlgoMiseWapDialog.class));
        AlgoModel moWap = (AlgoModel)((Object)this.of.create(AlgoModel.class));
        moWap.update(algo.getAlgoParam());
        miseWap.setMise(moWap);
        if (algo.getType() == 19 || algo.getType() == 20) {
            int side = algo.getAlgoParam().getSide();
            boolean isBuy = side == 49 || side == 71;
            miseWap.setLimitPriceHint(isBuy);
        }
        miseWap.isAllRepo = true;
        MxDialog dialog = this.df.create((DialogObj)miseWap, name);
        miseWap.setDisable(true);
        return dialog;
    }
}

