/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.file.dbf.entity.DocOrderParamSet;
import cms.tmx.file.dbf.entity.DocScanAndOrderRecord;
import cms.tmx.file.dbf.entity.FileInfo;
import cms.tmx.file.dbf.model.DocOrderParamSetModel;
import cms.tmx.file.dbf.model.DocScanAndOrderRecordModel;
import cms.tmx.file.dbf.utils.FileHander;
import cms.tmx.file.dbf.utils.RegexUtils;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.models.LockModel;
import cms.tmx.notification.MessagePromptTabContent;
import cms.tmx.utils.DateTimeUtils;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

public class MonitorFileOrderPart
extends MxPart {
    @FXML
    private ComboBox<String> cmbRequestDir;
    @FXML
    private Button btnEntrustDir;
    @FXML
    private ComboBox<String> cmbResponseDir;
    @FXML
    private Button btnResDir;
    @FXML
    private RadioButton rdoResSingleFile;
    @FXML
    private RadioButton rdoResMultiFile;
    @FXML
    private CheckBox cboxContentMoney;
    @FXML
    private CheckBox cboxContentPosition;
    @FXML
    private CheckBox cboxContentEntrust;
    @FXML
    private CheckBox cboxContentDeal;
    @FXML
    private Button btnStartOrStop;
    @FXML
    private RadioButton rdoSetTime;
    @FXML
    private RadioButton rdoAutoTime;
    @FXML
    private TextField txtTime;
    @FXML
    private Spinner<Integer> spnSecond;
    @FXML
    private TableView<DocScanAndOrderRecord> tableDoc;
    @FXML
    private TableColumn<DocScanAndOrderRecord, String> fileName;
    @FXML
    private TableColumn<DocScanAndOrderRecord, String> startTime;
    @FXML
    private TableColumn<DocScanAndOrderRecord, String> endTime;
    @FXML
    private Tab tabAlert;
    @FXML
    private Label lbTimeErr;
    private final ToggleGroup resGroup = new ToggleGroup();
    private final ToggleGroup expGroup = new ToggleGroup();
    @Inject
    private DocOrderParamSet param;
    @Inject
    private DocOrderParamSetModel setModel;
    @Inject
    private MxAlert alert;
    @Inject
    private DocScanAndOrderRecordModel docScanAndOrderRecordModel;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    private IBaseApi iba;
    @Inject
    private LockModel lockModel;
    private MProps props = new MProps();
    private boolean isNew = false;
    @Inject
    private MObjFactory of;
    @Inject
    private FileHander fileHander;
    public static final int UNSELECTED = 0;
    public static final int SELECTED = 1;
    public static final int ATUOSELECTED = 2;
    public static final String defTime = "15:00:00";
    public static final String defSecond = "30";
    private IntSpinnerCtrl ctrlSecond = new IntSpinnerCtrl(true, 9, 1);
    private ChangeListener<Boolean> requestDirFocused = (ob, old, now) -> this.onEntrustDirFocused((boolean)now);
    private ChangeListener<String> requestDirChange = (ob, old, now) -> this.onReqDirChange((ObservableValue<? extends String>)ob, (String)old, (String)now);
    private ChangeListener<Boolean> responseDirFocused = (ob, old, now) -> this.onResponseDirFocused((boolean)now);
    private ChangeListener<String> responseDirChange = (ob, old, now) -> this.onResDirChange((ObservableValue<? extends String>)ob, (String)old, (String)now);
    private ChangeListener<String> paramEntruDirListener = (ob, old, now) -> this.onParamEntruDirChange((String)now);
    private ChangeListener<String> paramResDirListener = (ob, old, now) -> this.onParamResDirChange((String)now);
    private ChangeListener<Boolean> paramResponseModelListener = (ob, old, now) -> this.onParamResponseModelChange((Boolean)now);
    private ChangeListener<Boolean> lockListener = (ob, old, now) -> this.isLocked((Boolean)now);

    @FXML
    public void initialize() {
        try {
            this.loadProps();
        }
        catch (IOException e) {
            this.logger.error("\u52a0\u8f7d\u76d1\u542c\u6a21\u5f0f\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        this.initListenner();
        this.initBind();
        this.initControls();
        this.initValue();
        this.createDocTable();
        this.docScanAndOrderRecordModel.setWorkMode("dbf.monitor.work.mode");
        this.eCore.put((Object)"dbf.monitor.response.model", (Object)(this.param.isResponseModel() ? "monofile" : "multifile"));
        MessagePromptTabContent content = (MessagePromptTabContent)this.of.create(MessagePromptTabContent.class);
        this.tabAlert.setContent((Node)content.getContent());
        this.es.subscribe("stop_file_monitor", event -> this.stop());
    }

    @PreDestroy
    public void destroy() {
    }

    public void loadProps() throws IOException {
        Path dataPath = Paths.get(String.valueOf(this.pathBase) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + "_DbfMonitorFile.properties");
        File file = dataPath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            new File(String.valueOf(this.pathBase) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + "_DbfMonitorFile.properties").createNewFile();
            this.isNew = true;
            this.logger.info("props file is not exists, create props file:" + file);
        }
        this.props.load(file);
        this.logger.info("loading props file:" + file);
    }

    private void initBind() {
        this.cmbRequestDir.valueProperty().bindBidirectional((Property)this.param.entrustDirProperty());
        this.cmbResponseDir.valueProperty().bindBidirectional((Property)this.param.responseDirProperty());
        this.rdoResSingleFile.selectedProperty().bindBidirectional((Property)this.param.responseModelProperty());
        this.rdoSetTime.selectedProperty().bindBidirectional((Property)this.param.timeModelProperty());
        this.txtTime.textProperty().bindBidirectional((Property)this.param.timeProperty());
        MxBindings.bindSI((Property)this.spnSecond.getEditor().textProperty(), (Property)this.param.secondProperty());
    }

    private void initControls() {
        this.ctrlSecond.ctrl(this.spnSecond);
        this.txtTime.setText(defTime);
        this.spnSecond.getEditor().setText(defSecond);
        this.txtTime.focusedProperty().addListener((ob, old, newV) -> {
            boolean bl = this.timeLoseFocus((Boolean)newV);
        });
    }

    private boolean timeLoseFocus(Boolean flag) {
        boolean isTime = false;
        if (!flag.booleanValue()) {
            String time = this.txtTime.getText();
            isTime = RegexUtils.isTIME(time);
        }
        return isTime;
    }

    private void initListenner() {
        this.cmbRequestDir.focusedProperty().addListener(this.requestDirFocused);
        this.cmbRequestDir.valueProperty().addListener(this.requestDirChange);
        this.cmbRequestDir.getEditor().textProperty().addListener(this.requestDirChange);
        this.cmbResponseDir.focusedProperty().addListener(this.responseDirFocused);
        this.cmbResponseDir.valueProperty().addListener(this.responseDirChange);
        this.cmbResponseDir.getEditor().textProperty().addListener(this.responseDirChange);
        this.param.responseModelProperty().addListener(this.paramResponseModelListener);
        this.param.entrustDirProperty().addListener(this.paramEntruDirListener);
        this.param.responseDirProperty().addListener(this.paramResDirListener);
        this.lockModel.isLockedProperty().addListener(this.lockListener);
    }

    private void isLocked(Boolean locked) {
        if (locked.booleanValue()) {
            try {
                this.logger.info("\u4ea4\u6613\u9501\u5b9a\uff0c\u6587\u4ef6\u5355\u505c\u6b62...");
                this.stopOrder();
            }
            catch (Exception e) {
                this.logger.error("\u4ea4\u6613\u9501\u5b9a\uff0c\u6587\u4ef6\u5355\u505c\u6b62\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void stop() {
        Platform.runLater(() -> {
            try {
                this.logger.info("\u76d8\u540e\u5173\u95ed\u6587\u4ef6\u5355\u3002\u3002\u3002");
                this.stopOrder();
                MEvent event = new MEvent();
                event.setDesc("\u76d8\u540e\u81ea\u52a8\u5173\u95ed\u6b63\u5728\u8fdb\u884c\u7684\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)");
                this.es.postEvent("message.log", event);
            }
            catch (Exception e) {
                this.logger.error("stopOrder:", (Throwable)e);
            }
        });
    }

    private void onParamResponseModelChange(Boolean now) {
        this.logger.info("switch \u56de\u62a5\u6587\u4ef6\u7684\u6a21\u5f0f to:" + this.param.isResponseModel());
        this.eCore.remove((Object)"dbf.monitor.response.model");
        this.eCore.put((Object)"dbf.monitor.response.model", (Object)(this.param.isResponseModel() ? "monofile" : "multifile"));
    }

    private void onParamResDirChange(String dir) {
        boolean isContains = this.cmbResponseDir.getItems().contains((Object)dir);
        if (!isContains) {
            this.props.setValue("response.saved.dirs", (Object)(String.valueOf(this.props.get("response.saved.dirs")) + dir + "|"));
            this.cmbResponseDir.getItems().add((Object)dir);
        }
        this.props.setValue("response.saved.dir", (Object)dir);
    }

    private void onParamEntruDirChange(String dir) {
        boolean isContains = this.cmbRequestDir.getItems().contains((Object)dir);
        if (!isContains) {
            this.cmbRequestDir.getItems().add((Object)dir);
            this.props.setValue("request.saved.dirs", (Object)(String.valueOf(this.props.get("request.saved.dirs")) + dir + "|"));
        }
        this.props.setValue("request.saved.dir", (Object)dir);
    }

    private void onResDirChange(ObservableValue<? extends String> ob, String old, String folder) {
        boolean isFocused = this.cmbResponseDir.isFocused();
        if (!isFocused && !"".equals(folder.trim())) {
            this.eCore.remove((Object)"dbf.monitor.res.req.folder");
            this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)folder);
            File resFile = new File(folder);
            if (!resFile.exists()) {
                resFile.mkdirs();
            }
        }
    }

    private void onReqDirChange(ObservableValue<? extends String> ob, String old, String folder) {
        boolean isFocused = this.cmbRequestDir.isFocused();
        if (!isFocused && !"".equals(folder.trim())) {
            String scanReqPath = this.eCore.getStr("dbf.scan.req.req.folder");
            String scanRecPath = this.eCore.getStr("dbf.scan.rec.req.folder");
            String scanResPath = this.eCore.getStr("dbf.scan.res.req.folder");
            this.logger.info("\u76d1\u542c\u6a21\u5f0f\u4e0b \u8bf7\u6c42\u6587\u4ef6\u8def\u5f84\u66f4\u6539\uff1a\u8bf7\u6c42\u6587\u4ef6\u8def\u5f84\u2014\u2014folder:" + folder + ", scanReqPath:" + scanReqPath + ", scanRecPath:" + scanRecPath + ", scanResPath:" + scanResPath);
            if (folder.equals(scanReqPath) || folder.equals(scanRecPath) || folder.equals(scanResPath)) {
                this.logger.error("\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u8bf7\u6c42\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u8bbe\u7f6e\u7684\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                });
                this.cmbRequestDir.setValue((Object)old);
                return;
            }
            File reqFile = new File(folder);
            this.eCore.remove((Object)"dbf.monitor.req.req.folder");
            this.eCore.put((Object)"dbf.monitor.req.req.folder", (Object)reqFile.getPath());
            if (!reqFile.exists()) {
                reqFile.mkdirs();
            }
            String parentPath = reqFile.getParent();
            this.onRequestDirChange(parentPath);
            this.createCopyDir(parentPath);
        }
    }

    private void onResponseDirFocused(boolean isFocused) {
        if (isFocused) {
            return;
        }
        String newPath = (String)this.cmbResponseDir.getValue();
        this.eCore.remove((Object)"dbf.monitor.res.req.folder");
        this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)newPath);
    }

    private void onEntrustDirFocused(boolean isFocused) {
        if (isFocused) {
            return;
        }
        String newPath = (String)this.cmbRequestDir.getValue();
        this.eCore.remove((Object)"dbf.monitor.req.req.folder");
        this.eCore.put((Object)"dbf.monitor.req.req.folder", (Object)newPath);
        File file = new File(newPath);
        if (file.isDirectory()) {
            this.onRequestDirChange(file.getParent());
            this.createCopyDir(file.getParent());
        }
    }

    private void createCopyDir(String newPath) {
        if (newPath == null || "".equals(newPath)) {
            return;
        }
        File recFile = new File(String.valueOf(newPath) + "\\record");
        if (!recFile.exists()) {
            recFile.mkdir();
        }
        this.logger.info("\u626b\u5355 \u65b0\u7684\u5de5\u4f5c\u6587\u4ef6\u8def\u5f84\u2014\u2014" + recFile.getPath());
        this.eCore.remove((Object)"dbf.monitor.rec.req.folder");
        this.eCore.put((Object)"dbf.monitor.rec.req.folder", (Object)recFile.getPath());
    }

    private void initValue() {
        this.rdoResSingleFile.setToggleGroup(this.resGroup);
        this.rdoResMultiFile.setToggleGroup(this.resGroup);
        this.rdoSetTime.setToggleGroup(this.expGroup);
        this.rdoAutoTime.setToggleGroup(this.expGroup);
        this.rdoSetTime.setSelected(true);
        this.txtTime.setText(defTime);
        if (this.isNew) {
            String requestPath = String.valueOf(this.pathBase) + File.separator + "users" + File.separator + this.eCore.getStr("user_id") + File.separator + this.iba.getPostId() + "\\dbfOrder\\monitor\\request";
            String responsePath = String.valueOf(this.pathBase) + File.separator + "users" + File.separator + this.eCore.getStr("user_id") + File.separator + this.iba.getPostId() + "\\dbfOrder\\monitor\\response";
            String recordPath = String.valueOf(this.pathBase) + File.separator + "users" + File.separator + this.eCore.getStr("user_id") + File.separator + this.iba.getPostId() + "\\dbfOrder\\monitor\\record";
            this.eCore.put((Object)"dbf.monitor.req.req.folder", (Object)requestPath);
            this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)responsePath);
            this.eCore.put((Object)"dbf.monitor.rec.req.folder", (Object)recordPath);
            this.logger.info("\u7b2c\u4e00\u6b21\u6253\u5f00\u5f53\u524dpart monitorpart");
            this.cmbRequestDir.getItems().add((Object)requestPath);
            this.cmbResponseDir.getItems().add((Object)responsePath);
            this.cmbResponseDir.setValue((Object)responsePath);
            this.cmbRequestDir.setValue((Object)requestPath);
            this.createDefaultDir(requestPath, responsePath, recordPath);
        } else {
            this.readSetConf();
        }
    }

    private void readSetConf() {
        ObservableList resDirList = FxUtils.newList();
        resDirList.addAll((Collection)this.props.getValues("response.saved.dirs"));
        String resSavedDir = this.props.get("response.saved.dir");
        this.cmbResponseDir.setItems(resDirList);
        this.cmbResponseDir.getSelectionModel().select((Object)resSavedDir);
        ObservableList reqDirList = FxUtils.newList();
        reqDirList.addAll((Collection)this.props.getValues("request.saved.dirs"));
        String reqSavedDir = this.props.get("request.saved.dir");
        this.cmbRequestDir.setItems(reqDirList);
        this.cmbRequestDir.getSelectionModel().select((Object)reqSavedDir);
        this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)reqSavedDir);
        this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)resSavedDir);
        File reqFile = new File(reqSavedDir);
        this.createCopyDir(reqFile.getParent());
    }

    private void createDefaultDir(String requestPath, String responsePath, String recordPath) {
        File reqFile = new File(requestPath);
        File resFile = new File(responsePath);
        File recFile = new File(recordPath);
        if (!reqFile.exists()) {
            reqFile.mkdirs();
        }
        if (!resFile.exists()) {
            resFile.mkdirs();
        }
        if (!recFile.exists()) {
            recFile.mkdirs();
        }
    }

    private void onRequestDirChange(String newPath) {
        if (newPath == null || "".equals(newPath)) {
            return;
        }
        String resDir = (String)this.cmbResponseDir.getValue();
        if (resDir == null || "".equals(resDir)) {
            File resFile = new File(String.valueOf(newPath) + "\\response");
            if (!resFile.exists()) {
                resFile.mkdir();
            }
            this.logger.info("\u626b\u5355 \u4fdd\u5b58\u65b0\u7684\u56de\u62a5\u76ee\u5f55" + newPath);
            this.cmbResponseDir.getItems().add((Object)resFile.getPath());
            this.cmbResponseDir.setValue((Object)resFile.getPath());
            this.eCore.remove((Object)"dbf.monitor.res.req.folder");
            this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)resFile.getPath());
        }
    }

    @FXML
    public void onEntrustDirChange() {
        File file;
        DirectoryChooser dirChooser = new DirectoryChooser();
        if (!((String)this.cmbRequestDir.getSelectionModel().getSelectedItem()).isEmpty() && (file = new File((String)this.cmbRequestDir.getSelectionModel().getSelectedItem())).exists()) {
            dirChooser.setInitialDirectory(file);
        }
        if ((file = dirChooser.showDialog((Window)this.stage)) == null) {
            return;
        }
        String path = file.getPath();
        String parentPath = file.getParent();
        if (!this.cmbRequestDir.getItems().contains((Object)path)) {
            this.cmbRequestDir.getItems().add((Object)path);
        }
        this.cmbRequestDir.getSelectionModel().select((Object)path);
        this.onRequestDirChange(parentPath);
        this.createCopyDir(parentPath);
    }

    @FXML
    public void onResDirChange() {
        File file;
        DirectoryChooser dirChooser = new DirectoryChooser();
        if (!((String)this.cmbResponseDir.getSelectionModel().getSelectedItem()).isEmpty() && (file = new File((String)this.cmbResponseDir.getSelectionModel().getSelectedItem())).exists()) {
            dirChooser.setInitialDirectory(file);
        }
        if ((file = dirChooser.showDialog((Window)this.stage)) == null) {
            return;
        }
        String path = file.getPath();
        this.logger.error("\u76d1\u542c \u8bbe\u7f6e\u56de\u62a5\u76ee\u5f55\u4e3a[" + path + "]");
        if (!this.cmbResponseDir.getItems().contains((Object)path)) {
            this.cmbResponseDir.getItems().add((Object)path);
        }
        this.cmbResponseDir.getSelectionModel().select((Object)path);
        this.eCore.remove((Object)"dbf.monitor.res.req.folder");
        this.eCore.put((Object)"dbf.monitor.res.req.folder", (Object)path);
    }

    @FXML
    public void startOrStop() {
        boolean isStarted = this.param.isStarted();
        if (isStarted) {
            try {
                this.logger.info("\u6587\u4ef6\u5355 \u4e3b\u52a8\u505c\u6b62\u3002\u3002\u3002");
                this.stopOrder();
            }
            catch (Exception e) {
                this.logger.error("\u505c\u6b62\u5931\u8d25\uff1a", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u505c\u6b62\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else {
            try {
                this.startOrder();
            }
            catch (Exception e) {
                this.logger.error("\u542f\u52a8\u5931\u8d25\uff1a", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void startOrder() throws Exception {
        this.logger.info("\u754c\u9762 \u542f\u52a8\u6587\u4ef6\u5355");
        if (this.param.isTimeModel() && !this.timeLoseFocus(false)) {
            this.lbTimeErr.setOpacity(1.0);
            return;
        }
        this.lbTimeErr.setOpacity(0.0);
        this.theFileExists();
        FileHander.getHasSub().set(true);
        this.lockInDoc(true);
        this.setModel.start(this.param);
        this.setSubscribe(true);
        MEvent event = new MEvent();
        event.put((Object)"export_type", (Object)(this.param.isTimeModel() ? 1 : 2));
        event.put((Object)"set_time", (Object)this.param.getTime());
        event.put((Object)"auto_interval", (Object)this.param.getSecond());
        this.es.sendEvent("dbf.begin", event);
        this.param.setStarted(true);
        this.btnStartOrStop.setText("\u505c\u6b62");
        this.logger.info("\u6587\u4ef6\u5355\u5df2\u5f00\u59cb");
    }

    private void setSubscribe(boolean status) {
        this.logger.info("\u76d1\u542c\uff0c \u542f\u52a8\u7528\u6237\u8ba2\u9605, status:" + status);
    }

    private void lockInDoc(boolean isLock) {
        this.btnEntrustDir.setDisable(isLock);
        this.btnResDir.setDisable(isLock);
        this.rdoResSingleFile.setDisable(isLock);
        this.cmbRequestDir.setDisable(isLock);
        this.cmbResponseDir.setDisable(isLock);
        this.rdoSetTime.setDisable(isLock);
        this.rdoAutoTime.setDisable(isLock);
        this.spnSecond.setDisable(isLock);
        this.txtTime.setDisable(isLock);
    }

    private void stopOrder() throws Exception {
        this.logger.info("\u754c\u9762 \u5173\u95ed\u6587\u4ef6\u5355");
        this.param.setStarted(false);
        this.btnStartOrStop.setText("\u5f00\u59cb");
        MEvent event = new MEvent();
        event.put((Object)"export_type", (Object)0);
        this.es.sendEvent("dbf.begin", event);
        this.lockInDoc(false);
        this.setSubscribe(false);
        this.setModel.stop();
        this.logger.info("\u6587\u4ef6\u5355\u5df2\u505c\u6b62");
    }

    private void theFileExists() {
        String entrustDir = this.param.getEntrustDir();
        String resDir = this.param.getResponseDir();
        String recReqFolder = this.eCore.getStr("dbf.monitor.rec.req.folder");
        File entrustFile = new File(entrustDir);
        File resFile = new File(resDir);
        boolean isExistsEntru = entrustFile.exists();
        boolean isExistsRes = resFile.exists();
        if (!isExistsEntru) {
            this.logger.error("\u8bf7\u6c42\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            entrustFile.mkdirs();
        }
        if (!isExistsRes) {
            this.logger.error("\u56de\u62a5\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            resFile.mkdirs();
        }
        File dstFile = new File(String.valueOf(recReqFolder) + File.separator + "order" + DateTimeUtils.getTimeStampFileName() + ".dbf");
        File reqFile = new File(entrustFile.getAbsolutePath(), "order.dbf");
        if (this.fileHander.isFirstStart() && reqFile.exists()) {
            try {
                Files.move(reqFile.toPath(), dstFile.toPath(), StandardCopyOption.REPLACE_EXISTING).toString();
            }
            catch (Exception e) {
                String msg = "\u5907\u4efd" + reqFile + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u88ab\u5360\u7528";
                this.logger.error(msg, (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, String.valueOf(msg) + e);
                return;
            }
        }
        this.fileHander.setFirstStart(false);
        this.createFile(entrustFile.getAbsolutePath(), "order.dbf");
        this.createFile(resFile.getAbsolutePath(), "orderstatus.dbf");
        this.createFile(resFile.getAbsolutePath(), "deal.dbf");
    }

    private void createFile(String resFolder, String fileName) {
        File file = new File(resFolder, fileName);
        List<FileInfo.FiledInfo> filedInfos = FileInfo.getFileds(fileName);
        if (!file.exists() && filedInfos != null) {
            DBFField[] fields = new DBFField[filedInfos.size()];
            int i = 0;
            while (i < filedInfos.size()) {
                fields[i] = new DBFField();
                fields[i].setName(filedInfos.get(i).getFiledName());
                fields[i].setType(filedInfos.get(i).getFiledType());
                fields[i].setLength(filedInfos.get(i).getFiledLength());
                ++i;
            }
            DBFWriter writer = new DBFWriter(file);
            writer.setCharactersetName("GB2312");
            writer.setFields(fields);
            writer.close();
        }
    }

    private void createDocTable() {
        TableUtils.initValueFactory(this.tableDoc);
        this.tableDoc.setPlaceholder((Node)new Label());
        this.tableDoc.setItems(this.docScanAndOrderRecordModel.getList());
        this.startTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableDoc.getSortOrder().add(this.startTime);
    }
}

