/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils3;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static final String EMAIL = "\\w+(\\.\\w+)*@\\w+(\\.\\w+)+$";
    public static final String PHONE = "(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)";
    public static final String MOBILE = "^(13[0-9]|14[0-9]|15[0-9]|17[0-9]|18[0-9])\\d{8}$";
    public static final String INTEGER = "^-?(([1-9]\\d*$)|0)";
    public static final String INTEGER_POSITIVE = "^[1-9]\\d*|0$";
    public static final String PWD = "^[a-zA-Z0-9_]{0,32}$";
    public static final String BS_FLAG = "^[a-zA-Z0-9@#!]{2}$";
    public static final String INTEGER_NEGATIVE = "^-[1-9]\\d*|0$";
    public static final String DOUBLE = "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$";
    public static final String DOUBLE_POSITIVE = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|[0-9]\\d*|0$";
    public static final String PRICE = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|[0-9]\\d*|0{1,20}$";
    public static final String AMT = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|[0-9]\\d*|0{1,20}$";
    public static final String OPERATE_TYPE = "[0-9]{2}$";
    public static final String REMARK = "^\\w{0,255}$";
    public static final String DOUBLE_NEGATIVE = "^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$";
    public static final String AGE = "^(?:[1-9][0-9]?|1[01][0-9]|120)$";
    public static final String CODE = "[0-9]\\d{5}(?!\\d)$";
    public static final String STR_ENG_NUM_ = "^\\w+$";
    public static final String STR_ENG_NUM = "^[A-Za-z0-9]{1,16}$";
    public static final String STR_ENG_NUM_20 = "^[A-Za-z0-9]{0,20}$";
    public static final String STR_ENG = "^[A-Za-z]+$";
    public static final String STR_SPECIAL = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
    public static final String DATE_ALL = "((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(10|12|0?[13578])([-\\/\\._]?)(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(11|0?[469])([-\\/\\._]?)(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(0?2)([-\\/\\._]?)(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([3579][26]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$))";
    public static final String DATE_FORMAT1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";
    public static final String URL = "^(http|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$";
    public static final String IDCARD = "((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65)[0-9]{4})(([1|2][0-9]{3}[0|1][0-9][0-3][0-9][0-9]{3}[Xx0-9])|([0-9]{2}[0|1][0-9][0-3][0-9][0-9]{3}))";
    public static final String JIGOU_CODE = "^[A-Z0-9]{8}-[A-Z0-9]$";
    public static final String STR_NUM = "^[0-9]+$";
    public static final String FUND_ACCOUNT = "^[0-9]+$";
    public static final String DATASOURCE = "^[0]{1}$";
    public static final String FUND_MARKET = "^[1|2]{1,1}$";
    public static final String ENTRUST_BS = "^[a-zA-Z@#!0-9]{1,2}$";
    public static final String PORTFOLIO_ID = "^[P][0-9]{7}$";
    public static final String TANSFER_TYPE = "^[1|2]{1,1}$";
    public static final String STOCK_CODE = "^[0-9]\\d{5}$";
    public static final String MARKET_INDICATOR = "^[1-9]\\d{0,1}$";
    public static final String ENTRUST_METHOD = "^[a-zA-Z0-9]{1,2}$";
    public static final String STOCK_TYPE = "^[A-Z0-9@]{2}$";
    public static final String QUERY_FLAG = "^\\w{0,32}$";
    public static final String QUERY_INDEX = "^\\w{0,32}$";
    public static final String SEAT_NO = "^\\d{5,6}$";
    public static final String STOCKHOLDER_CODE = "^[a-zA-Z0-9]{1,}[0-9]{9,10}$";
    public static final String CONTRACT_NO = "^[a-zA-Z0-9]{6,16}$";
    public static final String CLIENT_SEQ = "[^\\|]{1,30}$";
    public static final String CLIENT_LIST_SEQ = "[^\\|]{1,70}$";
    public static final String BZ = "^[0]{1,1}[1|2]{1,1}$";

    public static synchronized boolean StrisNull(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean StrNotNull(String str) {
        return !RegexUtils.StrisNull(str);
    }

    public static String nulltoStr(String str) {
        return RegexUtils.StrisNull(str) ? "" : str;
    }

    public static String nulltoStr(String str, String defaut) {
        return RegexUtils.StrisNull(str) ? defaut : str;
    }

    public static boolean isEmail(String str) {
        return RegexUtils.Regular(str, EMAIL);
    }

    public static boolean isPhone(String str) {
        return RegexUtils.Regular(str, PHONE);
    }

    public static boolean isMobile(String str) {
        return RegexUtils.Regular(str, MOBILE);
    }

    public static boolean isUrl(String str) {
        return RegexUtils.Regular(str, URL);
    }

    public static boolean isNumber(String str) {
        return RegexUtils.Regular(str, DOUBLE);
    }

    public static boolean isInteger(String str) {
        return RegexUtils.Regular(str, INTEGER);
    }

    public static boolean isINTEGER_POSITIVE(String str) {
        return RegexUtils.Regular(str, INTEGER_POSITIVE);
    }

    public static boolean isPWD(String str) {
        return RegexUtils.Regular(str, PWD);
    }

    public static boolean isBS_FLAG(String str) {
        return RegexUtils.Regular(str, BS_FLAG);
    }

    public static boolean isINTEGER_NEGATIVE(String str) {
        return RegexUtils.Regular(str, INTEGER_NEGATIVE);
    }

    public static boolean isDouble(String str) {
        return RegexUtils.Regular(str, DOUBLE);
    }

    public static boolean isDOUBLE_POSITIVE(String str) {
        return RegexUtils.Regular(str, DOUBLE_POSITIVE);
    }

    public static boolean isPRICE(String str) {
        return RegexUtils.Regular(str, "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|[0-9]\\d*|0{1,20}$");
    }

    public static boolean isAMT(String str) {
        return RegexUtils.Regular(str, "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|[0-9]\\d*|0{1,20}$");
    }

    public static boolean isOPERATE_TYPE(String str) {
        return RegexUtils.Regular(str, OPERATE_TYPE);
    }

    public static boolean isREMARK(String str) {
        return RegexUtils.Regular(str, REMARK);
    }

    public static boolean isDOUBLE_NEGATIVE(String str) {
        return RegexUtils.Regular(str, DOUBLE_NEGATIVE);
    }

    public static boolean isDate(String str) {
        return RegexUtils.Regular(str, DATE_ALL);
    }

    public static boolean isDate1(String str) {
        return RegexUtils.Regular(str, DATE_FORMAT1);
    }

    public static boolean isAge(String str) {
        return RegexUtils.Regular(str, AGE);
    }

    public static boolean isLengOut(String str, int leng) {
        return RegexUtils.StrisNull(str) ? false : str.trim().length() > leng;
    }

    public static boolean isIdCard(String str) {
        if (RegexUtils.StrisNull(str)) {
            return false;
        }
        if (str.trim().length() == 15 || str.trim().length() == 18) {
            return RegexUtils.Regular(str, IDCARD);
        }
        return false;
    }

    public static boolean isCode(String str) {
        return RegexUtils.Regular(str, CODE);
    }

    public static boolean isEnglish(String str) {
        return RegexUtils.Regular(str, STR_ENG);
    }

    public static boolean isENG_NUM(String str) {
        return RegexUtils.Regular(str, STR_ENG_NUM);
    }

    public static boolean isENG_NUM_20(String str) {
        return RegexUtils.Regular(str, STR_ENG_NUM_20);
    }

    public static boolean isENG_NUM_(String str) {
        return RegexUtils.Regular(str, STR_ENG_NUM_);
    }

    public static String filterStr(String str) {
        Pattern p = Pattern.compile(STR_SPECIAL);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isJigouCode(String str) {
        return RegexUtils.Regular(str, JIGOU_CODE);
    }

    public static boolean isSTR_NUM(String str) {
        return RegexUtils.Regular(str, "^[0-9]+$");
    }

    public static boolean isFUND_ACCOUNT(String str) {
        return RegexUtils.Regular(str, "^[0-9]+$");
    }

    public static boolean isDATASOURCE(String str) {
        return RegexUtils.Regular(str, DATASOURCE);
    }

    public static boolean isFUND_MARKET(String str) {
        return RegexUtils.Regular(str, "^[1|2]{1,1}$");
    }

    public static boolean isSTOCK_CODE(String str) {
        return RegexUtils.Regular(str, STOCK_CODE);
    }

    public static boolean isENTRUST_METHOD(String str) {
        return RegexUtils.Regular(str, ENTRUST_METHOD);
    }

    public static boolean isSTOCK_TYPE(String str) {
        return RegexUtils.Regular(str, STOCK_TYPE);
    }

    public static boolean isMARKET_INDICATOR(String str) {
        return RegexUtils.Regular(str, MARKET_INDICATOR);
    }

    public static boolean isQUERY_FLAG(String str) {
        return RegexUtils.Regular(str, "^\\w{0,32}$");
    }

    public static boolean isQUERY_INDEX(String str) {
        return RegexUtils.Regular(str, "^\\w{0,32}$");
    }

    public static boolean isSEAT_NO(String str) {
        return RegexUtils.Regular(str, SEAT_NO);
    }

    public static boolean isSTOCKHOLDER_CODE(String str) {
        return RegexUtils.Regular(str, STOCKHOLDER_CODE);
    }

    public static boolean isCONTRACT_NO(String str) {
        return RegexUtils.Regular(str, CONTRACT_NO);
    }

    public static boolean isCLIENT_SEQ(String str) {
        return RegexUtils.Regular(str, CLIENT_SEQ);
    }

    public static boolean isCLIENT_LIST_SEQ(String str) {
        return RegexUtils.Regular(str, CLIENT_LIST_SEQ);
    }

    public static boolean isPORTFOLIO_ID(String str) {
        return RegexUtils.Regular(str, PORTFOLIO_ID);
    }

    public static boolean isTANSFER_TYPE(String str) {
        return RegexUtils.Regular(str, "^[1|2]{1,1}$");
    }

    public static boolean isBZ(String str) {
        return RegexUtils.Regular(str, BZ);
    }

    public static boolean isENTRUST_BS(String str) {
        return RegexUtils.Regular(str, ENTRUST_BS);
    }

    public static boolean Regular(String str, String pattern) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static void main(String[] args) {
        System.out.println(RegexUtils.isPORTFOLIO_ID("P1123231"));
        System.out.println(RegexUtils.isCLIENT_SEQ("----()@#$%680715012"));
        System.out.println(RegexUtils.isFUND_ACCOUNT(""));
    }
}

