/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils3;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbfJdbc {
    private static final String LINE = "\r\n";
    private static final String TAB = "\t";
    private static String url;
    private static String driveName;
    private static String username;
    private static String password;
    private static final boolean printSql = true;

    static {
        Properties p = new Properties();
        try {
            InputStream in = DbfJdbc.class.getResourceAsStream("/jdbc.properties");
            p.load(in);
            in.close();
            driveName = p.getProperty("jdbc.driverClassName");
            url = "";
            username = "";
            password = "";
        }
        catch (IOException ex) {
            Logger.getLogger(DbfJdbc.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("\u53c2\u6570\u4f20\u5165\u9519\u8bef.......");
                return;
            }
            String value = args[0];
            String[] values = value.split(";");
            String tableName = values[0].substring(values[1].indexOf("=") + 1);
            String filte = values[1].substring(values[1].indexOf("=") + 1).replace("\\", "");
            String path = values[2].substring(values[1].indexOf("="));
            System.out.println("\u5f00\u59cb\u542f\u52a8\u8fde\u63a5.......");
            Connection conn = DbfJdbc.getConnection();
            System.out.println("\u6570\u636e\u8fde\u63a5\u6210\u529f.......");
            Map map = DbfJdbc.getData(conn, tableName, filte);
            System.out.println("\u5f00\u59cb\u5bfc\u51fa\u6570\u636e.......");
            ArrayList<Map> fieldList = new ArrayList();
            ArrayList<Map> dataList = new ArrayList();
            fieldList = (List)map.get("fieldList");
            dataList = (List)map.get("dataList");
            DbfJdbc.writeDBF(fieldList, dataList, path);
            System.out.println("\u5bfc\u51fa\u5b8c\u6210!\u6587\u4ef6\u8def\u5f84\uff1a" + path);
        }
        catch (Exception e) {
            System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25......\r\n" + e.getMessage());
        }
    }

    public static Connection getConnection() throws ClassNotFoundException, SQLException, InstantiationException, IllegalAccessException {
        try {
            Class.forName(driveName).newInstance();
            Properties sysProps = System.getProperties();
            sysProps.put("user", username);
            sysProps.put("password", password);
            sysProps.put("charset", "cp936");
            return DriverManager.getConnection(url, sysProps);
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
    }

    private static void writeDBF(List<Map> fieldList, List<Map> dataList, String path) {
        block16: {
            OutputStream fos = null;
            try {
                try {
                    DBFField[] fields = new DBFField[fieldList.size()];
                    int row = 0;
                    for (Map map : fieldList) {
                        String name = map.get("name").toString();
                        if (name.length() >= 10) {
                            name = name.substring(0, 9);
                        }
                        int length = Integer.parseInt(map.get("length").toString());
                        fields[row] = new DBFField();
                        fields[row].setName(name);
                        fields[row].setDataType((byte)67);
                        fields[row].setFieldLength(length);
                        ++row;
                    }
                    DBFWriter writer = new DBFWriter();
                    writer.setFields(fields);
                    row = 0;
                    int size = dataList.size();
                    int nowRow = 0;
                    for (Map map : dataList) {
                        Object[] rowData = new Object[fieldList.size()];
                        for (Map fMap : fieldList) {
                            Object key = fMap.get("name");
                            rowData[row] = map.get(key) == null ? null : map.get(key).toString();
                            ++row;
                        }
                        row = 0;
                        if (++nowRow % 10 == 0) {
                            System.out.println("\u5f53\u524d\u8fdb\u5ea6 : " + nowRow + "/" + size);
                        }
                        writer.addRecord(rowData);
                    }
                    File file = new File(path);
                    fos = new FileOutputStream(file);
                    writer.write(fos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Map getData(Connection connection, String tableName, String filter) throws SQLException {
        String sql = "select * from " + tableName + " where 1 = 1";
        if (filter != null && !"".equals(filter)) {
            sql = String.valueOf(sql) + filter;
        }
        System.out.println("sql : " + sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        ps = connection.prepareStatement(sql);
        rs = ps.executeQuery();
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList fieldList = new ArrayList();
        int i = 1;
        while (i <= columnCount) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", md.getColumnName(i));
            map.put("length", md.getColumnDisplaySize(i));
            map.put("type", (byte)md.getColumnType(i));
            fieldList.add(i - 1, map);
            ++i;
        }
        ArrayList dataList = new ArrayList();
        while (rs.next()) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            for (Map map : fieldList) {
                String name = map.get("name").toString();
                dataMap.put(name, rs.getObject(name));
            }
            dataList.add(dataMap);
        }
        HashMap retMap = new HashMap();
        retMap.put("fieldList", fieldList);
        retMap.put("dataList", dataList);
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (connection != null) {
            connection.close();
        }
        return retMap;
    }
}

