/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils3;

import cms.tmx.file.dbf.utils3.CacheManager;
import com.linuxense.javadbf.DBFWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DBFReader {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/DD");
    private static final byte HEAD_LOC = 0;
    private static final byte VERSION_LOC = 0;
    private static final byte VERSION_LEN = 1;
    private static final byte UPDATE_LOC = 1;
    private static final byte UPDATE_LEN = 3;
    private static final byte COUNT_LOC = 4;
    private static final byte COUNT_LEN = 4;
    private static final byte DATAIDX_LOC = 8;
    private static final byte DATAIDX_LEN = 2;
    private static final byte LENGTH_LOC = 10;
    private static final byte LENGTH_LEN = 2;
    private static final byte RESERVED1_LOC = 12;
    private static final byte RESERVED1_LEN = 16;
    private static final byte TABLETAG_LOC = 28;
    private static final byte TABLETAG_LEN = 1;
    private static final byte PAGETAG_LOC = 29;
    private static final byte PAGETAG_LEN = 1;
    private static final byte RESERVED2_LOC = 30;
    private static final byte RESERVED2_LEN = 2;
    private static final byte HEAD_LEN = 32;
    private static final byte FIELD_LOC = 32;
    private final File file;
    private final RandomAccessFile dbf;
    private final FileChannel fc;
    private final Charset charset;
    private int version;
    private byte[] update;
    private int count;
    private int dataidx;
    private int length;
    private int tabletag;
    private int pagetag;
    private Field[] fields;

    public static void main(String[] args) {
        int recordLength = 0;
        try {
            try {
                long tsBegin = System.currentTimeMillis();
                DBFReader dbfreader_SH = new DBFReader(new File("D://dbf//req.dbf"));
                List<Record> list_sh = dbfreader_SH.loadRecords();
                for (Record reader : list_sh) {
                    System.out.println("-------");
                    System.out.println(reader.getString(0));
                    System.out.println(reader.getString(1));
                    System.out.println(reader.getString(2));
                    System.out.println(reader.getString(3));
                    System.out.println(reader.getString(4));
                    System.out.println(reader.getString(5));
                    System.out.println(reader.getString(6));
                    System.out.println(reader.getString(7));
                    System.out.println(reader.getString(8));
                    System.out.println(reader.getString(9));
                    System.out.println(reader.getString(10));
                }
                long tsEnd = System.currentTimeMillis();
                recordLength = dbfreader_SH.getRecordLength();
                System.out.println("count=" + list_sh.size() + "time=" + (tsEnd - tsBegin));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DBFReader.write(recordLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void write(int recordLength) {
        DBFWriter dbfWriter = new DBFWriter(new File("D://dbf//bxd-test6.dbf"));
        int i = 0;
        while (i < 1000) {
            Object[] rowData = new Object[8];
            int j = 0;
            while (j < 8) {
                rowData[j] = String.valueOf(i) + "\u884c" + j;
                ++j;
            }
            dbfWriter.addRecord(rowData);
            ++i;
        }
        dbfWriter.close();
    }

    public DBFReader(File file) throws FileNotFoundException, IOException {
        this(file, Charset.forName("gbk"));
    }

    public DBFReader(File file, Charset charset) throws FileNotFoundException, IOException {
        this.dbf = new RandomAccessFile(file, "r");
        this.dbf.seek(10000L);
        this.fc = this.dbf.getChannel();
        this.charset = charset;
        this.file = file;
        this.load(true);
    }

    public File getFile() {
        return this.file;
    }

    public void load(boolean all) throws IOException {
        this.loadHead();
        if (all) {
            this.loadField();
        }
    }

    private void loadHead() throws IOException {
        ByteBuffer bb = this.loadData(0, 32);
        this.orderBytes(bb);
        this.version = bb.get();
        this.update = new byte[3];
        bb.get(this.update);
        this.count = bb.getInt();
        this.dataidx = bb.getShort();
        this.length = bb.getShort();
        bb.position(bb.position() + 16);
        this.tabletag = bb.get();
        this.pagetag = bb.get();
        bb.clear();
        long fileSize = this.file.length();
        long countSize = fileSize - (long)this.dataidx;
        if (this.length != 0) {
            this.count = (int)countSize / this.length;
        }
    }

    private void loadField() throws IOException {
        ByteBuffer bb = this.loadData(32, this.getFieldCount() * 32);
        this.orderBytes(bb);
        Field[] fds = new Field[this.getFieldCount()];
        int i = 0;
        while (i < fds.length) {
            fds[i] = new Field(i, bb);
            ++i;
        }
        this.fields = fds;
        bb.clear();
    }

    private List<Record> loadRecordsJustDel() throws IOException {
        ByteBuffer bb = this.loadData(this.getDataIndex(), this.getCount() * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[0] == '*') {
                Record r = new Record(b);
                rds.add(r);
            }
            ++i;
        }
        bb.clear();
        return rds;
    }

    private List<Record> loadRecordsWithOutDel() throws IOException {
        ByteBuffer bb = this.loadData(this.getDataIndex(), this.getCount() * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[0] != '*') {
                Record r = new Record(b);
                rds.add(r);
            }
            ++i;
        }
        bb.clear();
        return rds;
    }

    private List<Record> loadRecords() throws IOException {
        ByteBuffer bb = this.loadData(this.getDataIndex(), this.getCount() * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            Record r = new Record(b);
            rds.add(r);
            ++i;
        }
        bb.clear();
        return rds;
    }

    public List<Record> loadRecordsForSZWTSure(int offset, int count) throws IOException {
        if (this.getCount() < offset) {
            return new ArrayList<Record>();
        }
        int relCount = count;
        if (this.getCount() - offset <= count) {
            relCount = this.getCount() - offset;
        }
        ByteBuffer bb = this.loadData(this.getDataIndex() + offset * this.getRecordLength(), relCount * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(relCount);
        int i = 0;
        while (i < relCount) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[65] == 'z') break;
            Record r = new Record(b);
            rds.add(r);
            ++i;
        }
        bb.clear();
        return rds;
    }

    public List<Record> loadRecordsForSZFJYQRSure(int offset, int count) throws IOException {
        if (this.getCount() < offset) {
            return new ArrayList<Record>();
        }
        int relCount = count;
        if (this.getCount() - offset <= count) {
            relCount = this.getCount() - offset;
        }
        ByteBuffer bb = this.loadData(this.getDataIndex() + offset * this.getRecordLength(), relCount * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(relCount);
        int i = 0;
        while (i < relCount) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[341] == 'z') break;
            Record r = new Record(b);
            rds.add(r);
            ++i;
        }
        bb.clear();
        return rds;
    }

    public List<Record> loadRecordsForSZWTForUse() throws IOException {
        ByteBuffer bb = this.loadData(this.getDataIndex(), this.getCount() * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[0] != '*' && ((char)b[65] == '1' || (char)b[65] == 'z' || (char)b[65] == 'Z')) {
                Record r = new Record(b);
                rds.add(r);
            }
            ++i;
        }
        bb.clear();
        return rds;
    }

    public List<Record> loadRecordsForSZFJYQRForUse() throws IOException {
        ByteBuffer bb = this.loadData(this.getDataIndex(), this.getCount() * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(this.getCount());
        int i = 0;
        while (i < this.getCount()) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[0] != '*' && ((char)b[341] == '1' || (char)b[341] == 'z' || (char)b[341] == 'Z')) {
                Record r = new Record(b);
                rds.add(r);
            }
            ++i;
        }
        bb.clear();
        return rds;
    }

    public List<Record> loadRecordsForSZWTReport(int offset, int count) throws IOException {
        if (this.getCount() < offset) {
            return new ArrayList<Record>();
        }
        int relCount = count;
        if (this.getCount() - offset <= count) {
            relCount = this.getCount() - offset;
        }
        ByteBuffer bb = this.loadData(this.getDataIndex() + offset * this.getRecordLength(), relCount * this.getRecordLength());
        ArrayList<Record> rds = new ArrayList<Record>(relCount);
        int i = 0;
        while (i < relCount) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            Record r = new Record(b);
            rds.add(r);
            ++i;
        }
        bb.clear();
        return rds;
    }

    public int loadMaxRecordSequenceForSure(char userFlag, char channelFlag, int seqLen) throws IOException {
        int maxSequence = 0;
        int relCount = this.count;
        ByteBuffer bb = this.loadData(this.getDataIndex(), relCount * this.getRecordLength());
        int i = 0;
        while (i < relCount) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[17] == userFlag && (char)b[18] == channelFlag) {
                String seqStr = "";
                int j = 0;
                while (j < seqLen) {
                    seqStr = String.valueOf(seqStr) + (char)b[19 + j];
                    ++j;
                }
                int seq = Integer.parseInt(seqStr);
                if (seq > maxSequence) {
                    maxSequence = seq;
                }
            }
            ++i;
        }
        return maxSequence;
    }

    public int loadMaxRecordSequenceForSjsFjyBsSure(char userFlag, char channelFlag, int seqLen) throws IOException {
        int maxSequence = 0;
        int relCount = this.count;
        ByteBuffer bb = this.loadData(this.getDataIndex(), relCount * this.getRecordLength());
        int i = 0;
        while (i < relCount) {
            byte[] b = new byte[this.getRecordLength()];
            bb.get(b);
            if ((char)b[12] == userFlag && (char)b[13] == channelFlag) {
                String seqStr = "";
                int j = 0;
                while (j < seqLen) {
                    seqStr = String.valueOf(seqStr) + (char)b[14 + j];
                    ++j;
                }
                int seq = Integer.parseInt(seqStr);
                if (seq > maxSequence) {
                    maxSequence = seq;
                }
            }
            ++i;
        }
        return maxSequence;
    }

    private ByteBuffer loadData(int offset, int length) throws IOException {
        ByteBuffer b = ByteBuffer.allocateDirect(length);
        this.fc.position(offset);
        this.fc.read(b);
        b.rewind();
        return b;
    }

    public void close() throws IOException {
        this.fc.close();
        this.dbf.close();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getUpdate() {
        return this.update;
    }

    public int getCount() {
        return this.count;
    }

    public int getDataIndex() {
        return this.dataidx;
    }

    public int getRecordLength() {
        return this.length;
    }

    public int getTableTag() {
        return this.tabletag;
    }

    public int getPageTag() {
        return this.pagetag;
    }

    public int getFieldCount() {
        if (this.fields == null) {
            return (this.getDataIndex() - 32 - 1) / 32;
        }
        return this.fields.length;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Record getRecord(int index) throws IOException {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException("index " + index + " out of bound " + this.getCount());
        }
        int i = this.getDataIndex() + this.getRecordLength() * index;
        ByteBuffer b = this.loadData(i, this.getRecordLength());
        Record r = new Record(b);
        return r;
    }

    public List<Record> recordsWithOutDel() throws IOException {
        return this.loadRecordsWithOutDel();
    }

    public List<byte[]> recordsWithOutDel_efficiently(CacheManager cacheManager) throws IOException {
        ByteBuffer bb = cacheManager.getByteBuffer(this.getCount() * this.getRecordLength());
        this.fc.position(this.getDataIndex());
        this.fc.read(bb);
        bb.rewind();
        ArrayList<byte[]> rds = new ArrayList<byte[]>(this.getCount());
        List<byte[]> byteArrayList = cacheManager.getByteArrayList(this.getCount(), this.getRecordLength());
        int i = 0;
        while (i < this.getCount()) {
            byte[] b = byteArrayList.get(i);
            bb.get(b);
            if ((char)b[0] != '*') {
                rds.add(b);
            }
            ++i;
        }
        bb.clear();
        return rds;
    }

    public String get_string_efficiently(byte[] src, int index) {
        return this.get_string_efficiently(src, this.getFields()[index]).trim();
    }

    public String get_string_efficiently(byte[] src, Field field) {
        return new String(src, field.getOffset(), field.getLength(), this.getCharset()).trim();
    }

    public long get_long_efficiently(byte[] src, int index) {
        long result = 0L;
        Field field = this.getFields()[index];
        int i = field.getOffset();
        while (i < field.getOffset() + field.getLength()) {
            if (src[i] != 32) {
                if (src[i] < 48 || src[i] > 57) {
                    throw new NumberFormatException();
                }
                result = result * 10L + (long)(src[i] - 48);
            }
            ++i;
        }
        return result;
    }

    public long get_long_efficiently_and_multiply_1000(byte[] src, int index) {
        long multiplicand = 3L;
        long result = 0L;
        Field field = this.getFields()[index];
        boolean in_decimal_part = false;
        int offset = field.getOffset();
        int length = field.getLength();
        int end = offset + length;
        int i = field.getOffset();
        while (i < end) {
            byte ch = src[i];
            if (ch >= 48 && ch <= 57) {
                result *= 10L;
                result += (long)(ch - 48);
                if (in_decimal_part) {
                    --multiplicand;
                }
                if (multiplicand == 0L) {
                    break;
                }
            } else if (ch != 32) {
                if (ch == 46) {
                    in_decimal_part = true;
                } else {
                    throw new NumberFormatException();
                }
            }
            ++i;
        }
        if (multiplicand == 3L) {
            result *= 1000L;
        } else if (multiplicand == 2L) {
            result *= 100L;
        } else if (multiplicand == 1L) {
            result *= 10L;
        }
        return result;
    }

    public List<Record> recordsJustDel() throws IOException {
        return this.loadRecordsJustDel();
    }

    public List<Record> records() throws IOException {
        return this.loadRecords();
    }

    private ByteBuffer orderBytes(ByteBuffer bytes) {
        return bytes.order(ByteOrder.LITTLE_ENDIAN);
    }

    public class Field {
        public static final byte START_LOC = 0;
        public static final byte NAME_LOC = 0;
        public static final byte NAME_LEN = 11;
        public static final byte TYPE_LOC = 11;
        public static final byte TYPE_LEN = 1;
        public static final byte OFFSET_LOC = 12;
        public static final byte OFFSET_LEN = 4;
        public static final byte LENGTH_LOC = 16;
        public static final byte LENGTH_LEN = 1;
        public static final byte DECIMAL_LOC = 17;
        public static final byte DECIMAL_LEN = 1;
        public static final byte TAG_LOC = 18;
        public static final byte TAG_LEN = 1;
        public static final byte RESERVED_LOC = 19;
        public static final byte RESERVED_LEN = 13;
        public static final byte LENGTH = 32;
        private final int index;
        private final String name;
        private final char type;
        private final int offset;
        private final int length;
        private final int decimal;
        private final int tag;

        public Field(int index, ByteBuffer src) {
            src.position(index * 32);
            this.index = index;
            byte[] tb = new byte[11];
            src.get(tb);
            this.name = this.loadName(tb);
            this.type = (char)src.get();
            this.offset = src.getInt();
            this.length = src.get();
            this.decimal = src.get();
            this.tag = src.get();
        }

        private String loadName(byte[] src) {
            int i = 0;
            while (i < 11) {
                if (src[i] == 0) break;
                ++i;
            }
            return new String(src, 0, i, DBFReader.this.getCharset());
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public char getType() {
            return this.type;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getDecimal() {
            return this.decimal;
        }

        public int getTag() {
            return this.tag;
        }
    }

    class ReadRecordWorker
    implements Runnable {
        private ByteBuffer bb;
        private int startIndexOfRow;
        private int endIndexOfRow;
        private List<byte[]> byteArrayList;
        private CountDownLatch countDownLatch;

        public ReadRecordWorker(ByteBuffer bb, int startIndexOfRow, int endIndexOfRow, List<byte[]> byteArrayList, CountDownLatch countDownLatch) {
            this.bb = bb;
            this.startIndexOfRow = startIndexOfRow;
            this.endIndexOfRow = endIndexOfRow;
            this.byteArrayList = byteArrayList;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                int i = this.startIndexOfRow;
                while (i <= this.endIndexOfRow) {
                    byte[] b = this.byteArrayList.get(i);
                    this.bb.get(b);
                    ++i;
                }
                this.bb.clear();
            }
            finally {
                if (this.countDownLatch != null) {
                    this.countDownLatch.countDown();
                }
            }
        }
    }

    public class Record {
        private final byte[] src;

        public Record(ByteBuffer src) {
            byte[] bs = new byte[src.capacity()];
            src.get(bs);
            this.src = bs;
        }

        public Record(byte[] src) {
            this.src = src;
        }

        public String getString(int index) {
            return this.getString(DBFReader.this.getFields()[index]).trim();
        }

        public String getString(Field field) {
            return new String(this.src, field.getOffset(), field.getLength(), DBFReader.this.getCharset()).trim();
        }

        public String getStringNotTrim(int index) {
            return this.getStringNotTrim(DBFReader.this.getFields()[index]);
        }

        public String getStringNotTrim(Field field) {
            return new String(this.src, field.getOffset(), field.getLength(), DBFReader.this.getCharset());
        }

        public int getInt(int index) {
            return this.getInt(DBFReader.this.getFields()[index]);
        }

        public int getInt(Field field) {
            String s = this.getString(field);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) {
                return Integer.valueOf(s.trim());
            }
            return -1;
        }

        public long getLong(int index) {
            return this.getLong(DBFReader.this.getFields()[index]);
        }

        public long get_long_efficiently(int index) {
            long result = 0L;
            Field field = DBFReader.this.getFields()[index];
            int i = field.getOffset();
            while (i < field.getOffset() + field.getLength()) {
                if (this.src[i] != 32) {
                    if (this.src[i] < 48 || this.src[i] > 57) {
                        throw new NumberFormatException();
                    }
                    result = result * 10L + (long)(this.src[i] - 48);
                }
                ++i;
            }
            return result;
        }

        public long get_long_efficiently_and_multiply_1000(int index) {
            long multiplicand = 1000L;
            long result = 0L;
            Field field = DBFReader.this.getFields()[index];
            boolean in_decimal_part = false;
            int offset = field.getOffset();
            int length = field.getLength();
            int end = offset + length;
            int i = field.getOffset();
            while (i < end) {
                byte ch = this.src[i];
                if (ch != 32) {
                    if (ch == 46) {
                        in_decimal_part = true;
                    } else {
                        if (ch < 48 || ch > 57) {
                            throw new NumberFormatException();
                        }
                        result *= 10L;
                        result += (long)(ch - 48);
                        if (in_decimal_part) {
                            multiplicand /= 10L;
                        }
                        if (multiplicand == 1L) break;
                    }
                }
                ++i;
            }
            return result *= multiplicand;
        }

        public long getLong(Field field) {
            String s = this.getString(field);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) {
                return Long.valueOf(s.trim());
            }
            return -1L;
        }

        public float getFloat(int index) {
            return this.getFloat(DBFReader.this.getFields()[index]);
        }

        public float getFloat(Field field) {
            String s = this.getString(field);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) {
                return Float.valueOf(s).floatValue();
            }
            return -1.0f;
        }

        public BigDecimal getBigDecimal(int index) {
            return this.getBigDecimal(DBFReader.this.getFields()[index]);
        }

        public BigDecimal getBigDecimal(Field field) {
            String s = this.getString(field);
            if (!this.isNumeric(s)) {
                return BigDecimal.ZERO;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) {
                return BigDecimal.valueOf(Double.valueOf(s));
            }
            return new BigDecimal(-1);
        }

        public String getDate(Field field) {
            String s = this.getString(field);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) {
                return DBFReader.this.sdf.format(s);
            }
            return "";
        }

        public String getDate(int index) {
            return this.getDate(DBFReader.this.getFields()[index]);
        }

        public Object getObject(int index) {
            return this.getObject(DBFReader.this.getFields()[index]);
        }

        public char getChar(int index) {
            return this.getChar(DBFReader.this.getFields()[index]);
        }

        public char getChar(Field field) {
            String s = this.getString(field);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s})) {
                return s.charAt(0);
            }
            return '\u0000';
        }

        public Object getObject(Field field) {
            switch (field.getType()) {
                case 'C': {
                    return this.getString(field);
                }
                case 'N': {
                    if (field.getDecimal() > 0) {
                        return Float.valueOf(this.getFloat(field));
                    }
                    return this.getLong(field);
                }
                case 'I': {
                    return this.getInt(field);
                }
            }
            throw new UnsupportedOperationException("Unsupport type: " + field.getType());
        }

        public boolean isNumeric(String str) {
            Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]+");
            Matcher isNum = pattern.matcher(str);
            return isNum.matches();
        }
    }
}

