/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils;

public final class Util {
    public static final int MAX_MINI_UINT = 256;

    private Util() {
    }

    public static int getUnsignedInt(byte[] bytes, int start, int length) {
        int value = 0;
        int i = 0;
        while (i < length) {
            value += Util.getIntValue(bytes[start + i], i);
            ++i;
        }
        return value;
    }

    public static int getIntValue(byte b, int bytePos) {
        int v = 1;
        int i = 0;
        while (i < bytePos) {
            v <<= 8;
            ++i;
        }
        return Util.getUnsignedInt(b) * v;
    }

    public static int getUnsignedInt(byte byteValue) {
        if (byteValue < 0) {
            return byteValue + 256;
        }
        return byteValue;
    }

    public static byte[] getByteFromInt(int value, int bit) {
        byte[] result = new byte[bit];
        int i = 0;
        while (i < bit) {
            int pos = i << 3;
            result[i] = (byte)((255 << pos & value) >> pos);
            ++i;
        }
        return result;
    }

    public static Boolean getBooleanValue(String stringValue) {
        String value = stringValue.toLowerCase();
        if ("t".equals(value) || "y".equals(value)) {
            return true;
        }
        if ("f".equals(value) || "n".equals(value)) {
            return false;
        }
        return null;
    }
}

