/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.file.dbf.utils.FileHander;
import cms.tmx.file.dbf.utils.FileScanHistory;
import java.io.File;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ReqFileListener
implements FileAlterationListener {
    private static final Logger logger = LogManager.getLogger(ReqFileListener.class);
    @Inject
    protected MEventService es;
    @Inject
    private FileScanHistory history;
    @Inject
    private FileHander fileHander;

    public void onStart(FileAlterationObserver fileAlterationObserver) {
        logger.debug("fileAlterationObserver  onStart!");
    }

    public void onDirectoryCreate(File file) {
        logger.info(String.valueOf(file.getName()) + " director created.");
    }

    public void onDirectoryChange(File file) {
        logger.info(String.valueOf(file.getName()) + " director changed.");
    }

    public void onDirectoryDelete(File file) {
        logger.info(String.valueOf(file.getName()) + " director deleted.");
        MEvent event = new MEvent();
        event.setDesc("\u6587\u4ef6\u5355\u76d1\u63a7\u76ee\u5f55\uff1a" + file.getAbsolutePath() + "\u88ab\u5220\u9664\uff01");
        this.es.postEvent("message.log", event);
    }

    public void onFileCreate(File file) {
    }

    public void onFileChange(File file) {
        logger.info("~~~~~  file change" + file.getName());
        if (!"order.dbf".equals(file.getName().toLowerCase())) {
            return;
        }
        String uuid = UUID.randomUUID().toString();
        long startTime = System.currentTimeMillis();
        logger.info("[" + uuid + "]" + file.getName() + " change.");
        if (!this.checkFileNameFormat(file.getName())) {
            logger.error("[" + uuid + "]" + file.getName() + " is bad format!");
            return;
        }
        MEvent event = new MEvent();
        event.put((Object)"file", (Object)file);
        event.put((Object)"file.manipulate.record.uuid", (Object)uuid);
        event.put((Object)"file.name", (Object)file.getName());
        event.put((Object)"work.mode", (Object)"dbf.monitor.work.mode");
        event.put((Object)"file.manipulate.record.start.time", (Object)startTime);
        if (file.getName().startsWith("order")) {
            logger.info("[" + uuid + "]" + file.getName() + "\u6536\u5230\u65b0\u5185\u5bb9\uff0c \u5355\u6587\u4ef6\u6a21\u5f0f. begin...");
            this.fileHander.onMonoFileInput(event);
        }
    }

    public void onFileDelete(File file) {
        logger.info(String.valueOf(file.getName()) + " deleted.");
    }

    public void onStop(FileAlterationObserver fileAlterationObserver) {
        logger.debug("fileAlterationObserver  stop.");
    }

    private boolean checkFileNameFormat(String filename) {
        return "order.dbf".equals(filename.toLowerCase());
    }
}

