/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils;

import cms.tmx.file.dbf.utils.DbfWriter;
import cms.tmx.file.dbf.utils.Field;
import cms.tmx.file.dbf.utils.Util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class FoxproDBaseWriter
extends DbfWriter {
    public static final int NAME_LENGTH = 10;
    public static final int RECORD_COUNT_LENGTH = 4;
    public static final int HEADER_LENGTH_LENGTH = 2;
    public static final int RECORD_LENGTH_LENGTH = 2;
    public static final int START_YEAR = 1900;
    int allFieldsLength = 0;

    private void writeField(Field field) throws IOException {
        byte[] fieldNameBytearr = field.getName().getBytes(this.getEncode());
        byte[] destFieldNameBuffer = new byte[10];
        int destlen = fieldNameBytearr.length > 10 ? 10 : fieldNameBytearr.length;
        System.arraycopy(fieldNameBytearr, 0, destFieldNameBuffer, 0, destlen);
        this.bodybuffer.write(destFieldNameBuffer);
        this.bodybuffer.write(0);
        this.bodybuffer.write((byte)field.getType());
        this.bodybuffer.write(Util.getByteFromInt(field.getDisplacement(), 4));
        this.bodybuffer.write(Util.getByteFromInt(field.getLength(), 1));
        this.bodybuffer.write(Util.getByteFromInt(field.getDecimal(), 1));
        this.bodybuffer.write(new byte[14]);
        this.allFieldsLength += field.getLength();
    }

    @Override
    public void writeFields(List<Field> fieldlist) throws IOException {
        this.setFields(fieldlist);
        for (Field field : fieldlist) {
            this.writeField(field);
        }
        this.bodybuffer.write(13);
    }

    @Override
    protected void writeHeaders() throws IOException {
        this.headbuffer.write(48);
        this.headbuffer.write(this.getDateInfoByteArray());
        this.headbuffer.write(Util.getByteFromInt(this.getPostion(), 4));
        this.headbuffer.write(Util.getByteFromInt(32 + 32 * this.fields.size() + 1, 2));
        this.headbuffer.write(Util.getByteFromInt(this.allFieldsLength, 2));
        this.headbuffer.write(new byte[20]);
    }

    @Override
    public void writeRecord(String ... values) throws IOException, NullPointerException {
        if (this.fields == null) {
            throw new NullPointerException("\u5b57\u6bb5\u8868\u4e3a\u7a7a\u6307\u9488,\u8bf7\u5148\u8c03\u7528writeFields\u65b9\u6cd5");
        }
        boolean removed = false;
        int valueLength = values.length;
        int fieldsLength = this.fields.size();
        if (valueLength != fieldsLength) {
            if (valueLength - fieldsLength == 1) {
                if (!"*".equals(values[0])) {
                    throw new IOException(String.format("\u5b57\u6bb5\u957f\u5ea6\u4e3a:%d,\u4f46\u8be5\u6761\u6570\u636e\u957f\u5ea6\u4e3a:%d,\u6e38\u6807:%d", fieldsLength, values.length, this.getPostion()));
                }
                removed = true;
            } else {
                throw new IOException(String.format("\u5b57\u6bb5\u957f\u5ea6\u4e3a:%d,\u4f46\u8be5\u6761\u6570\u636e\u957f\u5ea6\u4e3a:%d,\u6e38\u6807:%d", fieldsLength, values.length, this.getPostion()));
            }
        }
        this.next();
        int i = 0;
        if (removed) {
            this.bodybuffer.write(42);
            ++i;
        }
        int j = 0;
        while (i < valueLength) {
            this.fillRecord((Field)this.fields.get(j), values[i]);
            ++i;
            ++j;
        }
    }

    private byte[] getDateInfoByteArray() {
        byte[] result = new byte[3];
        Date date = new Date();
        result[0] = Util.getByteFromInt(Integer.parseInt(new SimpleDateFormat("yyyy").format(date)) - 1900, 1)[0];
        result[1] = Util.getByteFromInt(Integer.parseInt(new SimpleDateFormat("M").format(date)), 1)[0];
        result[2] = Util.getByteFromInt(Integer.parseInt(new SimpleDateFormat("d").format(date)), 1)[0];
        return result;
    }

    private void fillRecord(Field field, String value) throws IOException {
        int needFillLength = field.getLength() - value.length();
        byte[] fillbank = new byte[needFillLength];
        int j = 0;
        while (j < needFillLength) {
            fillbank[j] = 32;
            ++j;
        }
        this.bodybuffer.write(fillbank);
        this.bodybuffer.write(value.getBytes(this.getEncode()));
    }
}

