/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.file.dbf.api.PositionApi;
import cms.tmx.file.dbf.api.TradeApi;
import cms.tmx.file.dbf.entity.DbfOrder;
import cms.tmx.file.dbf.entity.FileInfo;
import cms.tmx.file.dbf.entity.OrderRecord;
import cms.tmx.file.dbf.entity.RecordUpdateEvent;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FileHander {
    @Inject
    protected MEventService es;
    @Inject
    private ExecutorService exe;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private PositionApi posApi;
    private static final Logger logger = LogManager.getLogger(FileHander.class);
    private static volatile Map<String, Long> monoFileReadPos = new HashMap<String, Long>();
    private static volatile AtomicBoolean hasSub = new AtomicBoolean(false);
    private LinkedBlockingQueue<MEvent> monitorQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<MEvent> scanQueue = new LinkedBlockingQueue();
    private List<MEvent> recordToWrite = new ArrayList<MEvent>();
    private Map<String, StringBuilder> recordToWriteMap = new HashMap<String, StringBuilder>(32);
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    @Inject
    private TradeApi tradeApi;
    @Inject
    private MxAlert alert;
    @Inject
    private AccountMngServiceImpl accService;
    @Inject
    private IBaseApi baseApi;
    private Future<?> future;
    private Future<?> futureMonitor;
    private DecimalFormat sDFPrice = new DecimalFormat("0.0000");
    private DecimalFormat sDFAmount = new DecimalFormat("0.00");
    private DecimalFormat sDFQty = new DecimalFormat("#.##");
    private boolean firstStart = true;
    private AtomicInteger index = new AtomicInteger(0);
    private Set<String> needPopAccountsId = new HashSet<String>();
    private Lock lock = new ReentrantLock();
    private boolean initDone = false;
    private volatile int scan_guid = 0;
    private ConcurrentHashMap<String, OrderRecord> fileorderMap;
    private int times = 0;

    @PreDestroy
    private void close() {
        if (this.future != null) {
            this.future.cancel(true);
            logger.error("\u6587\u4ef6\u5355\u5199\u6587\u4ef6\u7ebf\u7a0b\u5173\u95ed");
        }
        if (this.futureMonitor != null) {
            this.futureMonitor.cancel(true);
            logger.error("\u6587\u4ef6\u5355\u76d1\u542c\u6a21\u5f0f\u5199\u6587\u4ef6\u7ebf\u7a0b\u5173\u95ed");
        }
    }

    @PostConstruct
    public void init() {
        logger.info("=======FileHandler\u6a21\u5757\u521d\u59cb\u5316");
        this.es.subscribe("server.sub", e -> this.onPush(e));
        this.es.subscribe("dbf.export", e -> this.dbfExport());
        this.initPop();
        this.futureMonitor = this.exe.submit(() -> this.threadPushMonitor());
    }

    private void initPop() {
        if (this.initDone) {
            return;
        }
        this.lock.lock();
        try {
            try {
                ObservableList accntList = this.accService.getAccountListByPost(this.baseApi.getPostId());
                this.needPopAccountsId.addAll(accntList.stream().filter(item -> item.isFileOrderManualConfirmation()).map(Account::getInvestorId).collect(Collectors.toList()));
                this.initDone = true;
            }
            catch (MException e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u521d\u59cb\u5316\u8d26\u53f7\u5f39\u6846\u6743\u9650\u5931\u8d25" + (Object)((Object)e)));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void dbfExport() {
        File resFolder;
        ObservableList ccsFocusAccountList;
        block18: {
            logger.info("\u5f00\u59cb\u5bfc\u51fa\u8d44\u91d1\u53ca\u6301\u4ed3");
            ccsFocusAccountList = this.fundMng.getCcsFocusAccountList();
            String respath = this.eCore.getStr("dbf.monitor.res.req.folder");
            resFolder = new File(respath);
            if (!resFolder.exists()) {
                logger.error("[] \u56de\u62a5\u76ee\u5f55\u672a\u521b\u5efa  \uff01");
                this.reportMessage("\u4e0d\u5b58\u5728\u7684\u56de\u62a5\u76ee\u5f55[" + resFolder.getPath() + "]");
                return;
            }
            File fundF = new File(respath, "fund.dbf");
            File positionF = new File(respath, "position.dbf");
            if (fundF.exists()) {
                fundF.delete();
            }
            if (positionF.exists()) {
                positionF.delete();
            }
            this.createFile(respath, "fund.dbf");
            this.createFile(respath, "position.dbf");
            Path fundPath = Paths.get(resFolder.getAbsolutePath(), "Fund.dbf");
            File fundFile = fundPath.toFile();
            DBFWriter writer = new DBFWriter(fundFile);
            writer.setCharactersetName("GB2312");
            try {
                try {
                    for (FundAccount fund : ccsFocusAccountList) {
                        if (!"99999-01-01".equals(fund.getCounterId()) || !(fund instanceof CcsFundAccount)) continue;
                        Iterator ccsFund = (CcsFundAccount)CcsFundAccount.class.cast(fund);
                        Object[] rowData = new String[]{ccsFund.getInvestId(), ccsFund.getCurrencyId(), this.sDFAmount.format(ccsFund.getPreBalance()), this.sDFAmount.format(ccsFund.getAvailable()), this.sDFAmount.format(ccsFund.getFrozenAmount())};
                        writer.addRecord(rowData);
                    }
                    writer.write();
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u8d44\u91d1\u51fa\u9519", (Throwable)e);
                    writer.close();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                writer.close();
                throw throwable;
            }
            writer.close();
        }
        logger.info("\u5f00\u59cb\u5bfc\u51fa\u6301\u4ed3");
        ArrayList<Position> positions = new ArrayList<Position>();
        for (FundAccount fund : ccsFocusAccountList) {
            try {
                positions.addAll(this.posApi.queryPositions(fund));
            }
            catch (MException e) {
                logger.error(String.valueOf(fund.getInvestId()) + " \u67e5\u8be2\u6301\u4ed3\u51fa\u9519 ", (Throwable)e);
            }
        }
        Path positionPath = Paths.get(resFolder.getAbsolutePath(), "Position.dbf");
        File positionFile = positionPath.toFile();
        positionWriter.setCharactersetName("GB2312");
        try (DBFWriter positionWriter = new DBFWriter(positionFile);){
            try {
                for (Position pos : positions) {
                    if (!(pos instanceof CcsPosition)) continue;
                    CcsPosition ccsPos = (CcsPosition)CcsPosition.class.cast(pos);
                    Object[] rowData = new String[]{ccsPos.getInvestorId(), ccsPos.getInverstorSecId(), ccsPos.getMarket().getRaw(), ccsPos.getSecId(), ccsPos.getSecName(), ccsPos.getSecType(), this.sDFQty.format(ccsPos.getSellOut()), this.sDFQty.format(ccsPos.getBuyIn()), this.sDFAmount.format(ccsPos.getSellOutFrozen()), this.sDFPrice.format(ccsPos.getCost())};
                    positionWriter.addRecord(rowData);
                }
                positionWriter.write();
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51fa\u6301\u4ed3\u51fa\u9519", (Throwable)e);
                positionWriter.close();
            }
        }
    }

    private void createFile(String resFolder, String fileName) {
        File file = new File(resFolder, fileName);
        List<FileInfo.FiledInfo> filedInfos = FileInfo.getFileds(fileName);
        if (!file.exists() && filedInfos != null) {
            DBFField[] fields = new DBFField[filedInfos.size()];
            int i = 0;
            while (i < filedInfos.size()) {
                fields[i] = new DBFField();
                fields[i].setName(filedInfos.get(i).getFiledName());
                fields[i].setType(filedInfos.get(i).getFiledType());
                fields[i].setLength(filedInfos.get(i).getFiledLength());
                ++i;
            }
            DBFWriter writer = new DBFWriter(file);
            writer.setCharactersetName("GB2312");
            writer.setFields(fields);
            writer.close();
        }
    }

    private void onFileOperationEnd(MEvent e) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        RecordUpdateEvent event = new RecordUpdateEvent();
        event.setEndTime(DateTimeUtils.getTimeStamp());
        e.setObj((Object)event);
        this.es.sendEvent("dbf/file/request/update", e);
        logger.info("[" + uuid + "]" + "\u6b64\u6b21\u6587\u4ef6\u6539\u53d8\u7684\u4e0b\u5355\u8bf7\u6c42\u5b8c\u6210\uff01 ");
    }

    private void onMessageTip(MEvent e, int code, String desc) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        long endTime = System.currentTimeMillis();
        e.put((Object)"file.manipulate.record.end.time", (Object)endTime);
        e.setCode(code);
        e.setDesc(desc);
        this.es.postEvent("message.log", e);
        logger.info("[" + uuid + "] desc[" + desc + "]\u4e0a\u62a5\u6d88\u606f\u754c\u9762\uff01 ");
    }

    public void onMonoFileInput(final MEvent e) {
        this.initPop();
        final String uuid = e.getStr("file.manipulate.record.uuid");
        logger.info("[" + uuid + "] \u5f00\u59cb\u5355\u6587\u4ef6\u5904\u7406");
        RandomAccessFile randomFile = null;
        ArrayList<Boolean> pops = new ArrayList<Boolean>();
        try {
            long readPos = 0L;
            File file = (File)e.get((Object)"file");
            if (monoFileReadPos.containsKey(file.getName())) {
                readPos = monoFileReadPos.get(file.getName());
            }
            InputStream fis = null;
            new ArrayList();
            ArrayList<Object[]> records = new ArrayList<Object[]>();
            try {
                Object[] rowValues;
                fis = new FileInputStream(file);
                DBFReader reader = new DBFReader(fis);
                reader.setCharactersetName("GB2312");
                while ((rowValues = reader.nextRecord()) != null) {
                    records.add(rowValues);
                }
            }
            finally {
                fis.close();
            }
            if (records == null || records.isEmpty()) {
                logger.info("\u672a\u626b\u5230\u9700\u8981\u62a5\u5355\u7684\u8bb0\u5f55" + records);
                return;
            }
            final List<DbfOrder> orders = this.parseFile(records, this.index.get());
            if (orders.isEmpty()) {
                logger.info("\u672a\u626b\u5230\u9700\u8981\u62a5\u5355\u7684\u8bb0\u5f55");
                return;
            }
            try {
                for (DbfOrder order : orders) {
                    if (!this.needPopAccountsId.contains(order.getInvestId())) continue;
                    pops.add(true);
                    break;
                }
                logger.info("[" + uuid + "]" + "\u5355\u6587\u4ef6\u540d\u5b57[" + file.getName() + "]" + "order size[" + orders.size() + "]");
                e.put((Object)"monofile.last.read.pos", (Object)readPos);
                monoFileReadPos.put(file.getName(), readPos);
                e.put((Object)"file.manipulate.record.sum.count", (Object)orders.size());
                this.es.postEvent("dbf/file/request/record", e);
                logger.info(String.format("uuid[%s] %s", uuid, "\u5f02\u6b65\u5904\u7406\u5355\u6587\u4ef6\u6a21\u5f0f\u3002\u3002\u3002"));
                Platform.runLater(() -> {
                    if (pops.size() > 0 && !this.alert.alert(Alert.AlertType.CONFIRMATION, "\u5f53\u6b21\u6587\u4ef6\u53d8\u52a8\u4e2d\u5305\u542b[" + orders.size() + "]\u7b14\u8bf7\u6c42\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f")) {
                        return;
                    }
                    this.exe.execute(new Runnable(){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public void run() {
                            try {
                                FileHander.access$1(FileHander.this).batchEntrust(orders, uuid);
                                FileHander.access$2().info("[" + uuid + "]" + "\u8bf7\u6c42\u54cd\u5e94\u5b8c\u6210\uff0c \u5e76\u53d1\u4e8b\u4ef6\u5230\u754c\u9762 : " + e.entrySet());
                                orderInfoLine = e.getStr("file.line");
                                if (e.getCode() == 0) ** GOTO lbl11
                                if (e.getCode() == 999980) {
                                    FileHander.access$2().error("[" + uuid + "]" + "\u7528\u6237\u53d6\u6d88\u4e0b\u5355\uff0c\u4e0d\u7528\u5199\u54cd\u5e94\u6587\u4ef6\uff1a" + orderInfoLine);
                                    return;
                                }
                                try {
                                    FileHander.access$2().error("[" + uuid + "]" + "\u8bf7\u6c42\u5931\u8d25:" + orderInfoLine);
lbl11:
                                    // 2 sources

                                    FileHander.access$2().info("[" + uuid + "]" + "\u6536\u5230\u54cd\u5e94\u6210\u529f, \u51c6\u5907\u5199\u5230res\u6587\u4ef6 e: " + e.entrySet());
                                }
                                catch (MException | Exception e) {
                                    FileHander.access$2().error("[" + uuid + "]", e);
                                }
                            }
                            finally {
                                FileHander.access$0(FileHander.this, e);
                            }
                        }
                    });
                });
            }
            catch (Exception e2) {
                logger.error("[" + uuid + "]", (Throwable)e2);
                this.onMessageTip(e, 999979, e2.getMessage());
            }
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (IOException e1) {
                    logger.error("[" + uuid + "]", (Throwable)e1);
                }
            }
        }
    }

    private List<DbfOrder> parseFile(List<Object[]> records, long readPos) throws Exception {
        ArrayList<DbfOrder> orders = new ArrayList<DbfOrder>();
        int i = (int)readPos;
        while (i < records.size()) {
            DbfOrder dbfOrder = new DbfOrder();
            Object[] record = records.get(i);
            dbfOrder.setType(String.valueOf(record[0]));
            dbfOrder.setInvestId(String.valueOf(record[1]));
            dbfOrder.setSysOrdId(String.valueOf(record[2]));
            dbfOrder.setSecurity(String.valueOf(record[3]));
            dbfOrder.setMarket(String.valueOf(record[4]));
            dbfOrder.setPrice(String.valueOf(record[5]));
            dbfOrder.setSide(String.valueOf(record[6]));
            dbfOrder.setOrderType(String.valueOf(record[7]));
            dbfOrder.setQuantity(String.valueOf(record[8]));
            dbfOrder.setInvestorSecId(String.valueOf(record[9]));
            dbfOrder.setClOrdId(String.valueOf(record[10]));
            orders.add(dbfOrder);
            ++i;
        }
        this.index.getAndSet(records.size());
        return orders;
    }

    protected void onPush(MEvent event) {
        if (!hasSub.get()) {
            return;
        }
        Object evObj = event.getObj();
        if (!this.careRepart(evObj)) {
            return;
        }
        MEvent newEvent = this.clone(3, event);
        if (newEvent == null) {
            logger.error("\u63a8\u9001\u4fe1\u606fclone\u5931\u8d25\uff0c" + event);
            return;
        }
        if (newEvent.getObj() instanceof ExecutionReport) {
            this.onExecutionReport(newEvent);
        } else if (newEvent.getObj() instanceof CancelRejectReport) {
            this.onOrderCancelPush(newEvent);
        }
    }

    private MEvent clone(int i, MEvent event) {
        int j = i;
        while (j > 0) {
            try {
                if (j != i) {
                    logger.info("\u5f00\u59cb\u5c1d\u8bd5clone" + j);
                    Thread.sleep(10L);
                }
                return event.clone();
            }
            catch (Exception e) {
                logger.error("clone\u5931\u8d25" + j, (Throwable)e);
                --j;
            }
        }
        return null;
    }

    private boolean careRepart(Object obj) {
        return obj instanceof ExecutionReport || obj instanceof CancelRejectReport;
    }

    private void onOrderCancelPush(MEvent event) {
    }

    private void onExecutionReport(MEvent event) {
        String type;
        if (!hasSub.get()) {
            return;
        }
        if (this.fileorderMap == null) {
            this.fileorderMap = (ConcurrentHashMap)this.eCore.get((Object)"fileorderMap");
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_"));
        report.getReport().getPortfolioId();
        String clOrderId = report.getReport().getClOrdId();
        String clListId = report.getReport().getClListId();
        if (!StringUtils.isEmpty((String)clOrderId)) {
            if (clOrderId.contains("|")) {
                String[] split = clOrderId.split("\\|");
                if (split.length == 3) {
                    event.put((Object)"client_seq", (Object)split[2]);
                }
            } else {
                event.put((Object)"client_seq", (Object)clOrderId);
            }
        }
        if (!StringUtils.isEmpty((String)clListId)) {
            if (clListId.contains("|")) {
                String[] splitList = clListId.split("\\|");
                if (splitList.length == 3) {
                    event.put((Object)"cl_list_id", (Object)splitList[2]);
                }
            } else {
                event.put((Object)"cl_list_id", (Object)clListId);
            }
        }
        switch (type = Integer.toString(report.getType())) {
            case "48": {
                this.buildEntrustConfirmReport(event, report);
                break;
            }
            case "70": {
                this.buildEntrustDoneReport(event, report);
                break;
            }
            case "52": {
                this.buildEntrustCancelReport(event, report);
                break;
            }
            case "56": {
                this.buildEntrustRejectReport(event, report);
                break;
            }
        }
    }

    private void receiveCallBack(MEvent event, ExecutionReport report, int FunctionCode) {
        String uuid = UUID.randomUUID().toString();
        if (this.eCore.getStr("dbf.monitor.response.model").equals("monofile")) {
            this.scan_guid = 0;
        }
        if (!report.getReport().hasSingleOrder() && !report.getReport().hasExecution()) {
            return;
        }
        event.put((Object)"file.manipulate.record.uuid", (Object)uuid);
        event.setFunctionCode(FunctionCode);
        try {
            MEvent clone = event.clone();
            clone.setFunctionCode(FunctionCode);
            clone.put((Object)"file.model", (Object)this.eCore.getStr("dbf.monitor.response.model"));
            clone.put((Object)"work.mode", (Object)"dbf.monitor.work.mode");
            this.monitorQueue.put(clone);
            logger.info("\u76d1\u542c\u6a21\u5f0f\u63a8\u9001\u4e8b\u4ef6\u653e\u5165\u6d88\u606f\u961f\u5217\uff0c\u4e8b\u4ef6UUID\uff1a " + uuid + " \u5f53\u524d\u6392\u961f\u6570\u91cf\uff1a" + this.monitorQueue.size());
        }
        catch (InterruptedException e) {
            logger.error("filehandler enqueue failed: " + Thread.currentThread(), (Throwable)e);
        }
    }

    private void threadPushMonitor() {
        while (true) {
            MEvent ePush = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("\u6587\u4ef6\u5355\u76d1\u542c\u63a8\u9001\u7ebf\u7a0b\u4e2d\u65ad", (Throwable)e);
            }
            try {
                if (this.monitorQueue.size() > 5) {
                    this.recordToWrite.clear();
                    this.recordToWriteMap.clear();
                    this.scanQueue.drainTo(this.recordToWrite, 30);
                    logger.info("\u76d1\u542c\u961f\u5217\u53d6\u51fa\u6d88\u606f\u4e8b\u4ef6\uff0csize\uff1a " + this.recordToWrite.size() + " \u5f53\u524d\u961f\u5217\u5269\u4f59\u6570\u91cf\uff1a" + this.scanQueue.size());
                    this.onFileOutput(this.recordToWrite, false);
                    continue;
                }
                ePush = this.monitorQueue.take();
                String UUID2 = ePush.getStr("file.manipulate.record.uuid");
                logger.info("\u76d1\u542c\u961f\u5217\u53d6\u51fa\u6d88\u606f\u4e8b\u4ef6\uff0c\u4e8b\u4ef6UUID\uff1a " + UUID2 + " \u5f53\u524d\u961f\u5217\u5269\u4f59\u6570\u91cf\uff1a" + this.scanQueue.size());
                this.onFileOutput(ePush, false);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("[push manager] dequeue failed: " + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.error("single push failed: " + Thread.currentThread() + (ePush == null ? "" : ePush.get((Object)"method_code")), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private synchronized void onFileOutput(MEvent e, boolean isRes) {
        block16: {
            System.nanoTime();
            String uuid = e.getStr("file.manipulate.record.uuid");
            logger.info("[" + uuid + "]\u5f00\u59cb\u5904\u7406");
            try {
                Object[] rowData;
                File dealFile;
                ExecutionReport dealReport;
                ExecutionReport orderReport;
                block15: {
                    System.nanoTime();
                    String workMode = e.getStr("work.mode");
                    String respath = workMode.equals("scan.work.mode") ? this.eCore.getStr("dbf.scan.res.req.folder") : this.eCore.getStr("dbf.monitor.res.req.folder");
                    File resFolder = new File(respath);
                    logger.info("[" + uuid + "] \u4e8b\u4ef6\u7684\u5de5\u4f5c\u6a21\u5f0f[" + workMode + "]\uff0c\u5f00\u59cb\u5904\u7406\u5199\u5165\u6587\u4ef6    : " + resFolder.getPath());
                    if (!resFolder.exists()) {
                        logger.error("[" + uuid + "] \u56de\u62a5\u76ee\u5f55\u672a\u521b\u5efa  \uff01");
                        this.reportMessage("\u4e0d\u5b58\u5728\u7684\u56de\u62a5\u76ee\u5f55[" + resFolder.getPath() + "]");
                        return;
                    }
                    orderReport = (ExecutionReport)e.get("dbf.order.report", ExecutionReport.class);
                    dealReport = (ExecutionReport)e.get("dbf.deal.report", ExecutionReport.class);
                    Path orderPath = Paths.get(resFolder.getAbsolutePath(), "OrderStatus.dbf");
                    File orderFile = orderPath.toFile();
                    Path dealPath = Paths.get(resFolder.getAbsolutePath(), "Deal.dbf");
                    dealFile = dealPath.toFile();
                    if (orderReport != null) {
                        if (!"XSHE".equals(orderReport.getReport().getInstrument().getMarket()) && !"XSHG".equals(orderReport.getReport().getInstrument().getMarket())) {
                            logger.info("DBF\u63a8\u9001\u5904\u7406\u5c4f\u853d\u6389\u975e\u73b0\u8d27\u59d4\u6258");
                            return;
                        }
                        DBFWriter writer = new DBFWriter(orderFile);
                        writer.setCharactersetName("GB2312");
                        try {
                            try {
                                rowData = new String[17];
                                POrderService.SingleOrder singleOrder = orderReport.getReport().getSingleOrder();
                                rowData[0] = singleOrder.getSysOrderId();
                                rowData[1] = singleOrder.getClOrdId().substring(singleOrder.getClOrdId().lastIndexOf("|") + 1);
                                rowData[2] = String.valueOf(singleOrder.getOrdStatusValue());
                                rowData[3] = orderReport.getReport().getExtAccntId().substring(0, orderReport.getReport().getExtAccntId().indexOf("_"));
                                rowData[4] = singleOrder.getInstrument().getSecurityId();
                                rowData[5] = String.valueOf(singleOrder.getSide().getNumber());
                                rowData[6] = this.sDFQty.format(singleOrder.getOrderQty());
                                rowData[7] = this.sDFPrice.format(singleOrder.getPrice());
                                rowData[8] = String.valueOf(singleOrder.getOrdTypeValue());
                                rowData[9] = singleOrder.getExecMode().getEmId() == 999 ? "\u6587\u4ef6\u5355" : "\u975e\u6587\u4ef6\u5355";
                                rowData[10] = this.sDFQty.format(singleOrder.getCumQty());
                                rowData[11] = this.sDFPrice.format(singleOrder.getAvgPx());
                                PCcsExtra.CcsSingleOrderExtra ccs = (PCcsExtra.CcsSingleOrderExtra)singleOrder.getObject().unpack(PCcsExtra.CcsSingleOrderExtra.class);
                                rowData[12] = this.sDFQty.format(ccs.getWthQty());
                                rowData[13] = String.valueOf(singleOrder.getOrdDate()) + " " + singleOrder.getOrdTime();
                                rowData[14] = String.valueOf(ccs.getErrCode());
                                rowData[15] = this.transferErrInfo(ccs);
                                rowData[16] = DateTimeUtils.getTimeStamp();
                                writer.addRecord(rowData);
                                writer.write();
                            }
                            catch (Exception oe) {
                                logger.error("order status \u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)oe);
                                writer.close();
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            writer.close();
                            throw throwable;
                        }
                        writer.close();
                    }
                }
                if (dealReport == null) break block16;
                try (DBFWriter dealWriter = new DBFWriter(dealFile);){
                    try {
                        dealWriter.setCharactersetName("GB2312");
                        rowData = new String[12];
                        POrderService.Execution execution = dealReport.getReport().getExecution();
                        rowData[0] = execution.getSysOrderId();
                        rowData[1] = dealReport.getReport().getClOrdId().substring(dealReport.getReport().getClOrdId().lastIndexOf("|") + 1);
                        rowData[2] = dealReport.getReport().getExtAccntId().substring(0, orderReport.getReport().getExtAccntId().indexOf("_"));
                        rowData[3] = execution.getInstrument().getSecurityId();
                        rowData[4] = execution.getInstrument().getSymbol();
                        rowData[5] = execution.getInstrument().getMarket();
                        rowData[6] = String.valueOf(execution.getSide().getNumber());
                        rowData[7] = this.sDFAmount.format(execution.getLastAmount());
                        rowData[8] = this.sDFPrice.format(execution.getLastPx());
                        rowData[9] = String.valueOf(execution.getExecDate()) + " " + execution.getExecTime();
                        rowData[10] = this.sDFQty.format(execution.getLastQty());
                        rowData[11] = this.sDFAmount.format(execution.getExecFee());
                        dealWriter.addRecord(rowData);
                        dealWriter.write();
                    }
                    catch (Exception de) {
                        logger.error("deal\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)de);
                        dealWriter.close();
                    }
                }
            }
            catch (Exception e2) {
                logger.error("[" + uuid + "]", (Throwable)e2);
                this.reportMessage(" \u5199\u56de\u62a5\u6587\u4ef6\u5931\u8d25\uff0c" + e2.getMessage());
            }
        }
    }

    private String transferErrInfo(PCcsExtra.CcsSingleOrderExtra en) {
        String errorInfo = "";
        errorInfo = 1 != en.getErrCode() && !StringUtils.isEmpty((String)en.getErrInfo()) ? String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09" : String.valueOf(errorInfo) + en.getErrInfo();
        if (1 != en.getWthErrCode() && !StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + en.getWthErrInfo() + "\uff09";
        }
        return errorInfo;
    }

    private synchronized void onFileOutput(List<MEvent> events, boolean isRes) {
        System.nanoTime();
        try {
            System.nanoTime();
            String respath = this.eCore.getStr("dbf.monitor.res.req.folder");
            File resFolder = new File(respath);
            logger.info("\u4e8b\u4ef6\u7684\u5de5\u4f5c\u6a21\u5f0f[\u76d1\u542c\u6a21\u5f0f]\uff0c\u5f00\u59cb\u5904\u7406\u5199\u5165\u6587\u4ef6    : " + resFolder.getPath());
            if (!resFolder.exists()) {
                logger.error(" \u56de\u62a5\u76ee\u5f55\u672a\u521b\u5efa  \uff01");
                this.reportMessage("\u4e0d\u5b58\u5728\u7684\u56de\u62a5\u76ee\u5f55[" + resFolder.getPath() + "]");
                return;
            }
            this.eCore.getStr("dbf.monitor.rec.req.folder");
            Path orderPath = Paths.get(resFolder.getAbsolutePath(), "OrderStatus.dbf");
            File orderFile = orderPath.toFile();
            Path dealPath = Paths.get(resFolder.getAbsolutePath(), "Deal.dbf");
            File dealFile = dealPath.toFile();
            DBFWriter ordWriter = new DBFWriter(orderFile);
            DBFWriter dealWriter = new DBFWriter(dealFile);
            for (MEvent event : events) {
                Object[] rowData;
                ExecutionReport orderReport = (ExecutionReport)event.get("dbf.order.report", ExecutionReport.class);
                ExecutionReport dealReport = (ExecutionReport)event.get("dbf.deal.report", ExecutionReport.class);
                if (orderReport != null) {
                    ordWriter.setCharactersetName("GB2312");
                    try {
                        rowData = new String[17];
                        POrderService.SingleOrder singleOrder = orderReport.getReport().getSingleOrder();
                        rowData[0] = singleOrder.getSysOrderId();
                        rowData[1] = singleOrder.getClOrdId().substring(singleOrder.getClOrdId().lastIndexOf("|") + 1);
                        rowData[2] = String.valueOf(singleOrder.getOrdStatusValue());
                        rowData[3] = orderReport.getReport().getExtAccntId().substring(0, orderReport.getReport().getExtAccntId().indexOf("_"));
                        rowData[4] = singleOrder.getInstrument().getSecurityId();
                        rowData[5] = String.valueOf(singleOrder.getSide().getNumber());
                        rowData[6] = this.sDFQty.format(singleOrder.getOrderQty());
                        rowData[7] = this.sDFPrice.format(singleOrder.getPrice());
                        rowData[8] = String.valueOf(singleOrder.getOrdTypeValue());
                        rowData[9] = singleOrder.getExecMode().getEmId() == 999 ? "\u6587\u4ef6\u5355" : "\u975e\u6587\u4ef6\u5355";
                        rowData[10] = this.sDFQty.format(singleOrder.getCumQty());
                        rowData[11] = this.sDFPrice.format(singleOrder.getAvgPx());
                        PCcsExtra.CcsSingleOrderExtra ccs = (PCcsExtra.CcsSingleOrderExtra)singleOrder.getObject().unpack(PCcsExtra.CcsSingleOrderExtra.class);
                        rowData[12] = this.sDFQty.format(ccs.getWthQty());
                        rowData[13] = String.valueOf(singleOrder.getOrdDate()) + " " + singleOrder.getOrdTime();
                        rowData[14] = String.valueOf(ccs.getErrCode());
                        rowData[15] = this.transferErrInfo(ccs);
                        rowData[16] = DateTimeUtils.getTimeStamp();
                        ordWriter.addRecord(rowData);
                        ordWriter.write();
                    }
                    finally {
                        ordWriter.close();
                    }
                }
                if (dealReport == null) continue;
                try {
                    dealWriter.setCharactersetName("GB2312");
                    rowData = new String[12];
                    POrderService.Execution execution = dealReport.getReport().getExecution();
                    rowData[0] = execution.getSysOrderId();
                    rowData[1] = dealReport.getReport().getClOrdId().substring(dealReport.getReport().getClOrdId().lastIndexOf("|") + 1);
                    rowData[2] = dealReport.getReport().getExtAccntId().substring(0, orderReport.getReport().getExtAccntId().indexOf("_"));
                    rowData[3] = execution.getInstrument().getSecurityId();
                    rowData[4] = execution.getInstrument().getSymbol();
                    rowData[5] = execution.getInstrument().getMarket();
                    rowData[6] = String.valueOf(execution.getSide().getNumber());
                    rowData[7] = this.sDFAmount.format(execution.getLastAmount());
                    rowData[8] = this.sDFPrice.format(execution.getLastPx());
                    rowData[9] = String.valueOf(execution.getExecDate()) + " " + execution.getExecTime();
                    rowData[10] = this.sDFQty.format(execution.getLastQty());
                    rowData[11] = this.sDFAmount.format(execution.getExecFee());
                    dealWriter.addRecord(rowData);
                    dealWriter.write();
                }
                finally {
                    dealWriter.close();
                }
            }
        }
        catch (Exception e2) {
            logger.error("\u5199\u56de\u62a5\u6587\u4ef6\u5931\u8d25", (Throwable)e2);
            this.reportMessage(" \u5199\u56de\u62a5\u6587\u4ef6\u5931\u8d25\uff0c" + e2.getMessage());
        }
    }

    private void reportMessage(String content) {
        MEvent event = new MEvent();
        event.setDesc(content);
        this.es.postEvent("message.log", event);
    }

    private void buildEntrustCancelReport(MEvent event, ExecutionReport report) {
        if (report.getReport().hasSingleOrder()) {
            event.put((Object)"dbf.order.report", (Object)report);
        }
        if (report.getReport().hasExecution()) {
            event.put((Object)"dbf.deal.report", (Object)report);
        }
        this.receiveCallBack(event, report, 630952);
    }

    private void buildEntrustRejectReport(MEvent event, ExecutionReport report) {
        if (report.getReport().hasSingleOrder()) {
            event.put((Object)"dbf.order.report", (Object)report);
        }
        if (report.getReport().hasExecution()) {
            event.put((Object)"dbf.deal.report", (Object)report);
        }
        this.receiveCallBack(event, report, 630952);
    }

    private void buildEntrustConfirmReport(MEvent event, ExecutionReport report) {
        if (report.getReport().hasSingleOrder()) {
            event.put((Object)"dbf.order.report", (Object)report);
        }
        if (report.getReport().hasExecution()) {
            event.put((Object)"dbf.deal.report", (Object)report);
        }
        this.receiveCallBack(event, report, 630952);
    }

    private void buildEntrustDoneReport(MEvent event, ExecutionReport report) {
        if (report.getReport().hasSingleOrder()) {
            event.put((Object)"dbf.order.report", (Object)report);
        }
        if (report.getReport().hasExecution()) {
            event.put((Object)"dbf.deal.report", (Object)report);
        }
        this.receiveCallBack(event, report, 630952);
    }

    public static AtomicBoolean getHasSub() {
        return hasSub;
    }

    public static void setHasSub(AtomicBoolean hasSub) {
        FileHander.hasSub = hasSub;
    }

    public boolean isFirstStart() {
        return this.firstStart;
    }

    public AtomicInteger getIndex() {
        return this.index;
    }

    public void setIndex(AtomicInteger index) {
        this.index = index;
    }

    public void setFirstStart(boolean firstStart) {
        this.firstStart = firstStart;
    }

    static /* synthetic */ void access$0(FileHander fileHander, MEvent mEvent) {
        fileHander.onFileOperationEnd(mEvent);
    }

    static /* synthetic */ TradeApi access$1(FileHander fileHander) {
        return fileHander.tradeApi;
    }

    static /* synthetic */ Logger access$2() {
        return logger;
    }
}

