/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils;

import cms.tmx.file.dbf.utils.Util;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Field {
    private String name;
    private int length;
    private int decimal;
    private char type;
    private byte flag;
    private int displacement;
    private ByteBuffer buffer;
    private String stringValue;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public char getType() {
        return this.type;
    }

    public void setType(char type) {
        this.type = type;
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public int getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(int displacement) {
        this.displacement = displacement;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public byte[] getBytesValue() {
        return this.buffer.array();
    }

    public String getStringValue() throws UnsupportedEncodingException {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Integer getIntValue() throws UnsupportedEncodingException {
        if ("-".equals(this.getStringValue())) {
            return null;
        }
        return Integer.parseInt(this.getStringValue());
    }

    public Double getDoubleValue() throws UnsupportedEncodingException {
        if ("-".equals(this.getStringValue())) {
            return null;
        }
        return Double.parseDouble(this.getStringValue());
    }

    public Float getFloatValue() throws UnsupportedEncodingException {
        if ("-".endsWith(this.getStringValue())) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(this.getStringValue()));
    }

    public Boolean getBooleanValue() throws UnsupportedEncodingException {
        String value = this.getStringValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        return Util.getBooleanValue(value);
    }

    public Date getDateValue() throws ParseException, UnsupportedEncodingException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.parse(this.getStringValue());
    }
}

