/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.utils;

import cms.tmx.file.dbf.utils.Field;
import cms.tmx.file.dbf.utils.FoxproDBaseWriter;
import cms.tmx.file.dbf.utils.Writer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public abstract class DbfWriter
implements Writer {
    public static final int HEADER_END_CHAR = 13;
    protected List<Field> fields;
    protected ByteArrayOutputStream bodybuffer = new ByteArrayOutputStream();
    protected ByteArrayOutputStream headbuffer = new ByteArrayOutputStream();
    private String encode = "GBK";
    private String filename;
    private int position = 0;

    public static Writer generate(String filename, String encode) {
        FoxproDBaseWriter writer = new FoxproDBaseWriter();
        writer.setFilename(filename);
        return writer;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getEncode() {
        return this.encode;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    @Override
    public void save() throws IOException {
        this.writeHeaders();
        FileOutputStream dbffos = new FileOutputStream(new File(this.filename));
        byte[] bodybytearray = this.bodybuffer.toByteArray();
        this.headbuffer.write(bodybytearray, 0, bodybytearray.length);
        this.headbuffer.writeTo(dbffos);
        this.headbuffer.close();
        this.bodybuffer.close();
        dbffos.close();
    }

    @Override
    public abstract void writeFields(List<Field> var1) throws IOException;

    @Override
    public abstract void writeRecord(String ... var1) throws IOException, NullPointerException;

    protected abstract void writeHeaders() throws IOException;

    protected void next() {
        ++this.position;
    }

    protected int getPostion() {
        return this.position;
    }
}

