/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.entity;

import cms.tmx.core.MEvent;
import cms.tmx.file.dbf.entity.RecordUpdateEvent;
import cms.tmx.file.dbf.utils.TimeUtils;
import cms.tmx.javafx.obj.MxChgObj;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DocScanAndOrderRecord
extends MxChgObj {
    private StringProperty uuid = new SimpleStringProperty("");
    private StringProperty fileName = new SimpleStringProperty("");
    private StringProperty startTime = new SimpleStringProperty("");
    private StringProperty endTime = new SimpleStringProperty("");
    private IntegerProperty sucCount = new SimpleIntegerProperty(0);
    private IntegerProperty errorCount = new SimpleIntegerProperty(0);
    private IntegerProperty failCount = new SimpleIntegerProperty(0);
    private IntegerProperty sum = new SimpleIntegerProperty(0);

    public void update(Object t) {
        if (t instanceof MEvent) {
            MEvent event = (MEvent)MEvent.class.cast(t);
            this.update(event);
        }
    }

    public void update(RecordUpdateEvent event) {
        switch (event.getUpdateType()) {
            case CHECK_ERROR: {
                this.setErrorCount(this.getErrorCount() + event.getCheckErrorCount());
                break;
            }
            case SUCCESS: {
                this.setSucCount(this.getSucCount() + event.getSuccessCount());
                break;
            }
            case FAILED: {
                this.setFailCount(this.getFailCount() + event.getFailedCount());
                break;
            }
            case END_TIME: {
                this.setEndTime(event.getEndTime());
                break;
            }
        }
    }

    public void update(MEvent event) {
        String startTime = TimeUtils.format(event.getLong("file.manipulate.record.start.time"), "yyyy-MM-dd HH:mm:ss:SSS");
        long middle = event.getLong("file.manipulate.record.end.time") == 0L ? System.currentTimeMillis() : event.getLong("file.manipulate.record.end.time");
        String endTime = TimeUtils.format(middle, "yyyy-MM-dd HH:mm:ss:SSS");
        this.setUuid(event.getStr("file.manipulate.record.uuid"));
        this.setFileName(event.getStr("file.name"));
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setSucCount(event.getInt("file.manipulate.record.succ.count"));
        this.setErrorCount(event.getInt("file.manipulate.record.error.count"));
        this.setFailCount(event.getInt("file.manipulate.record.fail.count"));
        this.setSum(this.getSucCount() + this.getFailCount());
    }

    public void update(long startTime, long endTime, Integer sucCount, Integer failCount, Integer errorCount, Integer sum) {
        String start = TimeUtils.format(startTime, "yyyy-MM-dd HH:mm:ss:SSS");
        long middle = endTime == 0L ? System.currentTimeMillis() : endTime;
        String end = TimeUtils.format(middle, "yyyy-MM-dd HH:mm:ss:SSS");
        this.startTime.set((Object)start);
        this.endTime.set((Object)end);
        this.sucCount.set(sucCount.intValue());
        this.failCount.set(failCount.intValue());
        this.errorCount.set(errorCount.intValue());
        this.sum.set(sum.intValue());
    }

    public DocScanAndOrderRecord() {
    }

    public DocScanAndOrderRecord(String uuid, String fileName, String startTime, String endTime, Integer sucCount, Integer failCount, Integer errorCount, Integer sum) {
        this.setUuid(uuid);
        this.fileName.set((Object)fileName);
        this.startTime.set((Object)startTime);
        this.endTime.set((Object)endTime);
        this.sucCount.set(sucCount.intValue());
        this.failCount.set(failCount.intValue());
        this.errorCount.set(errorCount.intValue());
        this.sum.set(sum.intValue());
    }

    public final StringProperty fileNameProperty() {
        return this.fileName;
    }

    public final String getFileName() {
        return (String)this.fileNameProperty().get();
    }

    public final void setFileName(String fileName) {
        this.fileNameProperty().set((Object)fileName);
    }

    public final StringProperty startTimeProperty() {
        return this.startTime;
    }

    public final String getStartTime() {
        return (String)this.startTimeProperty().get();
    }

    public final void setStartTime(String startTime) {
        this.startTimeProperty().set((Object)startTime);
    }

    public final StringProperty endTimeProperty() {
        return this.endTime;
    }

    public final String getEndTime() {
        return (String)this.endTimeProperty().get();
    }

    public final void setEndTime(String endTime) {
        this.endTimeProperty().set((Object)endTime);
    }

    public final IntegerProperty sucCountProperty() {
        return this.sucCount;
    }

    public final int getSucCount() {
        return this.sucCountProperty().get();
    }

    public final void setSucCount(int sucCount) {
        this.sucCountProperty().set(sucCount);
    }

    public final IntegerProperty failCountProperty() {
        return this.failCount;
    }

    public final int getFailCount() {
        return this.failCountProperty().get();
    }

    public final void setFailCount(int failCount) {
        this.failCountProperty().set(failCount);
    }

    public final IntegerProperty sumProperty() {
        return this.sum;
    }

    public final int getSum() {
        return this.sumProperty().get();
    }

    public final void setSum(int sum) {
        this.sumProperty().set(sum);
    }

    public final IntegerProperty errorCountProperty() {
        return this.errorCount;
    }

    public final int getErrorCount() {
        return this.errorCountProperty().get();
    }

    public final void setErrorCount(int errorCount) {
        this.errorCountProperty().set(errorCount);
    }

    public boolean equals(Object obj) {
        DocScanAndOrderRecord doc = (DocScanAndOrderRecord)((Object)DocScanAndOrderRecord.class.cast(obj));
        return this.getUuid().equals(doc.getUuid());
    }

    public final StringProperty uuidProperty() {
        return this.uuid;
    }

    public final String getUuid() {
        return (String)this.uuidProperty().get();
    }

    public final void setUuid(String uuid) {
        this.uuidProperty().set((Object)uuid);
    }
}

