/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.api;

import cms.tmx.api.basket.IBasketCancelOrderApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.file.dbf.entity.DbfOrder;
import cms.tmx.file.dbf.entity.OrderRecord;
import cms.tmx.file.dbf.entity.RecordUpdateEvent;
import cms.tmx.file.dbf.utils.RegexUtils;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.trade.entrust.BatchEntrust;
import cms.tmx.utils.ListUtils;
import cmx.tmx.data.IRefDataMng;
import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.lang.UUID;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TradeApi {
    @Inject
    private IBaseApi apiBase;
    @Inject
    protected IRefDataMng refMng;
    private AtomicInteger count = new AtomicInteger(0);
    @Inject
    private INewOrderSingleApi apiOrder;
    @Inject
    private ICancelOrderApi cancelApi;
    @Inject
    private CcsAccountMap map;
    @Inject
    private MEventService es;
    @Inject
    private BatchEntrust batchEn;
    @Inject
    private MObjFactory of;
    @Inject
    private IBasketCancelOrderApi bsktCancelApi;
    @Inject
    private static IDictMap dmap;
    @Inject
    protected IAccountService accountService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    protected PortfolioAccountModel portfolioAccountModel;
    private Set<String> clientIdSet = new ConcurrentHashSet();
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private ConcurrentHashMap<String, OrderRecord> fileorderMap = new ConcurrentHashMap();
    private static final Logger logger;
    private static int PAR_VALUE;
    protected Message message = null;

    static {
        logger = LogManager.getLogger(TradeApi.class);
        PAR_VALUE = 100;
    }

    public void batchEntrust(List<DbfOrder> orders, String uuid) throws MException {
        List batchList = orders.stream().filter(val -> "order".equals(val.getType().toLowerCase())).collect(Collectors.toList());
        List cancelList = orders.stream().filter(val -> "cancel".equals(val.getType().toLowerCase())).collect(Collectors.toList());
        List errList = orders.stream().filter(val -> !"cancel".equals(val.getType().toLowerCase()) && !"order".equals(val.getType().toLowerCase())).collect(Collectors.toList());
        if (!batchList.isEmpty()) {
            logger.error("\u6279\u91cf\u4e0b\u5355\u5f00\u59cb,size:" + batchList.size() + " uuid:");
            Map<String, List<DbfOrder>> insMap = batchList.stream().collect(Collectors.groupingBy(t -> t.getInvestId()));
            for (Map.Entry<String, List<DbfOrder>> entry : insMap.entrySet()) {
                List averageAssign = ListUtils.split(entry.getValue(), (int)30);
                for (List obInsList : averageAssign) {
                    this.fixedPool.execute(() -> {
                        try {
                            this.batchOrderByPage((String)entry.getKey(), obInsList, uuid);
                        }
                        catch (MException e) {
                            logger.error("\u6279\u91cf\u6267\u884c\u5931\u8d25", (Throwable)e);
                            this.sendMsgSuccess(RecordUpdateEvent.UpdateType.FAILED, uuid, obInsList.size());
                        }
                    });
                }
            }
        }
        if (!cancelList.isEmpty()) {
            logger.error("\u6279\u91cf\u64a4\u5355\u5f00\u59cb,size:" + cancelList.size() + " uuid:");
            for (DbfOrder dbfOrder : cancelList) {
                this.fixedPool.execute(() -> {
                    try {
                        this.cancelOrderSingle(dbfOrder);
                        this.sendMsgSuccess(RecordUpdateEvent.UpdateType.SUCCESS, uuid, 1);
                    }
                    catch (MException | Exception e) {
                        logger.error("\u64a4\u5355\u6267\u884c\u5931\u8d25", e);
                        this.sendMsgSuccess(RecordUpdateEvent.UpdateType.FAILED, uuid, 1);
                    }
                });
            }
        }
        this.sendMsgSuccess(RecordUpdateEvent.UpdateType.FAILED, uuid, errList.size());
    }

    private void sendMsgSuccess(RecordUpdateEvent.UpdateType updateType, String uuid, int count) {
        MEvent e = new MEvent();
        RecordUpdateEvent event = new RecordUpdateEvent();
        event.setUuid(uuid);
        event.setUpdateType(updateType);
        event.setCount(count);
        e.setObj((Object)event);
        this.es.sendEvent("dbf/file/request/update", e);
        logger.info("[" + uuid + "]" + "\u8bb0\u5f55\u66f4\u65b0\u5230\u754c\u9762\u5b8c\u6210\uff01 ");
    }

    void batchOrderByPage(String accountId, List<DbfOrder> orders, String uuid) throws MException {
        PMessage.NewOrderBatchRequest.Builder nob = PMessage.NewOrderBatchRequest.newBuilder();
        PComponent.Instrument.Builder pi = PComponent.Instrument.newBuilder();
        String reqUuid = UUID.randomUUID().toString();
        pi.setMarketGroup("CCS");
        nob.setInstrument(pi.build());
        nob.setExtAccntId(String.valueOf(this.count.incrementAndGet()));
        nob.setOpUser(this.apiBase.getOpUser());
        for (DbfOrder order : orders) {
            if (!RegexUtils.isCLIENT_SEQ(order.getClOrdId()) && !order.getClOrdId().isEmpty()) {
                this.sendErrMsgLog(-1, "\u524d\u7aef\u6d41\u6c34\u53f7:" + order.getClOrdId() + " \u683c\u5f0f\u6821\u9a8c\u4e0d\u901a\u8fc7");
                continue;
            }
            if (!order.getClOrdId().isEmpty() && this.clientIdSet.contains(order.getClOrdId())) {
                this.sendErrMsgLog(-1, "\u524d\u7aef\u6d41\u6c34\u53f7:" + order.getClOrdId() + " \u4e0d\u53ef\u91cd\u590d\u59d4\u6258");
                continue;
            }
            this.clientIdSet.add(order.getClOrdId());
            String market = order.getMarket();
            double price = Double.valueOf(order.getPrice());
            int bstype = Integer.valueOf(order.getSide());
            String secCode = order.getSecurity();
            String investorId = order.getInvestId();
            String investorSecId = order.getInvestorSecId();
            long count = Long.valueOf(order.getQuantity());
            if (count <= 0L) {
                logger.error(String.valueOf(secCode) + "|" + market + "\u4e70\u5165\u6570\u91cf\u4e3a0");
                continue;
            }
            RefItem item = this.refMng.getItem(market, secCode);
            PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
            builderI.setSecurityId(secCode);
            builderI.setMarket(market);
            if (item != null) {
                builderI.setSecurityType(item.getType());
            }
            if ("XSHG".equals(market) && secCode.startsWith("688")) {
                builderI.setApplId("700");
            } else if (item != null && item.isGem()) {
                builderI.setApplId("GEM");
            } else {
                builderI.setApplId("010");
            }
            builderI.setMarketGroup("CCS");
            PComponent.Instrument instrument = builderI.build();
            PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
            builderO.setInstrument(instrument);
            builderO.setOrdTypeValue(50);
            builderO.setSideValue(bstype);
            builderO.setOpUser(this.apiBase.getOpUser());
            builderO.setOrderQty((double)count);
            builderO.setPrice(price);
            PComponent.ExecMode.Builder eb = PComponent.ExecMode.newBuilder();
            eb.setEmId(999);
            builderO.setExecMode(eb.build());
            String clOrderId = "file|" + investorId + "|" + order.getClOrdId();
            builderO.setClOrdId(clOrderId);
            CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
            SecAccount secAcc = this.map.getSecAcc(investorSecId, market);
            if (fundAcc == null) {
                this.sendErrMsgLog(-1, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
                continue;
            }
            builderO.setExtAccntId(fundAcc.getExtAccntId());
            if (secAcc == null) {
                this.sendErrMsgLog(-1, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                continue;
            }
            if (!secAcc.getExtAccntId().equals(fundAcc.getExtAccntId())) {
                this.sendErrMsgLog(-1, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + "\u4e0e\u8d44\u91d1\u8d26\u53f7:" + investorId + "\u4e0d\u5339\u914d");
                continue;
            }
            builderO.setExtSecAccntId(secAcc.getExtSecAccntId());
            builderO.setBatchId(reqUuid);
            PMessage.NewOrderSingle newOrd = builderO.build();
            nob.addOrders(newOrd);
        }
        if (!nob.getOrdersList().isEmpty()) {
            if (nob.getOrdersList().size() < orders.size()) {
                this.sendMsgSuccess(RecordUpdateEvent.UpdateType.CHECK_ERROR, uuid, orders.size() - nob.getOrdersList().size());
            }
            this.apiOrder.batchSubmit(nob.build());
            this.sendMsgSuccess(RecordUpdateEvent.UpdateType.SUCCESS, uuid, nob.getOrdersList().size());
        } else {
            this.sendErrMsgLog(-1, "\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8ba2\u5355\u59d4\u6258");
            this.sendMsgSuccess(RecordUpdateEvent.UpdateType.FAILED, uuid, orders.size());
        }
    }

    public void cancelOrderSingle(DbfOrder order) throws MException {
        String investorId = order.getInvestId();
        String orderId = order.getSysOrdId();
        String client_seq = order.getClOrdId();
        PMessage.OrderCancelRequest.Builder builder = PMessage.OrderCancelRequest.newBuilder();
        builder.setOpUser(this.apiBase.getOpUser());
        builder.setOrderId(orderId);
        client_seq = "file|" + investorId + "|" + client_seq;
        builder.setOrderId(orderId);
        builder.setOrigClOrdId(client_seq);
        builder.setClOrdId(client_seq);
        PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
        inst.setApplId("010");
        inst.setMarketGroup("CCS");
        inst.setMarket("XSHG");
        CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            MEvent event = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650");
            this.es.postEvent("message.log", event);
            return;
        }
        builder.setExtAccntId(fundAcc.getExtAccntId());
        builder.setInstrument(inst);
        this.cancelApi.submit(builder.build());
    }

    private void sendErrMsgLog(int code, String message) {
        MEvent me = new MEvent();
        me.setCode(code);
        me.setDesc(message);
        this.es.postEvent("message.log", me);
    }
}

