/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.dbf.api;

import cms.tmx.api.CallApi;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.Position;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.utils.QueryByPage;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PositionApi
extends CallApi {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private CcsAccountMap map;
    @Inject
    private MEventService es;
    @Inject
    protected MObjFactory of;
    @Inject
    protected PositionFactory fPosition;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private TradeServiceDefines.QueryServiceDefine queryService;
    private static final Logger logger = LogManager.getLogger(PositionApi.class);

    public Set<Position> queryPositions(FundAccount fund) throws MException {
        Set<Position> setPosition = Collections.synchronizedSet(new HashSet());
        QueryByPage query = (QueryByPage)this.of.create(QueryByPage.class);
        query.queryByPage(page -> {
            this.queryPositionsInTurn((IPageInTurn<String, String, PPositionService.ExtPosition>)page, fund.getInvestId());
            this.transferPosition(setPosition, (IPageInTurn<String, String, PPositionService.ExtPosition>)page, fund.getInvestId());
        });
        return setPosition;
    }

    private void queryPositionsInTurn(IPageInTurn<String, String, PPositionService.ExtPosition> page, String investorId) {
        if (page.getResList() == null) {
            page.setResList(new LinkedList());
        }
        try {
            MEvent event = new MEvent();
            int pageSize = 150;
            pageSize = 150;
            PPositionService.GetExtPositionsReq.Builder builder = PPositionService.GetExtPositionsReq.newBuilder();
            builder.setOpUser(this.baseApi.getOpUser());
            builder.setMarketGrp("CCS");
            PField.PositionSettingType set = PField.PositionSettingType.forNumber((int)1);
            builder.setSettingType(set);
            CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
            if (fundAcc == null) {
                logger.error("dbf\u6301\u4ed3\u5bfc\u51fa\uff0c\u5ba2\u6237\u53f7:" + investorId + " \u65e0\u6743\u9650\u6216\u65e0\u80a1\u4e1c\u4ee3\u7801");
                return;
            }
            builder.setExtAccntId(fundAcc.getExtAccntId());
            page.setPageSize(pageSize);
            PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
            pageBuilder.setPageSize(page.getPageSize());
            pageBuilder.setStartRow(page.getStartRow());
            builder.setPage(pageBuilder.build());
            event.setObj((Object)builder.build());
            this.action((IServiceDefine)this.queryService, "256", event);
            PPositionService.GetExtPositionsResp resp = (PPositionService.GetExtPositionsResp)event.getObj(PPositionService.GetExtPositionsResp.class);
            this.checkStatus(resp.getStatus());
            page.getResList().addAll(resp.getPositionList());
            page.setTotalRow(resp.getPage().getTotalRow());
        }
        catch (MException e1) {
            logger.error("630004\u6301\u4ed3\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
        }
    }

    private void transferPosition(Set<Position> setPosition, IPageInTurn<String, String, PPositionService.ExtPosition> page, String investorId) {
        for (PPositionService.ExtPosition pPosition : page.getResList()) {
            Position position = this.fPosition.create(pPosition);
            if (position == null) continue;
            position.setInvestorId(investorId);
            position.setInverstorSecId(position.getExtSecAccId().split("_")[0]);
            setPosition.add(position);
        }
    }
}

