/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.define.imp;

import cms.tmx.define.IDictMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DictMapImp
implements IDictMap {
    private static final Logger logger = LogManager.getLogger(DictMapImp.class);
    private Map<String, Map<String, String>> mapDict = new LinkedHashMap<String, Map<String, String>>();
    private static final String DICTMAP_PATH = "/dictmap.csv";
    private static final int INIT_MAP_CAP = 300;
    @Inject
    private ExecutorService exe;

    @PostConstruct
    public void init() {
        this.exe.execute(() -> this.loadDictMap(this.getClass(), DICTMAP_PATH));
    }

    @Override
    public void loadDictMap(Class<?> clazz, String path) {
        try {
            InputStream is = clazz.getResourceAsStream(path);
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader bReader = new BufferedReader(reader);
            String line = bReader.readLine();
            while (line != null) {
                String rawLine = line.trim();
                if (rawLine.isEmpty()) {
                    line = bReader.readLine();
                    continue;
                }
                String key = null;
                String code = null;
                String desc = null;
                String[] values = rawLine.split(",");
                int i = 0;
                while (i < values.length) {
                    String value = values[i].trim();
                    switch (i) {
                        case 0: {
                            key = value;
                            break;
                        }
                        case 1: {
                            code = value;
                            break;
                        }
                        case 2: {
                            desc = value;
                            break;
                        }
                    }
                    ++i;
                }
                if (key != null && code != null && desc != null) {
                    Map<String, String> map = this.mapDict.get(key);
                    if (map == null) {
                        map = new LinkedHashMap<String, String>(300);
                        this.mapDict.put(key, map);
                    }
                    map.put(code, desc);
                }
                line = bReader.readLine();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> get(String word) {
        return this.mapDict.get(word);
    }

    @Override
    public String get(String word, String code) {
        Map<String, String> map = this.mapDict.get(word);
        return map == null ? "" : map.get(code);
    }

    @Override
    public String get(String key, int code) {
        return this.get(key, String.valueOf(code));
    }
}

