/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.manage.models.PersonalFuncModel;
import cms.tmx.rights.IRightService;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class addPersonalFuncDialog
extends DialogObj {
    @FXML
    private TreeTableColumn<FuncModule, Boolean> colFunction;
    @FXML
    private TreeTableColumn<FuncModule, Boolean> isSelected;
    @FXML
    private TreeTableView<FuncModule> treeTableFunc;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveRights;
    @Inject
    private IRightService irs;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService right;
    @Inject
    private PersonalFuncModel model;
    private static final Logger logger = LogManager.getLogger(addPersonalFuncDialog.class);
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private FuncModule funcModule;
    private BooleanProperty save = new SimpleBooleanProperty(false);
    Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)5000.0), e -> {
        this.labSuccess.setVisible(false);
        this.btnSaveRights.setDisable(false);
    }, new KeyValue[0])});

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.right.registerCheck(new String[]{"updateAssignRoleControl"})));
        this.exe.execute(() -> {
            this.initRoot();
            this.createTableView();
        });
    }

    private void initRoot() {
        block5: {
            try {
                try {
                    this.treeTableFunc.setRoot(this.model.getRoot());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeTableFunc.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeTableFunc.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeTableFunc.refresh());
        }
    }

    private void createTableView() {
        this.isSelected.setCellValueFactory(cellDate -> ((FuncModule)cellDate.getValue().getValue()).selectedProperty());
        this.isSelected.setCellFactory(cellDate -> new MxCheckBoxTreeTableCell());
        this.colFunction.setCellFactory(cellDate -> new MxFuncCheckBoxTreeTableCell());
    }

    @FXML
    public boolean saveRights() {
        try {
            this.model.addStatisticMenuReq((TreeItem<FuncModule>)this.treeTableFunc.getRoot());
        }
        catch (MException e) {
            logger.error("add statistic func faild:", (Throwable)e);
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            return false;
        }
        this.btnSaveRights.setDisable(true);
        this.labSuccess.setVisible(true);
        this.animation.setCycleCount(1);
        this.animation.setAutoReverse(false);
        this.animation.play();
        return true;
    }

    public FuncModule getFuncModule() {
        return this.funcModule;
    }

    public void setFuncModule(FuncModule funcModule) {
        this.funcModule = funcModule;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private void sendMsgToWeb(String roleId) {
        if (!StringUtils.isEmpty((String)roleId)) {
            MEvent event = new MEvent();
            event.put((Object)"type", (Object)"role");
            event.put((Object)"id", (Object)roleId);
        }
    }

    private class MxCheckBoxTreeTableCell<S, T>
    extends TreeTableCell<FuncModule, T> {
        FuncModule funcItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.funcItem = (FuncModule)this.getTreeTableRow().getItem();
                if (this.funcItem == null) {
                    return;
                }
                this.checkbox = new CheckBox();
                this.checkbox.selectedProperty().bindBidirectional((Property)this.funcItem.selectedProperty());
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.checkbox.selectedProperty().get()));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!addPersonalFuncDialog.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{addPersonalFuncDialog.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Boolean selected) {
            addPersonalFuncDialog.this.save.set(true);
            if (selected.booleanValue()) {
                this.selectChdItems((TreeItem<FuncModule>)this.getTreeTableRow().getTreeItem(), true);
                this.selectPrtItems((TreeItem<FuncModule>)this.getTreeTableRow().getTreeItem(), true);
            } else {
                this.selectChdItems((TreeItem<FuncModule>)this.getTreeTableView().getTreeItem(this.getIndex()), false);
                this.selectPrtItems((TreeItem<FuncModule>)this.getTreeTableView().getTreeItem(this.getIndex()), false);
            }
        }

        private void selectChdItems(TreeItem<FuncModule> seleItem, Boolean selected) {
            if (seleItem.getChildren() != null) {
                seleItem.getChildren().forEach(item -> {
                    ((FuncModule)item.getValue()).selectedProperty().set(selected.booleanValue());
                    if (!item.getChildren().isEmpty()) {
                        this.selectChdItems((TreeItem<FuncModule>)item, selected);
                    }
                });
            }
        }

        private void selectPrtItems(TreeItem<FuncModule> seleItem, Boolean selected) {
            if (seleItem != null) {
                TreeItem item = seleItem.getParent();
                if (item == null) {
                    return;
                }
                if (selected.booleanValue()) {
                    ((FuncModule)item.getValue()).selectedProperty().set(selected.booleanValue());
                    this.selectPrtItems((TreeItem<FuncModule>)item, true);
                } else {
                    ObservableList brotheres = item.getChildren();
                    boolean flag = false;
                    for (TreeItem brother : brotheres) {
                        if (!((FuncModule)brother.getValue()).isSelected() || seleItem == brother) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ((FuncModule)item.getValue()).selectedProperty().set(false);
                        this.selectPrtItems((TreeItem<FuncModule>)item, false);
                    }
                }
            }
        }
    }

    private class MxFuncCheckBoxTreeTableCell<S, T>
    extends TreeTableCell<FuncModule, T> {
        private String text = "";
        Label label = null;
        FuncModule funcItem;
        private final PseudoClass leaf = PseudoClass.getPseudoClass((String)"treeLeaf");
        private final PseudoClass notLeaf = PseudoClass.getPseudoClass((String)"treeNotLeaf");

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.funcItem = (FuncModule)this.getTreeTableRow().getItem();
                if (this.funcItem == null) {
                    return;
                }
                this.text = this.funcItem.getName();
                this.label = new Label(this.text);
                this.setGraphic((Node)this.label);
                if (this.getTreeTableRow().getTreeItem().isLeaf()) {
                    this.getTreeTableRow().pseudoClassStateChanged(this.leaf, true);
                    this.getTreeTableRow().pseudoClassStateChanged(this.notLeaf, false);
                } else {
                    this.getTreeTableRow().pseudoClassStateChanged(this.notLeaf, true);
                    this.getTreeTableRow().pseudoClassStateChanged(this.leaf, false);
                }
            }
        }
    }
}

