/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.entity.User;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.models.UserMngModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserPrivilegeTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u7528\u6237\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Post> tablePost;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<Post, Boolean> selected;
    @FXML
    private TableColumn<Post, String> partyName;
    @FXML
    private TableColumn<Post, String> desc;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveRights;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private UserMngModel userMngModel;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private IUiRightService model;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    private Post selectTablePost;
    private Party selectTreeParty;
    private User selectUser;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private StringProperty sameParty = new SimpleStringProperty("");
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Post> mlist = new MxList();
    private List<Post> filterList = new LinkedList<Post>();
    private static final Logger logger = LogManager.getLogger(UserPrivilegeTabContent.class);
    private List<String> listPostId = new LinkedList<String>();
    private ObservableSet<String> setPostId = FXCollections.observableSet(new HashSet());
    private Predicate<Post> pd = post -> {
        String idName = this.txtSearch.getText().trim();
        return post.getName().contains(idName) || post.getId().contains(idName);
    };
    private InvalidationListener userModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tablePost.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectUser = this.userMngModel.getCommonUser();
        this.labSuccess.setVisible(false);
        this.canUpdate.setValue(Boolean.valueOf(this.model.registerCheck(new String[]{"updateUserRealtePostControl"})));
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.initDefaultValue();
        });
    }

    private void initDefaultValue() {
        TreeItem root = this.treeParty.getRoot();
        this.treeParty.getSelectionModel().select((Object)root);
        this.oldSelectParty = root;
        try {
            this.listPostId = this.postMng.getPostIdsByUser(this.selectUser.getId());
            this.setPostId.addAll(this.listPostId);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
        this.query(((Party)root.getValue()).getId());
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.userModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tablePost.setOnMouseClicked(event -> {
            if (this.tablePost.getSelectionModel().getSelectedItem() != null) {
                this.selectTablePost = (Post)this.tablePost.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        this.tablePost.setPlaceholder((Node)new Label());
        TableUtils.isAuto(this.index);
        TableUtils.initValueFactory(this.tablePost);
        this.selected.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.partyName.setCellValueFactory(cellData -> {
            String partyId = ((Post)cellData.getValue()).getPartyId();
            SimpleStringProperty flage = new SimpleStringProperty(this.partyTree.getParty(partyId).getName());
            return flage;
        });
        this.desc.setCellFactory(data -> new AutoTableCell());
        this.tablePost.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.setPostId.clear();
            this.setPostId.addAll(this.listPostId);
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<Post> listPost = new LinkedList<Post>();
            listPost.addAll(this.postMng.getPostList(partyId, true));
            this.filterList.clear();
            this.filterList.addAll(listPost);
            this.mlist.setAll(this.filterList);
            for (Post post : listPost) {
                if (!this.setPostId.contains((Object)post.getId())) continue;
                post.setSelected(true);
                this.sameParty.set((Object)post.getPartyId());
            }
            this.mlist.update(this.filterList, this.pd);
            if (this.selectTablePost == null) {
                return;
            }
            this.tablePost.getSelectionModel().select((Object)this.selectTablePost);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean saveRights() {
        try {
            this.save.set(false);
            this.userMng.assignUserToPostReq(this.selectUser.getId(), (Collection<String>)this.setPostId);
        }
        catch (MException e2) {
            this.mAlert.alert(Alert.AlertType.ERROR, e2.getMessage());
            logger.error((Object)e2, (Throwable)e2);
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public User getSelectUser() {
        return this.selectUser;
    }

    public void setSelectUser(User selecUser) {
        this.selectUser = selecUser;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class AutoTableCell<S, T>
    extends TableCell<Post, T> {
        Post post;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.post = (Post)Post.class.cast(this.getTableRow().getItem());
                if (this.post == null) {
                    return;
                }
                if (!this.post.getDesc().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.post.getDesc());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.post.getDesc());
            }
        }
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Post, T> {
        Post postItem;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                this.postItem = (Post)this.getTableRow().getItem();
                if (this.postItem == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.postItem));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!UserPrivilegeTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    if (((String)UserPrivilegeTabContent.this.sameParty.get()).isEmpty()) {
                        return false;
                    }
                    if (!((String)UserPrivilegeTabContent.this.sameParty.get()).equals(this.postItem.getPartyId())) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{UserPrivilegeTabContent.this.canUpdate, UserPrivilegeTabContent.this.sameParty}));
            }
        }

        private void checkBoxSelected(Post post) {
            UserPrivilegeTabContent.this.save.set(true);
            if (post.selectedProperty().get()) {
                UserPrivilegeTabContent.this.setPostId.add((Object)post.getId());
                UserPrivilegeTabContent.this.sameParty.set((Object)post.getPartyId());
            } else {
                UserPrivilegeTabContent.this.setPostId.remove((Object)post.getId());
                if (UserPrivilegeTabContent.this.setPostId.size() <= 0) {
                    UserPrivilegeTabContent.this.sameParty.set((Object)"");
                }
            }
        }
    }
}

