/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.User;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddUserDialog;
import cms.tmx.manage.parts.UpdateUserDialog;
import cms.tmx.manage.parts.UserLockDialog;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserMngPart
extends MxPart {
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<User> tableUser;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<User, String> creator;
    @FXML
    private TableColumn<User, String> updater;
    @FXML
    private TableColumn<User, String> colOpera;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @FXML
    private Button btnUserLock;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private PartyFactory pFactory;
    private User selectTableUser;
    private TreeItem<Party> selectTreeParty;
    private MxList<User> mlist = new MxList();
    private List<User> filterList = new LinkedList<User>();
    private static final Logger logger = LogManager.getLogger(UserMngPart.class);
    private static final String IS_ENABLE_USER = "\u662f\u5426\u542f\u7528\u8be5\u7528\u6237";
    private static final String IS_DISABLE_USER = "\u662f\u5426\u505c\u7528\u8be5\u7528\u6237";
    private static final String ALERT = "\u63d0\u793a";
    private Predicate<User> pd = user -> {
        String idName = this.txtSearch.getText().trim();
        return user.getUseCreditName().contains(idName) || user.getName().contains(idName);
    };
    private InvalidationListener searchListner = ob -> {
        this.mlist.filter(this.filterList, this.pd);
        this.tableUser.sort();
    };
    private boolean settingFlag = false;
    private boolean statusFlag = false;

    @FXML
    public void initialize() {
        TreeItem<Party> root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(root);
            this.query(((Party)root.getValue()).getId());
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    protected void afterTableRestore() {
        this.treeParty.getSelectionModel().select(0);
        this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryUserControl"});
        this.model.registerCheck((Control)this.btnUserLock, new String[]{"userLockControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addUserControl", "saveUserBasic"});
        this.statusFlag = this.model.registerCheck(new String[]{"enableUserControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"saveUserBasic", "lookUserBasic", "updateUserRealtePostControl", "queryUserRealtePostControl", "saveUserControl", "lookUserControl"});
        this.settingFlag = this.settingFlag && this.model.registerCheck(new String[]{"updateUserControl"});
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.searchListner);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableUser = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
        this.tableUser.setOnMouseClicked(event -> {
            if (this.tableUser.getSelectionModel().getSelectedItem() != null) {
                this.selectTableUser = (User)this.tableUser.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        this.addViwer(this.tableUser);
        this.tableUser.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableUser);
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((User)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((User)data.getValue()).getUpdater()));
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableUser));
        this.tableUser.setItems(this.mlist.getList());
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            LinkedList<String> listIds = new LinkedList<String>();
            listIds.addAll(this.userMng.getUserIds(partyId));
            if (listIds.isEmpty()) {
                this.mlist.clear();
                this.filterList.clear();
                return;
            }
            LinkedList<User> listUsers = new LinkedList<User>();
            listUsers.addAll(this.userMng.getUserList(listIds));
            this.filterList.clear();
            this.filterList.addAll(listUsers);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            if (this.partyMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId())) {
                this.treeParty.getSelectionModel().select(root);
            } else {
                this.treeParty.getSelectionModel().select(this.selectTreeParty);
            }
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tableUser.getSelectionModel().select((Object)this.selectTableUser);
            this.tableUser.scrollTo((Object)this.selectTableUser);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void refreshTable() {
        if (this.selectTreeParty == null) {
            return;
        }
        this.query(((Party)this.selectTreeParty.getValue()).getId());
        this.tableUser.getSelectionModel().select((Object)this.selectTableUser);
        this.tableUser.scrollTo((Object)this.selectTableUser);
    }

    @FXML
    public void add() {
        AddUserDialog obj = (AddUserDialog)((Object)this.of.create(AddUserDialog.class));
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u7528\u6237");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewUserId().isEmpty()) {
                String userId = obj.getNewUserId();
                this.selectTableUser = this.userMng.getUserDetail(userId);
                this.refreshTable();
            }
        }
        catch (MException | Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, e);
        }
    }

    public void update() {
        UpdateUserDialog obj = (UpdateUserDialog)((Object)this.of.create(UpdateUserDialog.class));
        User user = (User)this.tableUser.getSelectionModel().getSelectedItem();
        if (user == null) {
            return;
        }
        if ("U0000000001".equals(user.getId())) {
            this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u4fee\u6539\u6743\u9650");
            return;
        }
        User userSet = (User)this.of.create(User.class);
        userSet.update((Object)user);
        obj.setUser(userSet);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u7528\u6237");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            this.refreshTable();
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void enable() {
        try {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_USER, ALERT)) {
                this.userMng.enableUser(true, (User)this.tableUser.getSelectionModel().getSelectedItem());
                this.refreshTable();
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void disable() {
        try {
            if ("U0000000001".equals(((User)this.tableUser.getSelectionModel().getSelectedItem()).getId())) {
                this.mAlert.alert(Alert.AlertType.ERROR, "\u65e0\u4fee\u6539\u6743\u9650");
                return;
            }
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_USER, ALERT)) {
                this.userMng.enableUser(false, (User)this.tableUser.getSelectionModel().getSelectedItem());
                this.refreshTable();
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void userLock() {
        UserLockDialog obj = (UserLockDialog)((Object)this.of.create(UserLockDialog.class));
        if (obj == null) {
            return;
        }
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u7528\u6237\u9501\u5b9a");
            dialog.setBtnText(ButtonType.OK, "\u4fdd\u5b58");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            Button btnOK = dialog.getButton(ButtonType.OK);
            if (btnOK != null) {
                btnOK.disableProperty().bind((ObservableValue)obj.saveProperty().not());
            }
            dialog.launch();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableUser);
    }

    private class OperaCell
    extends TableCell<User, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            if (UserMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
                HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
            }
            if (UserMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    UserMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof User) {
                        User r = (User)OperaCell.this.getTableRow().getItem();
                        UserMngPart.this.selectTableUser = r;
                        if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            UserMngPart.this.enable();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            UserMngPart.this.disable();
                        }
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof User) {
                    User r = (User)this.getTableRow().getItem();
                    if ("\u505c\u7528".equals(r.getStatus().getValue())) {
                        this.statusLab.setText("\u542f\u7528");
                    } else {
                        this.statusLab.setText("\u505c\u7528");
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

