/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.UserLock;
import cms.tmx.entity.UserLockInfo;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.UserMngServiceImpl;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserLockDialog
extends DialogObj {
    @FXML
    private TextField txtCount;
    @FXML
    private TextField txtDuration;
    @FXML
    private TableView<UserLockInfo> tableUserLock;
    @FXML
    private TableColumn<UserLockInfo, String> index;
    @FXML
    private TableColumn<UserLockInfo, String> userName;
    @FXML
    private TableColumn<UserLockInfo, String> lockStartTime;
    @FXML
    private TableColumn<UserLockInfo, String> lockEndTime;
    @FXML
    private TableColumn<UserLockInfo, HBox> colOp;
    @FXML
    private Label lbCountErr;
    @FXML
    private Label lbDurationErr;
    @FXML
    private Label lbMessage;
    @Inject
    private UserMngServiceImpl userMng;
    private MxList<UserLockInfo> mlist = new MxList();
    private static final Logger logger = LogManager.getLogger(UserLockDialog.class);
    private BooleanProperty save = new SimpleBooleanProperty(false);

    @FXML
    public void initialize() {
        this.initValues();
        this.bind();
        this.createTableView();
    }

    private void bind() {
        this.txtCount.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 2));
        this.txtDuration.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 4));
        this.txtCount.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbCountErr.setOpacity(0.0);
            }
        });
        this.txtDuration.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbDurationErr.setOpacity(0.0);
            }
        });
        this.txtCount.textProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.save.set(true);
            }
        });
        this.txtDuration.textProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.save.set(true);
            }
        });
    }

    private void initValues() {
        try {
            UserLock lock = this.userMng.getUserLock();
            this.txtCount.setText(String.valueOf(lock.getMaxCount()));
            this.txtDuration.setText(String.valueOf(lock.getLockDuration() / 60L));
            this.mlist.update(lock.getList());
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createTableView() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.index.setSortable(false);
        this.userName.setCellValueFactory((Callback)new PropertyValueFactory("userName"));
        this.lockStartTime.setCellValueFactory(data -> this.setTime(((UserLockInfo)data.getValue()).getLockStartTime()));
        this.lockEndTime.setCellValueFactory(data -> this.setTime(((UserLockInfo)data.getValue()).getLockEndTime()));
        this.colOp.setCellValueFactory(data -> this.setOperate((UserLockInfo)data.getValue()));
        this.tableUserLock.setItems(this.mlist.getList());
    }

    private StringProperty setTime(long time) {
        SimpleStringProperty s = new SimpleStringProperty("");
        GregorianCalendar gc = new GregorianCalendar();
        long t = time;
        gc.setTimeInMillis(t * 1000L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        s.set((Object)format.format(gc.getTime()));
        return s;
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(UserLockInfo ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u89e3\u9501");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            try {
                this.userMng.unLockUser(ap.getUserId());
                this.mlist.remove((MxObject)ap);
            }
            catch (MException e) {
                this.lbMessage.setText(e.getMessage());
                logger.error((Object)e, (Throwable)e);
            }
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public boolean isOK(ButtonType bt) {
        if (this.txtCount.getText().isEmpty()) {
            this.lbCountErr.setText("\u8bf7\u8f93\u51651~99\u4e2d\u7684\u6570\u503c");
            this.lbCountErr.setOpacity(1.0);
        }
        if (this.txtDuration.getText().isEmpty()) {
            this.lbDurationErr.setText("\u8bf7\u8f93\u51651~1440\u4e2d\u7684\u6570\u503c");
            this.lbDurationErr.setOpacity(1.0);
            return false;
        }
        if (Integer.parseInt(this.txtDuration.getText()) > 1440) {
            this.lbDurationErr.setText("\u8bf7\u8f93\u51651~1440\u4e2d\u7684\u6570\u503c");
            this.lbDurationErr.setOpacity(1.0);
            return false;
        }
        int lockDuration = Integer.parseInt(this.txtDuration.getText()) * 60;
        int maxCount = Integer.parseInt(this.txtCount.getText());
        try {
            this.save.set(false);
            this.userMng.setUserLock(lockDuration, maxCount);
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            logger.error((Object)e, (Throwable)e);
            return false;
        }
        return false;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }
}

