/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.PwdExpiredCtrl;
import cms.tmx.entity.User;
import cms.tmx.entity.UserControl;
import cms.tmx.entity.UserControlResp;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.models.UserMngModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserControlTabContent
extends MxTabContent {
    @FXML
    private CheckBox cboxMac;
    @FXML
    private TextField txtMac;
    @FXML
    private Label lbMacError;
    @FXML
    private Button btnAddMac;
    @FXML
    private TableView<UserControl> tableMac;
    @FXML
    private TableColumn<UserControl, String> index;
    @FXML
    private TableColumn<UserControl, String> colMac;
    @FXML
    private TableColumn<UserControl, HBox> colOperaMac;
    @FXML
    private CheckBox cboxIp;
    @FXML
    private TextField txtIp;
    @FXML
    private Label lbIpError;
    @FXML
    private Button btnAddIp;
    @FXML
    private TableView<UserControl> tableIp;
    @FXML
    private TableColumn<UserControl, String> indexIp;
    @FXML
    private TableColumn<UserControl, String> colIp;
    @FXML
    private TableColumn<UserControl, HBox> colOperaIp;
    @FXML
    private TextField txtDays;
    @FXML
    private Label lbDaysErr;
    @FXML
    private Label lbMessage;
    @FXML
    private Label lbMessageSpec;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveUserControl;
    @Inject
    private UserMngModel userMngModel;
    @Inject
    private UserMngServiceImpl userMng;
    private ObservableList<UserControl> listMac = FxUtils.newList();
    private ObservableList<UserControl> listIp = FxUtils.newList();
    private User selectUser;
    private static final Logger logger = LogManager.getLogger(UserControlTabContent.class);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private static final int MAC = 1;
    private static final int IP = 2;

    @FXML
    public void initialize() {
        this.selectUser = this.userMngModel.getCommonUser();
        this.labSuccess.setVisible(false);
        this.addListener();
        this.initValues();
        this.createTableView();
        this.initBtn();
        this.initTextField();
    }

    private void initTextField() {
        this.txtMac.setTextFormatter((TextFormatter)new MxFormatter("^([0-9a-fA-F]{1,2})(([0-9a-fA-F]{0,2}){0,5})$", 12));
        this.txtIp.setTextFormatter((TextFormatter)new MxFormatter("^([0-9]{1,3})((\\.[0-9]{0,3}){0,3})$", 15));
    }

    private void initBtn() {
        this.btnAddIp.disableProperty().bind((ObservableValue)this.txtIp.textProperty().isEmpty());
        this.btnAddMac.disableProperty().bind((ObservableValue)this.txtMac.textProperty().isEmpty());
    }

    private void addListener() {
        this.txtMac.disableProperty().bind((ObservableValue)this.cboxMac.selectedProperty().not());
        this.tableMac.disableProperty().bind((ObservableValue)this.cboxMac.selectedProperty().not());
        this.txtIp.disableProperty().bind((ObservableValue)this.cboxIp.selectedProperty().not());
        this.tableIp.disableProperty().bind((ObservableValue)this.cboxIp.selectedProperty().not());
        this.cboxMac.selectedProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.save.set(true);
            }
        });
        this.cboxIp.selectedProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.save.set(true);
            }
        });
        this.lbMessageSpec.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.lbMessageSpec.setOpacity(0.0);
            }
        });
        this.txtMac.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbMacError.setOpacity(0.0);
                this.lbMacError.setText("");
            } else if (!this.txtMac.getText().isEmpty() && !StringUtils.isMac((String)this.txtMac.getText())) {
                this.lbMacError.setText("\u8bf7\u8f93\u5165\u6b63\u786eMac");
                this.lbMacError.setOpacity(1.0);
            } else if (!this.listMac.isEmpty() && this.listMac.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtMac.getText())).findFirst().isPresent()) {
                this.lbMacError.setText("Mac\u5df2\u5b58\u5728");
                this.lbMacError.setOpacity(1.0);
            } else {
                this.lbMacError.setText("");
                this.lbMacError.setOpacity(0.0);
            }
        });
        this.txtIp.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbIpError.setOpacity(0.0);
                this.lbIpError.setText("");
            } else if (!this.txtIp.getText().isEmpty() && !StringUtils.isIp((String)this.txtIp.getText())) {
                this.lbIpError.setText("\u8bf7\u8f93\u5165\u6b63\u786eIp");
                this.lbIpError.setOpacity(1.0);
            } else if (!this.listIp.isEmpty() && this.listIp.stream().filter(item -> item.getValue().equalsIgnoreCase(this.txtIp.getText())).findFirst().isPresent()) {
                this.lbIpError.setText("Ip\u5df2\u5b58\u5728");
                this.lbIpError.setOpacity(1.0);
            }
        });
    }

    private void initValues() {
        this.txtMac.setTooltip(new Tooltip("\u683c\u5f0f\u4f8b\u5982\uff1aA1B2C3D4E5F6"));
        this.txtIp.setTooltip(new Tooltip("\u683c\u5f0f\u4f8b\u5982\uff1a127.0.0.1"));
        this.lbMessageSpec.setText("\u52fe\u9009\u63a7\u5236\u7684IP\u6216MAC\u5730\u5740\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        try {
            UserControlResp userControl = this.userMng.getUserControl(this.selectUser.getId());
            List list = userControl.getList();
            PwdExpiredCtrl pwd = userControl.getPwd();
            Map<Integer, List<UserControl>> map = list.stream().collect(Collectors.groupingBy(UserControl::getType));
            LinkedList lm = map.get(1) == null ? new LinkedList() : map.get(1);
            LinkedList li = map.get(2) == null ? new LinkedList() : map.get(2);
            this.listMac = FXCollections.observableList(lm);
            this.listIp = FXCollections.observableList(li);
            if (pwd == null) {
                this.txtDays.setText("60");
            } else {
                MxBindings.bindSI((Property)this.txtDays.textProperty(), (Property)pwd.pwd_expired_durationProperty());
            }
            this.txtDays.setTextFormatter((TextFormatter)new MxFormatter("^([1-9]{1}\\d*)$", 3));
            this.registerCheck((Node)this.lbDaysErr, (ObservableBooleanValue)this.txtDays.textProperty().isNotEmpty());
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u7528\u6237\u63a7\u5236\u5f02\u5e38", (Throwable)e);
            this.lbMessage.setText(e.getMessage().isEmpty() ? "\u67e5\u8be2\u7528\u6237\u63a7\u5236\u5f02\u5e38" : e.getMessage());
        }
        this.cboxMac.setSelected(this.listMac.isEmpty() ? false : ((UserControl)this.listMac.get(0)).isFlag());
        this.cboxIp.setSelected(this.listIp.isEmpty() ? false : ((UserControl)this.listIp.get(0)).isFlag());
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        this.index.setSortable(false);
        TableUtils.isAuto(this.indexIp);
        this.indexIp.setSortable(false);
        this.colMac.setCellValueFactory(data -> ((UserControl)data.getValue()).valueProperty());
        this.colIp.setCellValueFactory(data -> ((UserControl)data.getValue()).valueProperty());
        this.colOperaMac.setCellValueFactory(data -> this.setOperateMac((UserControl)data.getValue()));
        this.colOperaIp.setCellValueFactory(data -> this.setOperateIp((UserControl)data.getValue()));
        this.tableMac.setPlaceholder((Node)new Label());
        this.tableIp.setPlaceholder((Node)new Label());
        this.tableMac.setItems(this.listMac);
        this.tableIp.setItems(this.listIp);
    }

    private ReadOnlyObjectWrapper<HBox> setOperateMac(UserControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            this.save.set(true);
            this.listMac.remove((Object)ap);
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private ReadOnlyObjectWrapper<HBox> setOperateIp(UserControl ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            this.save.set(true);
            this.listIp.remove((Object)ap);
        });
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    @FXML
    private void addMac() throws MException {
        if (!this.lbMacError.getText().isEmpty()) {
            return;
        }
        UserControl mac = new UserControl();
        mac.setType(1);
        mac.setValue(this.txtMac.getText().toUpperCase());
        this.listMac.add((Object)mac);
        this.txtMac.setText("");
        this.save.set(true);
    }

    @FXML
    private void addIp() throws MException {
        if (!this.lbIpError.getText().isEmpty()) {
            return;
        }
        UserControl ip = new UserControl();
        ip.setType(2);
        ip.setValue(this.txtIp.getText());
        this.listIp.add((Object)ip);
        this.txtIp.setText("");
        this.save.set(true);
    }

    @FXML
    public boolean saveUserControl() {
        if (!this.valid()) {
            return false;
        }
        if (this.listMac.size() == 0 && this.cboxMac.isSelected() || this.listIp.size() == 0 && this.cboxIp.isSelected()) {
            this.lbMessageSpec.setOpacity(1.0);
            Platform.runLater(() -> this.lbMessageSpec.requestFocus());
            return false;
        }
        LinkedList<UserControl> usercontrols = new LinkedList<UserControl>();
        PwdExpiredCtrl pwd = new PwdExpiredCtrl();
        if (!this.txtDays.getText().isEmpty()) {
            pwd.setPwd_expired_duration(Integer.parseInt(this.txtDays.getText()));
        }
        usercontrols.addAll((Collection<UserControl>)this.listMac);
        usercontrols.addAll((Collection<UserControl>)this.listIp);
        try {
            this.save.set(false);
            this.userMng.updateUserControl(usercontrols, this.selectUser.getId(), this.cboxMac.isSelected(), this.cboxIp.isSelected(), pwd);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbMessage.setText(String.valueOf(e2.getMessage()) + "\uff0c\u4fdd\u5b58\u5931\u8d25");
                this.lbMessage.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public User getSelectUser() {
        return this.selectUser;
    }

    public void setSelectUser(User selectUser) {
        this.selectUser = selectUser;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }
}

