/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.User;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.UserMngModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.ResetPwdDialog;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateUserBasic
extends MxTabContent {
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private Label lbTypeErr;
    @FXML
    private TextField txtName;
    @FXML
    private Label lbNameErr;
    @FXML
    private TextField txtCreditName;
    @FXML
    private Label lbCreditNameErr;
    @FXML
    private TextField txtPhone;
    @FXML
    private Label lbPhoneErr;
    @FXML
    private TextField txtID;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbCodeErr;
    @FXML
    private TextField txtAddr;
    @FXML
    private TextField txtId;
    @FXML
    private TextField txtEmail;
    @FXML
    private Label lbEmailErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @FXML
    private Button btnResetPwd;
    @FXML
    private GridPane pane;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private UserMngModel userModel;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    private User user;
    private static final Logger logger = LogManager.getLogger(UpdateUserBasic.class);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.user = this.userModel.getCommonUser();
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.user.nameProperty());
        this.txtCreditName.textProperty().bindBidirectional((Property)this.user.useCreditNameProperty());
        this.txtPhone.textProperty().bindBidirectional((Property)this.user.phoneProperty());
        this.txtCode.textProperty().bindBidirectional((Property)this.user.codeProperty());
        this.txtAddr.textProperty().bindBidirectional((Property)this.user.addressProperty());
        this.txtEmail.textProperty().bindBidirectional((Property)this.user.emailProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.user.userCreditTypeProperty());
        this.txtId.textProperty().bindBidirectional((Property)this.user.idProperty());
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtCreditName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtPhone.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.txtCode.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
        this.txtEmail.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\\-.@]{0,50}", 1000));
        this.txtAddr.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCreditNameErr, (ObservableBooleanValue)this.txtCreditName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPhoneErr, (ObservableBooleanValue)this.txtPhone.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)this.txtCode.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbEmailErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!(this.txtEmail.getText().isEmpty() || this.txtEmail.focusedProperty().get() || TextFieldUtils.isEmail((String)this.txtEmail.getText()))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtEmail.focusedProperty()}));
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtAddr.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"user_credit_type", (String)"1");
        this.cmbType.setItems(node.getNodes());
        Platform.runLater(() -> this.txtName.requestFocus());
    }

    @FXML
    public void resetPwd() {
        ResetPwdDialog obj = (ResetPwdDialog)((Object)this.of.create(ResetPwdDialog.class));
        if (this.user == null) {
            return;
        }
        obj.setUser(this.user);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u91cd\u7f6e\u5bc6\u7801");
        dialog.initOwner(this.btnResetPwd.getScene().getWindow());
        dialog.launch();
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            this.userMng.updateUser(this.user);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        Platform.runLater(() -> {
            this.labSuccess.setVisible(true);
            this.lbAlert.requestFocus();
        });
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextField getTxtAddr() {
        return this.txtAddr;
    }

    public void setTxtAddr(TextField txtAddr) {
        this.txtAddr = txtAddr;
    }

    public TextField getTxtEmail() {
        return this.txtEmail;
    }

    public void setTxtEmail(TextField txtEmail) {
        this.txtEmail = txtEmail;
    }

    public TextField getTxtID() {
        return this.txtID;
    }

    public void setTxtID(TextField txtID) {
        this.txtID = txtID;
    }

    public Button getBtnResetPwd() {
        return this.btnResetPwd;
    }

    public void setBtnResetPwd(Button btnResetPwd) {
        this.btnResetPwd = btnResetPwd;
    }

    public GridPane getPane() {
        return this.pane;
    }

    public void setPane(GridPane pane) {
        this.pane = pane;
    }
}

